/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output
 * during the conversion process.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Preset implements SdkPojo, Serializable, ToCopyableBuilder<Preset.Builder, Preset> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Preset::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(Preset::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(Preset::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Preset::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated")
            .getter(getter(Preset::lastUpdated))
            .setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Preset::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<PresetSettings> SETTINGS_FIELD = SdkField.<PresetSettings> builder(MarshallingType.SDK_POJO)
            .memberName("Settings").getter(getter(Preset::settings)).setter(setter(Builder::settings))
            .constructor(PresetSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Preset::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CATEGORY_FIELD,
            CREATED_AT_FIELD, DESCRIPTION_FIELD, LAST_UPDATED_FIELD, NAME_FIELD, SETTINGS_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String category;

    private final Instant createdAt;

    private final String description;

    private final Instant lastUpdated;

    private final String name;

    private final PresetSettings settings;

    private final String type;

    private Preset(BuilderImpl builder) {
        this.arn = builder.arn;
        this.category = builder.category;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastUpdated = builder.lastUpdated;
        this.name = builder.name;
        this.settings = builder.settings;
        this.type = builder.type;
    }

    /**
     * An identifier for this resource that is unique within all of AWS.
     * 
     * @return An identifier for this resource that is unique within all of AWS.
     */
    public final String arn() {
        return arn;
    }

    /**
     * An optional category you create to organize your presets.
     * 
     * @return An optional category you create to organize your presets.
     */
    public final String category() {
        return category;
    }

    /**
     * The timestamp in epoch seconds for preset creation.
     * 
     * @return The timestamp in epoch seconds for preset creation.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * An optional description you create for each preset.
     * 
     * @return An optional description you create for each preset.
     */
    public final String description() {
        return description;
    }

    /**
     * The timestamp in epoch seconds when the preset was last updated.
     * 
     * @return The timestamp in epoch seconds when the preset was last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * A name you create for each preset. Each name must be unique within your account.
     * 
     * @return A name you create for each preset. Each name must be unique within your account.
     */
    public final String name() {
        return name;
    }

    /**
     * Settings for preset
     * 
     * @return Settings for preset
     */
    public final PresetSettings settings() {
        return settings;
    }

    /**
     * A preset can be of two types: system or custom. System or built-in preset can't be modified or deleted by the
     * user.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return A preset can be of two types: system or custom. System or built-in preset can't be modified or deleted by
     *         the user.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * A preset can be of two types: system or custom. System or built-in preset can't be modified or deleted by the
     * user.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return A preset can be of two types: system or custom. System or built-in preset can't be modified or deleted by
     *         the user.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Preset)) {
            return false;
        }
        Preset other = (Preset) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(category(), other.category())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(name(), other.name())
                && Objects.equals(settings(), other.settings()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Preset").add("Arn", arn()).add("Category", category()).add("CreatedAt", createdAt())
                .add("Description", description()).add("LastUpdated", lastUpdated()).add("Name", name())
                .add("Settings", settings()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Preset, T> g) {
        return obj -> g.apply((Preset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Preset> {
        /**
         * An identifier for this resource that is unique within all of AWS.
         * 
         * @param arn
         *        An identifier for this resource that is unique within all of AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * An optional category you create to organize your presets.
         * 
         * @param category
         *        An optional category you create to organize your presets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * The timestamp in epoch seconds for preset creation.
         * 
         * @param createdAt
         *        The timestamp in epoch seconds for preset creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * An optional description you create for each preset.
         * 
         * @param description
         *        An optional description you create for each preset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The timestamp in epoch seconds when the preset was last updated.
         * 
         * @param lastUpdated
         *        The timestamp in epoch seconds when the preset was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * A name you create for each preset. Each name must be unique within your account.
         * 
         * @param name
         *        A name you create for each preset. Each name must be unique within your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Settings for preset
         * 
         * @param settings
         *        Settings for preset
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(PresetSettings settings);

        /**
         * Settings for preset This is a convenience method that creates an instance of the
         * {@link PresetSettings.Builder} avoiding the need to create one manually via {@link PresetSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link PresetSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #settings(PresetSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link PresetSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(PresetSettings)
         */
        default Builder settings(Consumer<PresetSettings.Builder> settings) {
            return settings(PresetSettings.builder().applyMutation(settings).build());
        }

        /**
         * A preset can be of two types: system or custom. System or built-in preset can't be modified or deleted by the
         * user.
         * 
         * @param type
         *        A preset can be of two types: system or custom. System or built-in preset can't be modified or deleted
         *        by the user.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * A preset can be of two types: system or custom. System or built-in preset can't be modified or deleted by the
         * user.
         * 
         * @param type
         *        A preset can be of two types: system or custom. System or built-in preset can't be modified or deleted
         *        by the user.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String category;

        private Instant createdAt;

        private String description;

        private Instant lastUpdated;

        private String name;

        private PresetSettings settings;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Preset model) {
            arn(model.arn);
            category(model.category);
            createdAt(model.createdAt);
            description(model.description);
            lastUpdated(model.lastUpdated);
            name(model.name);
            settings(model.settings);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PresetSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(PresetSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(PresetSettings settings) {
            this.settings = settings;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Preset build() {
            return new Preset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
