/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJobTemplateRequest extends MediaConvertRequest implements
        ToCopyableBuilder<UpdateJobTemplateRequest.Builder, UpdateJobTemplateRequest> {
    private static final SdkField<AccelerationSettings> ACCELERATION_SETTINGS_FIELD = SdkField
            .<AccelerationSettings> builder(MarshallingType.SDK_POJO).memberName("AccelerationSettings")
            .getter(getter(UpdateJobTemplateRequest::accelerationSettings)).setter(setter(Builder::accelerationSettings))
            .constructor(AccelerationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerationSettings").build())
            .build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(UpdateJobTemplateRequest::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateJobTemplateRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<HopDestination>> HOP_DESTINATIONS_FIELD = SdkField
            .<List<HopDestination>> builder(MarshallingType.LIST)
            .memberName("HopDestinations")
            .getter(getter(UpdateJobTemplateRequest::hopDestinations))
            .setter(setter(Builder::hopDestinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hopDestinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HopDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(HopDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateJobTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(UpdateJobTemplateRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Queue")
            .getter(getter(UpdateJobTemplateRequest::queue)).setter(setter(Builder::queue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()).build();

    private static final SdkField<JobTemplateSettings> SETTINGS_FIELD = SdkField
            .<JobTemplateSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(UpdateJobTemplateRequest::settings)).setter(setter(Builder::settings))
            .constructor(JobTemplateSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()).build();

    private static final SdkField<String> STATUS_UPDATE_INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusUpdateInterval").getter(getter(UpdateJobTemplateRequest::statusUpdateIntervalAsString))
            .setter(setter(Builder::statusUpdateInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusUpdateInterval").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATION_SETTINGS_FIELD,
            CATEGORY_FIELD, DESCRIPTION_FIELD, HOP_DESTINATIONS_FIELD, NAME_FIELD, PRIORITY_FIELD, QUEUE_FIELD, SETTINGS_FIELD,
            STATUS_UPDATE_INTERVAL_FIELD));

    private final AccelerationSettings accelerationSettings;

    private final String category;

    private final String description;

    private final List<HopDestination> hopDestinations;

    private final String name;

    private final Integer priority;

    private final String queue;

    private final JobTemplateSettings settings;

    private final String statusUpdateInterval;

    private UpdateJobTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.accelerationSettings = builder.accelerationSettings;
        this.category = builder.category;
        this.description = builder.description;
        this.hopDestinations = builder.hopDestinations;
        this.name = builder.name;
        this.priority = builder.priority;
        this.queue = builder.queue;
        this.settings = builder.settings;
        this.statusUpdateInterval = builder.statusUpdateInterval;
    }

    /**
     * Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use
     * this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental
     * MediaConvert User Guide.
     * 
     * @return Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that
     *         use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental
     *         MediaConvert User Guide.
     */
    public final AccelerationSettings accelerationSettings() {
        return accelerationSettings;
    }

    /**
     * The new category for the job template, if you are changing it.
     * 
     * @return The new category for the job template, if you are changing it.
     */
    public final String category() {
        return category;
    }

    /**
     * The new description for the job template, if you are changing it.
     * 
     * @return The new description for the job template, if you are changing it.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the HopDestinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHopDestinations() {
        return hopDestinations != null && !(hopDestinations instanceof SdkAutoConstructList);
    }

    /**
     * Optional list of hop destinations.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHopDestinations} method.
     * </p>
     * 
     * @return Optional list of hop destinations.
     */
    public final List<HopDestination> hopDestinations() {
        return hopDestinations;
    }

    /**
     * The name of the job template you are modifying
     * 
     * @return The name of the job template you are modifying
     */
    public final String name() {
        return name;
    }

    /**
     * Specify the relative priority for this job. In any given queue, the service begins processing the job with the
     * highest value first. When more than one job has the same priority, the service begins processing the job that you
     * submitted first. If you don't specify a priority, the service uses the default value 0.
     * 
     * @return Specify the relative priority for this job. In any given queue, the service begins processing the job
     *         with the highest value first. When more than one job has the same priority, the service begins processing
     *         the job that you submitted first. If you don't specify a priority, the service uses the default value 0.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * The new queue for the job template, if you are changing it.
     * 
     * @return The new queue for the job template, if you are changing it.
     */
    public final String queue() {
        return queue;
    }

    /**
     * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs
     * created from it.
     * 
     * @return JobTemplateSettings contains all the transcode settings saved in the template that will be applied to
     *         jobs created from it.
     */
    public final JobTemplateSettings settings() {
        return settings;
    }

    /**
     * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in
     * seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins
     * processing your job to the time it completes the transcode or encounters an error.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #statusUpdateInterval} will return {@link StatusUpdateInterval#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #statusUpdateIntervalAsString}.
     * </p>
     * 
     * @return Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval,
     *         in seconds, between status updates. MediaConvert sends an update at this interval from the time the
     *         service begins processing your job to the time it completes the transcode or encounters an error.
     * @see StatusUpdateInterval
     */
    public final StatusUpdateInterval statusUpdateInterval() {
        return StatusUpdateInterval.fromValue(statusUpdateInterval);
    }

    /**
     * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in
     * seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins
     * processing your job to the time it completes the transcode or encounters an error.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #statusUpdateInterval} will return {@link StatusUpdateInterval#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #statusUpdateIntervalAsString}.
     * </p>
     * 
     * @return Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval,
     *         in seconds, between status updates. MediaConvert sends an update at this interval from the time the
     *         service begins processing your job to the time it completes the transcode or encounters an error.
     * @see StatusUpdateInterval
     */
    public final String statusUpdateIntervalAsString() {
        return statusUpdateInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accelerationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasHopDestinations() ? hopDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(queue());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(statusUpdateIntervalAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobTemplateRequest)) {
            return false;
        }
        UpdateJobTemplateRequest other = (UpdateJobTemplateRequest) obj;
        return Objects.equals(accelerationSettings(), other.accelerationSettings())
                && Objects.equals(category(), other.category()) && Objects.equals(description(), other.description())
                && hasHopDestinations() == other.hasHopDestinations()
                && Objects.equals(hopDestinations(), other.hopDestinations()) && Objects.equals(name(), other.name())
                && Objects.equals(priority(), other.priority()) && Objects.equals(queue(), other.queue())
                && Objects.equals(settings(), other.settings())
                && Objects.equals(statusUpdateIntervalAsString(), other.statusUpdateIntervalAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateJobTemplateRequest").add("AccelerationSettings", accelerationSettings())
                .add("Category", category()).add("Description", description())
                .add("HopDestinations", hasHopDestinations() ? hopDestinations() : null).add("Name", name())
                .add("Priority", priority()).add("Queue", queue()).add("Settings", settings())
                .add("StatusUpdateInterval", statusUpdateIntervalAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccelerationSettings":
            return Optional.ofNullable(clazz.cast(accelerationSettings()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HopDestinations":
            return Optional.ofNullable(clazz.cast(hopDestinations()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Queue":
            return Optional.ofNullable(clazz.cast(queue()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "StatusUpdateInterval":
            return Optional.ofNullable(clazz.cast(statusUpdateIntervalAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobTemplateRequest, T> g) {
        return obj -> g.apply((UpdateJobTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateJobTemplateRequest> {
        /**
         * Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use
         * this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental
         * MediaConvert User Guide.
         * 
         * @param accelerationSettings
         *        Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs
         *        that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS
         *        Elemental MediaConvert User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerationSettings(AccelerationSettings accelerationSettings);

        /**
         * Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use
         * this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental
         * MediaConvert User Guide. This is a convenience method that creates an instance of the
         * {@link AccelerationSettings.Builder} avoiding the need to create one manually via
         * {@link AccelerationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccelerationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #accelerationSettings(AccelerationSettings)}.
         * 
         * @param accelerationSettings
         *        a consumer that will call methods on {@link AccelerationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accelerationSettings(AccelerationSettings)
         */
        default Builder accelerationSettings(Consumer<AccelerationSettings.Builder> accelerationSettings) {
            return accelerationSettings(AccelerationSettings.builder().applyMutation(accelerationSettings).build());
        }

        /**
         * The new category for the job template, if you are changing it.
         * 
         * @param category
         *        The new category for the job template, if you are changing it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * The new description for the job template, if you are changing it.
         * 
         * @param description
         *        The new description for the job template, if you are changing it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Optional list of hop destinations.
         * 
         * @param hopDestinations
         *        Optional list of hop destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hopDestinations(Collection<HopDestination> hopDestinations);

        /**
         * Optional list of hop destinations.
         * 
         * @param hopDestinations
         *        Optional list of hop destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hopDestinations(HopDestination... hopDestinations);

        /**
         * Optional list of hop destinations. This is a convenience method that creates an instance of the {@link List
         * <HopDestination>.Builder} avoiding the need to create one manually via {@link List<HopDestination>#builder()}
         * .
         *
         * When the {@link Consumer} completes, {@link List<HopDestination>.Builder#build()} is called immediately and
         * its result is passed to {@link #hopDestinations(List<HopDestination>)}.
         * 
         * @param hopDestinations
         *        a consumer that will call methods on {@link List<HopDestination>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hopDestinations(List<HopDestination>)
         */
        Builder hopDestinations(Consumer<HopDestination.Builder>... hopDestinations);

        /**
         * The name of the job template you are modifying
         * 
         * @param name
         *        The name of the job template you are modifying
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Specify the relative priority for this job. In any given queue, the service begins processing the job with
         * the highest value first. When more than one job has the same priority, the service begins processing the job
         * that you submitted first. If you don't specify a priority, the service uses the default value 0.
         * 
         * @param priority
         *        Specify the relative priority for this job. In any given queue, the service begins processing the job
         *        with the highest value first. When more than one job has the same priority, the service begins
         *        processing the job that you submitted first. If you don't specify a priority, the service uses the
         *        default value 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * The new queue for the job template, if you are changing it.
         * 
         * @param queue
         *        The new queue for the job template, if you are changing it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queue(String queue);

        /**
         * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs
         * created from it.
         * 
         * @param settings
         *        JobTemplateSettings contains all the transcode settings saved in the template that will be applied to
         *        jobs created from it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(JobTemplateSettings settings);

        /**
         * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs
         * created from it. This is a convenience method that creates an instance of the
         * {@link JobTemplateSettings.Builder} avoiding the need to create one manually via
         * {@link JobTemplateSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobTemplateSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #settings(JobTemplateSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link JobTemplateSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(JobTemplateSettings)
         */
        default Builder settings(Consumer<JobTemplateSettings.Builder> settings) {
            return settings(JobTemplateSettings.builder().applyMutation(settings).build());
        }

        /**
         * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in
         * seconds, between status updates. MediaConvert sends an update at this interval from the time the service
         * begins processing your job to the time it completes the transcode or encounters an error.
         * 
         * @param statusUpdateInterval
         *        Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the
         *        interval, in seconds, between status updates. MediaConvert sends an update at this interval from the
         *        time the service begins processing your job to the time it completes the transcode or encounters an
         *        error.
         * @see StatusUpdateInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusUpdateInterval
         */
        Builder statusUpdateInterval(String statusUpdateInterval);

        /**
         * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in
         * seconds, between status updates. MediaConvert sends an update at this interval from the time the service
         * begins processing your job to the time it completes the transcode or encounters an error.
         * 
         * @param statusUpdateInterval
         *        Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the
         *        interval, in seconds, between status updates. MediaConvert sends an update at this interval from the
         *        time the service begins processing your job to the time it completes the transcode or encounters an
         *        error.
         * @see StatusUpdateInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusUpdateInterval
         */
        Builder statusUpdateInterval(StatusUpdateInterval statusUpdateInterval);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConvertRequest.BuilderImpl implements Builder {
        private AccelerationSettings accelerationSettings;

        private String category;

        private String description;

        private List<HopDestination> hopDestinations = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private Integer priority;

        private String queue;

        private JobTemplateSettings settings;

        private String statusUpdateInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobTemplateRequest model) {
            super(model);
            accelerationSettings(model.accelerationSettings);
            category(model.category);
            description(model.description);
            hopDestinations(model.hopDestinations);
            name(model.name);
            priority(model.priority);
            queue(model.queue);
            settings(model.settings);
            statusUpdateInterval(model.statusUpdateInterval);
        }

        public final AccelerationSettings.Builder getAccelerationSettings() {
            return accelerationSettings != null ? accelerationSettings.toBuilder() : null;
        }

        public final void setAccelerationSettings(AccelerationSettings.BuilderImpl accelerationSettings) {
            this.accelerationSettings = accelerationSettings != null ? accelerationSettings.build() : null;
        }

        @Override
        public final Builder accelerationSettings(AccelerationSettings accelerationSettings) {
            this.accelerationSettings = accelerationSettings;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<HopDestination.Builder> getHopDestinations() {
            List<HopDestination.Builder> result = ___listOfHopDestinationCopier.copyToBuilder(this.hopDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHopDestinations(Collection<HopDestination.BuilderImpl> hopDestinations) {
            this.hopDestinations = ___listOfHopDestinationCopier.copyFromBuilder(hopDestinations);
        }

        @Override
        public final Builder hopDestinations(Collection<HopDestination> hopDestinations) {
            this.hopDestinations = ___listOfHopDestinationCopier.copy(hopDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hopDestinations(HopDestination... hopDestinations) {
            hopDestinations(Arrays.asList(hopDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hopDestinations(Consumer<HopDestination.Builder>... hopDestinations) {
            hopDestinations(Stream.of(hopDestinations).map(c -> HopDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getQueue() {
            return queue;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final JobTemplateSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(JobTemplateSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(JobTemplateSettings settings) {
            this.settings = settings;
            return this;
        }

        public final String getStatusUpdateInterval() {
            return statusUpdateInterval;
        }

        public final void setStatusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
        }

        @Override
        public final Builder statusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
            return this;
        }

        @Override
        public final Builder statusUpdateInterval(StatusUpdateInterval statusUpdateInterval) {
            this.statusUpdateInterval(statusUpdateInterval == null ? null : statusUpdateInterval.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobTemplateRequest build() {
            return new UpdateJobTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
