/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePresetRequest extends MediaConvertRequest implements
        ToCopyableBuilder<UpdatePresetRequest.Builder, UpdatePresetRequest> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(UpdatePresetRequest::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdatePresetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdatePresetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<PresetSettings> SETTINGS_FIELD = SdkField.<PresetSettings> builder(MarshallingType.SDK_POJO)
            .memberName("Settings").getter(getter(UpdatePresetRequest::settings)).setter(setter(Builder::settings))
            .constructor(PresetSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, SETTINGS_FIELD));

    private final String category;

    private final String description;

    private final String name;

    private final PresetSettings settings;

    private UpdatePresetRequest(BuilderImpl builder) {
        super(builder);
        this.category = builder.category;
        this.description = builder.description;
        this.name = builder.name;
        this.settings = builder.settings;
    }

    /**
     * The new category for the preset, if you are changing it.
     * 
     * @return The new category for the preset, if you are changing it.
     */
    public final String category() {
        return category;
    }

    /**
     * The new description for the preset, if you are changing it.
     * 
     * @return The new description for the preset, if you are changing it.
     */
    public final String description() {
        return description;
    }

    /**
     * The name of the preset you are modifying.
     * 
     * @return The name of the preset you are modifying.
     */
    public final String name() {
        return name;
    }

    /**
     * Settings for preset
     * 
     * @return Settings for preset
     */
    public final PresetSettings settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePresetRequest)) {
            return false;
        }
        UpdatePresetRequest other = (UpdatePresetRequest) obj;
        return Objects.equals(category(), other.category()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && Objects.equals(settings(), other.settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePresetRequest").add("Category", category()).add("Description", description())
                .add("Name", name()).add("Settings", settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePresetRequest, T> g) {
        return obj -> g.apply((UpdatePresetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePresetRequest> {
        /**
         * The new category for the preset, if you are changing it.
         * 
         * @param category
         *        The new category for the preset, if you are changing it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * The new description for the preset, if you are changing it.
         * 
         * @param description
         *        The new description for the preset, if you are changing it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The name of the preset you are modifying.
         * 
         * @param name
         *        The name of the preset you are modifying.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Settings for preset
         * 
         * @param settings
         *        Settings for preset
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(PresetSettings settings);

        /**
         * Settings for preset This is a convenience method that creates an instance of the
         * {@link PresetSettings.Builder} avoiding the need to create one manually via {@link PresetSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link PresetSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #settings(PresetSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link PresetSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(PresetSettings)
         */
        default Builder settings(Consumer<PresetSettings.Builder> settings) {
            return settings(PresetSettings.builder().applyMutation(settings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConvertRequest.BuilderImpl implements Builder {
        private String category;

        private String description;

        private String name;

        private PresetSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePresetRequest model) {
            super(model);
            category(model.category);
            description(model.description);
            name(model.name);
            settings(model.settings);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PresetSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(PresetSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(PresetSettings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePresetRequest build() {
            return new UpdatePresetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
