/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive
 * quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of
 * quantization for your video content. Include this setting in your JSON job specification only when you choose to
 * change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop.
 * I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many
 * times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates
 * these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related
 * setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a
 * value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker
 * adaptive quantization provides.
 */
@Generated("software.amazon.awssdk:codegen")
public enum XavcFlickerAdaptiveQuantization {
    DISABLED("DISABLED"),

    ENABLED("ENABLED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, XavcFlickerAdaptiveQuantization> VALUE_MAP = EnumUtils.uniqueIndex(
            XavcFlickerAdaptiveQuantization.class, XavcFlickerAdaptiveQuantization::toString);

    private final String value;

    private XavcFlickerAdaptiveQuantization(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return XavcFlickerAdaptiveQuantization corresponding to the value
     */
    public static XavcFlickerAdaptiveQuantization fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link XavcFlickerAdaptiveQuantization}s
     */
    public static Set<XavcFlickerAdaptiveQuantization> knownValues() {
        Set<XavcFlickerAdaptiveQuantization> knownValues = EnumSet.allOf(XavcFlickerAdaptiveQuantization.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
