/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify whether to flag this audio track as descriptive video service (DVS) in your HLS parent manifest. When you
 * choose Flag (FLAG), MediaConvert includes the parameter CHARACTERISTICS="public.accessibility.describes-video" in the
 * EXT-X-MEDIA entry for this track. When you keep the default choice, Don't flag (DONT_FLAG), MediaConvert leaves this
 * parameter out. The DVS flag can help with accessibility on Apple devices. For more information, see the Apple
 * documentation.
 */
@Generated("software.amazon.awssdk:codegen")
public enum CmfcDescriptiveVideoServiceFlag {
    DONT_FLAG("DONT_FLAG"),

    FLAG("FLAG"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CmfcDescriptiveVideoServiceFlag> VALUE_MAP = EnumUtils.uniqueIndex(
            CmfcDescriptiveVideoServiceFlag.class, CmfcDescriptiveVideoServiceFlag::toString);

    private final String value;

    private CmfcDescriptiveVideoServiceFlag(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CmfcDescriptiveVideoServiceFlag corresponding to the value
     */
    public static CmfcDescriptiveVideoServiceFlag fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CmfcDescriptiveVideoServiceFlag}s
     */
    public static Set<CmfcDescriptiveVideoServiceFlag> knownValues() {
        Set<CmfcDescriptiveVideoServiceFlag> knownValues = EnumSet.allOf(CmfcDescriptiveVideoServiceFlag.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
