/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for color correction.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColorCorrector implements SdkPojo, Serializable, ToCopyableBuilder<ColorCorrector.Builder, ColorCorrector> {
    private static final SdkField<Integer> BRIGHTNESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Brightness").getter(getter(ColorCorrector::brightness)).setter(setter(Builder::brightness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brightness").build()).build();

    private static final SdkField<String> COLOR_SPACE_CONVERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColorSpaceConversion").getter(getter(ColorCorrector::colorSpaceConversionAsString))
            .setter(setter(Builder::colorSpaceConversion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceConversion").build())
            .build();

    private static final SdkField<Integer> CONTRAST_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Contrast").getter(getter(ColorCorrector::contrast)).setter(setter(Builder::contrast))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contrast").build()).build();

    private static final SdkField<Hdr10Metadata> HDR10_METADATA_FIELD = SdkField
            .<Hdr10Metadata> builder(MarshallingType.SDK_POJO).memberName("Hdr10Metadata")
            .getter(getter(ColorCorrector::hdr10Metadata)).setter(setter(Builder::hdr10Metadata))
            .constructor(Hdr10Metadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hdr10Metadata").build()).build();

    private static final SdkField<Integer> HUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Hue")
            .getter(getter(ColorCorrector::hue)).setter(setter(Builder::hue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hue").build()).build();

    private static final SdkField<String> SAMPLE_RANGE_CONVERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SampleRangeConversion").getter(getter(ColorCorrector::sampleRangeConversionAsString))
            .setter(setter(Builder::sampleRangeConversion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRangeConversion").build())
            .build();

    private static final SdkField<Integer> SATURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Saturation").getter(getter(ColorCorrector::saturation)).setter(setter(Builder::saturation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("saturation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIGHTNESS_FIELD,
            COLOR_SPACE_CONVERSION_FIELD, CONTRAST_FIELD, HDR10_METADATA_FIELD, HUE_FIELD, SAMPLE_RANGE_CONVERSION_FIELD,
            SATURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer brightness;

    private final String colorSpaceConversion;

    private final Integer contrast;

    private final Hdr10Metadata hdr10Metadata;

    private final Integer hue;

    private final String sampleRangeConversion;

    private final Integer saturation;

    private ColorCorrector(BuilderImpl builder) {
        this.brightness = builder.brightness;
        this.colorSpaceConversion = builder.colorSpaceConversion;
        this.contrast = builder.contrast;
        this.hdr10Metadata = builder.hdr10Metadata;
        this.hue = builder.hue;
        this.sampleRangeConversion = builder.sampleRangeConversion;
        this.saturation = builder.saturation;
    }

    /**
     * Brightness level.
     * 
     * @return Brightness level.
     */
    public final Integer brightness() {
        return brightness;
    }

    /**
     * Specify the color space you want for this output. The service supports conversion between HDR formats, between
     * SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the dynamic range. The
     * converted video has an HDR format, but visually appears the same as an unconverted output. HDR to SDR conversion
     * uses Elemental tone mapping technology to approximate the outcome of manually regrading from HDR to SDR.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #colorSpaceConversion} will return {@link ColorSpaceConversion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #colorSpaceConversionAsString}.
     * </p>
     * 
     * @return Specify the color space you want for this output. The service supports conversion between HDR formats,
     *         between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the
     *         dynamic range. The converted video has an HDR format, but visually appears the same as an unconverted
     *         output. HDR to SDR conversion uses Elemental tone mapping technology to approximate the outcome of
     *         manually regrading from HDR to SDR.
     * @see ColorSpaceConversion
     */
    public final ColorSpaceConversion colorSpaceConversion() {
        return ColorSpaceConversion.fromValue(colorSpaceConversion);
    }

    /**
     * Specify the color space you want for this output. The service supports conversion between HDR formats, between
     * SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the dynamic range. The
     * converted video has an HDR format, but visually appears the same as an unconverted output. HDR to SDR conversion
     * uses Elemental tone mapping technology to approximate the outcome of manually regrading from HDR to SDR.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #colorSpaceConversion} will return {@link ColorSpaceConversion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #colorSpaceConversionAsString}.
     * </p>
     * 
     * @return Specify the color space you want for this output. The service supports conversion between HDR formats,
     *         between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the
     *         dynamic range. The converted video has an HDR format, but visually appears the same as an unconverted
     *         output. HDR to SDR conversion uses Elemental tone mapping technology to approximate the outcome of
     *         manually regrading from HDR to SDR.
     * @see ColorSpaceConversion
     */
    public final String colorSpaceConversionAsString() {
        return colorSpaceConversion;
    }

    /**
     * Contrast level.
     * 
     * @return Contrast level.
     */
    public final Integer contrast() {
        return contrast;
    }

    /**
     * Use these settings when you convert to the HDR 10 color space. Specify the SMPTE ST 2086 Mastering Display Color
     * Volume static metadata that you want signaled in the output. These values don't affect the pixel values that are
     * encoded in the video stream. They are intended to help the downstream video player display content in a way that
     * reflects the intentions of the the content creator. When you set Color space conversion (ColorSpaceConversion) to
     * HDR 10 (FORCE_HDR10), these settings are required. You must set values for Max frame average light level
     * (maxFrameAverageLightLevel) and Max content light level (maxContentLightLevel); these settings don't have a
     * default value. The default values for the other HDR 10 metadata settings are defined by the P3D65 color space.
     * For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
     * 
     * @return Use these settings when you convert to the HDR 10 color space. Specify the SMPTE ST 2086 Mastering
     *         Display Color Volume static metadata that you want signaled in the output. These values don't affect the
     *         pixel values that are encoded in the video stream. They are intended to help the downstream video player
     *         display content in a way that reflects the intentions of the the content creator. When you set Color
     *         space conversion (ColorSpaceConversion) to HDR 10 (FORCE_HDR10), these settings are required. You must
     *         set values for Max frame average light level (maxFrameAverageLightLevel) and Max content light level
     *         (maxContentLightLevel); these settings don't have a default value. The default values for the other HDR
     *         10 metadata settings are defined by the P3D65 color space. For more information about MediaConvert HDR
     *         jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
     */
    public final Hdr10Metadata hdr10Metadata() {
        return hdr10Metadata;
    }

    /**
     * Hue in degrees.
     * 
     * @return Hue in degrees.
     */
    public final Integer hue() {
        return hue;
    }

    /**
     * Specify the video color sample range for this output. To create a full range output, you must start with a full
     * range YUV input and keep the default value, None (NONE). To create a limited range output from a full range
     * input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is always limited range,
     * regardless of your choice here. When you create a limited range output from a full range input, MediaConvert
     * limits the active pixel values in a way that depends on the output's bit depth: 8-bit outputs contain only values
     * from 16 through 235 and 10-bit outputs contain only values from 64 through 940. With this conversion,
     * MediaConvert also changes the output metadata to note the limited range.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sampleRangeConversion} will return {@link SampleRangeConversion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sampleRangeConversionAsString}.
     * </p>
     * 
     * @return Specify the video color sample range for this output. To create a full range output, you must start with
     *         a full range YUV input and keep the default value, None (NONE). To create a limited range output from a
     *         full range input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is always
     *         limited range, regardless of your choice here. When you create a limited range output from a full range
     *         input, MediaConvert limits the active pixel values in a way that depends on the output's bit depth: 8-bit
     *         outputs contain only values from 16 through 235 and 10-bit outputs contain only values from 64 through
     *         940. With this conversion, MediaConvert also changes the output metadata to note the limited range.
     * @see SampleRangeConversion
     */
    public final SampleRangeConversion sampleRangeConversion() {
        return SampleRangeConversion.fromValue(sampleRangeConversion);
    }

    /**
     * Specify the video color sample range for this output. To create a full range output, you must start with a full
     * range YUV input and keep the default value, None (NONE). To create a limited range output from a full range
     * input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is always limited range,
     * regardless of your choice here. When you create a limited range output from a full range input, MediaConvert
     * limits the active pixel values in a way that depends on the output's bit depth: 8-bit outputs contain only values
     * from 16 through 235 and 10-bit outputs contain only values from 64 through 940. With this conversion,
     * MediaConvert also changes the output metadata to note the limited range.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sampleRangeConversion} will return {@link SampleRangeConversion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sampleRangeConversionAsString}.
     * </p>
     * 
     * @return Specify the video color sample range for this output. To create a full range output, you must start with
     *         a full range YUV input and keep the default value, None (NONE). To create a limited range output from a
     *         full range input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is always
     *         limited range, regardless of your choice here. When you create a limited range output from a full range
     *         input, MediaConvert limits the active pixel values in a way that depends on the output's bit depth: 8-bit
     *         outputs contain only values from 16 through 235 and 10-bit outputs contain only values from 64 through
     *         940. With this conversion, MediaConvert also changes the output metadata to note the limited range.
     * @see SampleRangeConversion
     */
    public final String sampleRangeConversionAsString() {
        return sampleRangeConversion;
    }

    /**
     * Saturation level.
     * 
     * @return Saturation level.
     */
    public final Integer saturation() {
        return saturation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(brightness());
        hashCode = 31 * hashCode + Objects.hashCode(colorSpaceConversionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contrast());
        hashCode = 31 * hashCode + Objects.hashCode(hdr10Metadata());
        hashCode = 31 * hashCode + Objects.hashCode(hue());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRangeConversionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(saturation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorCorrector)) {
            return false;
        }
        ColorCorrector other = (ColorCorrector) obj;
        return Objects.equals(brightness(), other.brightness())
                && Objects.equals(colorSpaceConversionAsString(), other.colorSpaceConversionAsString())
                && Objects.equals(contrast(), other.contrast()) && Objects.equals(hdr10Metadata(), other.hdr10Metadata())
                && Objects.equals(hue(), other.hue())
                && Objects.equals(sampleRangeConversionAsString(), other.sampleRangeConversionAsString())
                && Objects.equals(saturation(), other.saturation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColorCorrector").add("Brightness", brightness())
                .add("ColorSpaceConversion", colorSpaceConversionAsString()).add("Contrast", contrast())
                .add("Hdr10Metadata", hdr10Metadata()).add("Hue", hue())
                .add("SampleRangeConversion", sampleRangeConversionAsString()).add("Saturation", saturation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Brightness":
            return Optional.ofNullable(clazz.cast(brightness()));
        case "ColorSpaceConversion":
            return Optional.ofNullable(clazz.cast(colorSpaceConversionAsString()));
        case "Contrast":
            return Optional.ofNullable(clazz.cast(contrast()));
        case "Hdr10Metadata":
            return Optional.ofNullable(clazz.cast(hdr10Metadata()));
        case "Hue":
            return Optional.ofNullable(clazz.cast(hue()));
        case "SampleRangeConversion":
            return Optional.ofNullable(clazz.cast(sampleRangeConversionAsString()));
        case "Saturation":
            return Optional.ofNullable(clazz.cast(saturation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColorCorrector, T> g) {
        return obj -> g.apply((ColorCorrector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColorCorrector> {
        /**
         * Brightness level.
         * 
         * @param brightness
         *        Brightness level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brightness(Integer brightness);

        /**
         * Specify the color space you want for this output. The service supports conversion between HDR formats,
         * between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the dynamic
         * range. The converted video has an HDR format, but visually appears the same as an unconverted output. HDR to
         * SDR conversion uses Elemental tone mapping technology to approximate the outcome of manually regrading from
         * HDR to SDR.
         * 
         * @param colorSpaceConversion
         *        Specify the color space you want for this output. The service supports conversion between HDR formats,
         *        between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the
         *        dynamic range. The converted video has an HDR format, but visually appears the same as an unconverted
         *        output. HDR to SDR conversion uses Elemental tone mapping technology to approximate the outcome of
         *        manually regrading from HDR to SDR.
         * @see ColorSpaceConversion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorSpaceConversion
         */
        Builder colorSpaceConversion(String colorSpaceConversion);

        /**
         * Specify the color space you want for this output. The service supports conversion between HDR formats,
         * between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the dynamic
         * range. The converted video has an HDR format, but visually appears the same as an unconverted output. HDR to
         * SDR conversion uses Elemental tone mapping technology to approximate the outcome of manually regrading from
         * HDR to SDR.
         * 
         * @param colorSpaceConversion
         *        Specify the color space you want for this output. The service supports conversion between HDR formats,
         *        between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the
         *        dynamic range. The converted video has an HDR format, but visually appears the same as an unconverted
         *        output. HDR to SDR conversion uses Elemental tone mapping technology to approximate the outcome of
         *        manually regrading from HDR to SDR.
         * @see ColorSpaceConversion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorSpaceConversion
         */
        Builder colorSpaceConversion(ColorSpaceConversion colorSpaceConversion);

        /**
         * Contrast level.
         * 
         * @param contrast
         *        Contrast level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contrast(Integer contrast);

        /**
         * Use these settings when you convert to the HDR 10 color space. Specify the SMPTE ST 2086 Mastering Display
         * Color Volume static metadata that you want signaled in the output. These values don't affect the pixel values
         * that are encoded in the video stream. They are intended to help the downstream video player display content
         * in a way that reflects the intentions of the the content creator. When you set Color space conversion
         * (ColorSpaceConversion) to HDR 10 (FORCE_HDR10), these settings are required. You must set values for Max
         * frame average light level (maxFrameAverageLightLevel) and Max content light level (maxContentLightLevel);
         * these settings don't have a default value. The default values for the other HDR 10 metadata settings are
         * defined by the P3D65 color space. For more information about MediaConvert HDR jobs, see
         * https://docs.aws.amazon.com/console/mediaconvert/hdr.
         * 
         * @param hdr10Metadata
         *        Use these settings when you convert to the HDR 10 color space. Specify the SMPTE ST 2086 Mastering
         *        Display Color Volume static metadata that you want signaled in the output. These values don't affect
         *        the pixel values that are encoded in the video stream. They are intended to help the downstream video
         *        player display content in a way that reflects the intentions of the the content creator. When you set
         *        Color space conversion (ColorSpaceConversion) to HDR 10 (FORCE_HDR10), these settings are required.
         *        You must set values for Max frame average light level (maxFrameAverageLightLevel) and Max content
         *        light level (maxContentLightLevel); these settings don't have a default value. The default values for
         *        the other HDR 10 metadata settings are defined by the P3D65 color space. For more information about
         *        MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hdr10Metadata(Hdr10Metadata hdr10Metadata);

        /**
         * Use these settings when you convert to the HDR 10 color space. Specify the SMPTE ST 2086 Mastering Display
         * Color Volume static metadata that you want signaled in the output. These values don't affect the pixel values
         * that are encoded in the video stream. They are intended to help the downstream video player display content
         * in a way that reflects the intentions of the the content creator. When you set Color space conversion
         * (ColorSpaceConversion) to HDR 10 (FORCE_HDR10), these settings are required. You must set values for Max
         * frame average light level (maxFrameAverageLightLevel) and Max content light level (maxContentLightLevel);
         * these settings don't have a default value. The default values for the other HDR 10 metadata settings are
         * defined by the P3D65 color space. For more information about MediaConvert HDR jobs, see
         * https://docs.aws.amazon.com/console/mediaconvert/hdr. This is a convenience method that creates an instance
         * of the {@link Hdr10Metadata.Builder} avoiding the need to create one manually via
         * {@link Hdr10Metadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Hdr10Metadata.Builder#build()} is called immediately and its
         * result is passed to {@link #hdr10Metadata(Hdr10Metadata)}.
         * 
         * @param hdr10Metadata
         *        a consumer that will call methods on {@link Hdr10Metadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hdr10Metadata(Hdr10Metadata)
         */
        default Builder hdr10Metadata(Consumer<Hdr10Metadata.Builder> hdr10Metadata) {
            return hdr10Metadata(Hdr10Metadata.builder().applyMutation(hdr10Metadata).build());
        }

        /**
         * Hue in degrees.
         * 
         * @param hue
         *        Hue in degrees.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hue(Integer hue);

        /**
         * Specify the video color sample range for this output. To create a full range output, you must start with a
         * full range YUV input and keep the default value, None (NONE). To create a limited range output from a full
         * range input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is always limited
         * range, regardless of your choice here. When you create a limited range output from a full range input,
         * MediaConvert limits the active pixel values in a way that depends on the output's bit depth: 8-bit outputs
         * contain only values from 16 through 235 and 10-bit outputs contain only values from 64 through 940. With this
         * conversion, MediaConvert also changes the output metadata to note the limited range.
         * 
         * @param sampleRangeConversion
         *        Specify the video color sample range for this output. To create a full range output, you must start
         *        with a full range YUV input and keep the default value, None (NONE). To create a limited range output
         *        from a full range input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is
         *        always limited range, regardless of your choice here. When you create a limited range output from a
         *        full range input, MediaConvert limits the active pixel values in a way that depends on the output's
         *        bit depth: 8-bit outputs contain only values from 16 through 235 and 10-bit outputs contain only
         *        values from 64 through 940. With this conversion, MediaConvert also changes the output metadata to
         *        note the limited range.
         * @see SampleRangeConversion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SampleRangeConversion
         */
        Builder sampleRangeConversion(String sampleRangeConversion);

        /**
         * Specify the video color sample range for this output. To create a full range output, you must start with a
         * full range YUV input and keep the default value, None (NONE). To create a limited range output from a full
         * range input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is always limited
         * range, regardless of your choice here. When you create a limited range output from a full range input,
         * MediaConvert limits the active pixel values in a way that depends on the output's bit depth: 8-bit outputs
         * contain only values from 16 through 235 and 10-bit outputs contain only values from 64 through 940. With this
         * conversion, MediaConvert also changes the output metadata to note the limited range.
         * 
         * @param sampleRangeConversion
         *        Specify the video color sample range for this output. To create a full range output, you must start
         *        with a full range YUV input and keep the default value, None (NONE). To create a limited range output
         *        from a full range input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is
         *        always limited range, regardless of your choice here. When you create a limited range output from a
         *        full range input, MediaConvert limits the active pixel values in a way that depends on the output's
         *        bit depth: 8-bit outputs contain only values from 16 through 235 and 10-bit outputs contain only
         *        values from 64 through 940. With this conversion, MediaConvert also changes the output metadata to
         *        note the limited range.
         * @see SampleRangeConversion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SampleRangeConversion
         */
        Builder sampleRangeConversion(SampleRangeConversion sampleRangeConversion);

        /**
         * Saturation level.
         * 
         * @param saturation
         *        Saturation level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder saturation(Integer saturation);
    }

    static final class BuilderImpl implements Builder {
        private Integer brightness;

        private String colorSpaceConversion;

        private Integer contrast;

        private Hdr10Metadata hdr10Metadata;

        private Integer hue;

        private String sampleRangeConversion;

        private Integer saturation;

        private BuilderImpl() {
        }

        private BuilderImpl(ColorCorrector model) {
            brightness(model.brightness);
            colorSpaceConversion(model.colorSpaceConversion);
            contrast(model.contrast);
            hdr10Metadata(model.hdr10Metadata);
            hue(model.hue);
            sampleRangeConversion(model.sampleRangeConversion);
            saturation(model.saturation);
        }

        public final Integer getBrightness() {
            return brightness;
        }

        public final void setBrightness(Integer brightness) {
            this.brightness = brightness;
        }

        @Override
        public final Builder brightness(Integer brightness) {
            this.brightness = brightness;
            return this;
        }

        public final String getColorSpaceConversion() {
            return colorSpaceConversion;
        }

        public final void setColorSpaceConversion(String colorSpaceConversion) {
            this.colorSpaceConversion = colorSpaceConversion;
        }

        @Override
        public final Builder colorSpaceConversion(String colorSpaceConversion) {
            this.colorSpaceConversion = colorSpaceConversion;
            return this;
        }

        @Override
        public final Builder colorSpaceConversion(ColorSpaceConversion colorSpaceConversion) {
            this.colorSpaceConversion(colorSpaceConversion == null ? null : colorSpaceConversion.toString());
            return this;
        }

        public final Integer getContrast() {
            return contrast;
        }

        public final void setContrast(Integer contrast) {
            this.contrast = contrast;
        }

        @Override
        public final Builder contrast(Integer contrast) {
            this.contrast = contrast;
            return this;
        }

        public final Hdr10Metadata.Builder getHdr10Metadata() {
            return hdr10Metadata != null ? hdr10Metadata.toBuilder() : null;
        }

        public final void setHdr10Metadata(Hdr10Metadata.BuilderImpl hdr10Metadata) {
            this.hdr10Metadata = hdr10Metadata != null ? hdr10Metadata.build() : null;
        }

        @Override
        public final Builder hdr10Metadata(Hdr10Metadata hdr10Metadata) {
            this.hdr10Metadata = hdr10Metadata;
            return this;
        }

        public final Integer getHue() {
            return hue;
        }

        public final void setHue(Integer hue) {
            this.hue = hue;
        }

        @Override
        public final Builder hue(Integer hue) {
            this.hue = hue;
            return this;
        }

        public final String getSampleRangeConversion() {
            return sampleRangeConversion;
        }

        public final void setSampleRangeConversion(String sampleRangeConversion) {
            this.sampleRangeConversion = sampleRangeConversion;
        }

        @Override
        public final Builder sampleRangeConversion(String sampleRangeConversion) {
            this.sampleRangeConversion = sampleRangeConversion;
            return this;
        }

        @Override
        public final Builder sampleRangeConversion(SampleRangeConversion sampleRangeConversion) {
            this.sampleRangeConversion(sampleRangeConversion == null ? null : sampleRangeConversion.toString());
            return this;
        }

        public final Integer getSaturation() {
            return saturation;
        }

        public final void setSaturation(Integer saturation) {
            this.saturation = saturation;
        }

        @Override
        public final Builder saturation(Integer saturation) {
            this.saturation = saturation;
            return this;
        }

        @Override
        public ColorCorrector build() {
            return new ColorCorrector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
