/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position information from
 * your input captions. MediaConvert uses default settings for any missing style and position information in your input
 * captions. Set Style passthrough to DISABLED, or leave blank, to ignore the style and position information from your
 * input captions and use default settings: white text with black outlining, bottom-center positioning, and automatic
 * sizing. Whether you set Style passthrough to enabled or not, you can also choose to manually override any of the
 * individual style and position settings.
 */
@Generated("software.amazon.awssdk:codegen")
public enum DvbSubtitleStylePassthrough {
    ENABLED("ENABLED"),

    DISABLED("DISABLED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DvbSubtitleStylePassthrough> VALUE_MAP = EnumUtils.uniqueIndex(
            DvbSubtitleStylePassthrough.class, DvbSubtitleStylePassthrough::toString);

    private final String value;

    private DvbSubtitleStylePassthrough(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DvbSubtitleStylePassthrough corresponding to the value
     */
    public static DvbSubtitleStylePassthrough fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DvbSubtitleStylePassthrough}s
     */
    public static Set<DvbSubtitleStylePassthrough> knownValues() {
        Set<DvbSubtitleStylePassthrough> knownValues = EnumSet.allOf(DvbSubtitleStylePassthrough.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
