/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Each output in your job is a collection of settings that describes how you want MediaConvert to encode a single
 * output file or stream. For more information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/create-outputs.html.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Output implements SdkPojo, Serializable, ToCopyableBuilder<Output.Builder, Output> {
    private static final SdkField<List<AudioDescription>> AUDIO_DESCRIPTIONS_FIELD = SdkField
            .<List<AudioDescription>> builder(MarshallingType.LIST)
            .memberName("AudioDescriptions")
            .getter(getter(Output::audioDescriptions))
            .setter(setter(Builder::audioDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudioDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CaptionDescription>> CAPTION_DESCRIPTIONS_FIELD = SdkField
            .<List<CaptionDescription>> builder(MarshallingType.LIST)
            .memberName("CaptionDescriptions")
            .getter(getter(Output::captionDescriptions))
            .setter(setter(Builder::captionDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CaptionDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaptionDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ContainerSettings> CONTAINER_SETTINGS_FIELD = SdkField
            .<ContainerSettings> builder(MarshallingType.SDK_POJO).memberName("ContainerSettings")
            .getter(getter(Output::containerSettings)).setter(setter(Builder::containerSettings))
            .constructor(ContainerSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerSettings").build()).build();

    private static final SdkField<String> EXTENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Extension").getter(getter(Output::extension)).setter(setter(Builder::extension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extension").build()).build();

    private static final SdkField<String> NAME_MODIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameModifier").getter(getter(Output::nameModifier)).setter(setter(Builder::nameModifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameModifier").build()).build();

    private static final SdkField<OutputSettings> OUTPUT_SETTINGS_FIELD = SdkField
            .<OutputSettings> builder(MarshallingType.SDK_POJO).memberName("OutputSettings")
            .getter(getter(Output::outputSettings)).setter(setter(Builder::outputSettings)).constructor(OutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSettings").build()).build();

    private static final SdkField<String> PRESET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Preset")
            .getter(getter(Output::preset)).setter(setter(Builder::preset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preset").build()).build();

    private static final SdkField<VideoDescription> VIDEO_DESCRIPTION_FIELD = SdkField
            .<VideoDescription> builder(MarshallingType.SDK_POJO).memberName("VideoDescription")
            .getter(getter(Output::videoDescription)).setter(setter(Builder::videoDescription))
            .constructor(VideoDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DESCRIPTIONS_FIELD,
            CAPTION_DESCRIPTIONS_FIELD, CONTAINER_SETTINGS_FIELD, EXTENSION_FIELD, NAME_MODIFIER_FIELD, OUTPUT_SETTINGS_FIELD,
            PRESET_FIELD, VIDEO_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AudioDescription> audioDescriptions;

    private final List<CaptionDescription> captionDescriptions;

    private final ContainerSettings containerSettings;

    private final String extension;

    private final String nameModifier;

    private final OutputSettings outputSettings;

    private final String preset;

    private final VideoDescription videoDescription;

    private Output(BuilderImpl builder) {
        this.audioDescriptions = builder.audioDescriptions;
        this.captionDescriptions = builder.captionDescriptions;
        this.containerSettings = builder.containerSettings;
        this.extension = builder.extension;
        this.nameModifier = builder.nameModifier;
        this.outputSettings = builder.outputSettings;
        this.preset = builder.preset;
        this.videoDescription = builder.videoDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudioDescriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAudioDescriptions() {
        return audioDescriptions != null && !(audioDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance of
     * (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudioDescriptions} method.
     * </p>
     * 
     * @return (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one
     *         instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding
     *         settings.
     */
    public final List<AudioDescription> audioDescriptions() {
        return audioDescriptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the CaptionDescriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCaptionDescriptions() {
        return captionDescriptions != null && !(captionDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * (CaptionDescriptions) contains groups of captions settings. For each output that has captions, include one
     * instance of (CaptionDescriptions). (CaptionDescriptions) can contain multiple groups of captions settings.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCaptionDescriptions} method.
     * </p>
     * 
     * @return (CaptionDescriptions) contains groups of captions settings. For each output that has captions, include
     *         one instance of (CaptionDescriptions). (CaptionDescriptions) can contain multiple groups of captions
     *         settings.
     */
    public final List<CaptionDescription> captionDescriptions() {
        return captionDescriptions;
    }

    /**
     * Container specific settings.
     * 
     * @return Container specific settings.
     */
    public final ContainerSettings containerSettings() {
        return containerSettings;
    }

    /**
     * Use Extension (Extension) to specify the file extension for outputs in File output groups. If you do not specify
     * a value, the service will use default extensions by container type as follows * MPEG-2 transport stream, m2ts *
     * Quicktime, mov * MXF container, mxf * MPEG-4 container, mp4 * WebM container, webm * No Container, the service
     * will use codec extensions (e.g. AAC, H265, H265, AC3)
     * 
     * @return Use Extension (Extension) to specify the file extension for outputs in File output groups. If you do not
     *         specify a value, the service will use default extensions by container type as follows * MPEG-2 transport
     *         stream, m2ts * Quicktime, mov * MXF container, mxf * MPEG-4 container, mp4 * WebM container, webm * No
     *         Container, the service will use codec extensions (e.g. AAC, H265, H265, AC3)
     */
    public final String extension() {
        return extension;
    }

    /**
     * Use Name modifier (NameModifier) to have the service add a string to the end of each output filename. You specify
     * the base filename as part of your destination URI. When you create multiple outputs in the same output group,
     * Name modifier (NameModifier) is required. Name modifier also accepts format identifiers. For DASH ISO outputs, if
     * you use the format identifiers $Number$ or $Time$ in one output, you must use them in the same way in all outputs
     * of the output group.
     * 
     * @return Use Name modifier (NameModifier) to have the service add a string to the end of each output filename. You
     *         specify the base filename as part of your destination URI. When you create multiple outputs in the same
     *         output group, Name modifier (NameModifier) is required. Name modifier also accepts format identifiers.
     *         For DASH ISO outputs, if you use the format identifiers $Number$ or $Time$ in one output, you must use
     *         them in the same way in all outputs of the output group.
     */
    public final String nameModifier() {
        return nameModifier;
    }

    /**
     * Specific settings for this type of output.
     * 
     * @return Specific settings for this type of output.
     */
    public final OutputSettings outputSettings() {
        return outputSettings;
    }

    /**
     * Use Preset (Preset) to specify a preset for your transcoding settings. Provide the system or custom preset name.
     * You can specify either Preset (Preset) or Container settings (ContainerSettings), but not both.
     * 
     * @return Use Preset (Preset) to specify a preset for your transcoding settings. Provide the system or custom
     *         preset name. You can specify either Preset (Preset) or Container settings (ContainerSettings), but not
     *         both.
     */
    public final String preset() {
        return preset;
    }

    /**
     * VideoDescription contains a group of video encoding settings. The specific video settings depend on the video
     * codec that you choose for the property codec. Include one instance of VideoDescription per output.
     * 
     * @return VideoDescription contains a group of video encoding settings. The specific video settings depend on the
     *         video codec that you choose for the property codec. Include one instance of VideoDescription per output.
     */
    public final VideoDescription videoDescription() {
        return videoDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAudioDescriptions() ? audioDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCaptionDescriptions() ? captionDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(containerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(extension());
        hashCode = 31 * hashCode + Objects.hashCode(nameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(outputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(preset());
        hashCode = 31 * hashCode + Objects.hashCode(videoDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output) obj;
        return hasAudioDescriptions() == other.hasAudioDescriptions()
                && Objects.equals(audioDescriptions(), other.audioDescriptions())
                && hasCaptionDescriptions() == other.hasCaptionDescriptions()
                && Objects.equals(captionDescriptions(), other.captionDescriptions())
                && Objects.equals(containerSettings(), other.containerSettings())
                && Objects.equals(extension(), other.extension()) && Objects.equals(nameModifier(), other.nameModifier())
                && Objects.equals(outputSettings(), other.outputSettings()) && Objects.equals(preset(), other.preset())
                && Objects.equals(videoDescription(), other.videoDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Output").add("AudioDescriptions", hasAudioDescriptions() ? audioDescriptions() : null)
                .add("CaptionDescriptions", hasCaptionDescriptions() ? captionDescriptions() : null)
                .add("ContainerSettings", containerSettings()).add("Extension", extension()).add("NameModifier", nameModifier())
                .add("OutputSettings", outputSettings()).add("Preset", preset()).add("VideoDescription", videoDescription())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioDescriptions":
            return Optional.ofNullable(clazz.cast(audioDescriptions()));
        case "CaptionDescriptions":
            return Optional.ofNullable(clazz.cast(captionDescriptions()));
        case "ContainerSettings":
            return Optional.ofNullable(clazz.cast(containerSettings()));
        case "Extension":
            return Optional.ofNullable(clazz.cast(extension()));
        case "NameModifier":
            return Optional.ofNullable(clazz.cast(nameModifier()));
        case "OutputSettings":
            return Optional.ofNullable(clazz.cast(outputSettings()));
        case "Preset":
            return Optional.ofNullable(clazz.cast(preset()));
        case "VideoDescription":
            return Optional.ofNullable(clazz.cast(videoDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Output, T> g) {
        return obj -> g.apply((Output) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Output> {
        /**
         * (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance
         * of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.
         * 
         * @param audioDescriptions
         *        (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one
         *        instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of
         *        encoding settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioDescriptions(Collection<AudioDescription> audioDescriptions);

        /**
         * (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance
         * of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.
         * 
         * @param audioDescriptions
         *        (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one
         *        instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of
         *        encoding settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioDescriptions(AudioDescription... audioDescriptions);

        /**
         * (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance
         * of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings. This
         * is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconvert.model.AudioDescription.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.mediaconvert.model.AudioDescription#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.AudioDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #audioDescriptions(List<AudioDescription>)}.
         * 
         * @param audioDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.AudioDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioDescriptions(java.util.Collection<AudioDescription>)
         */
        Builder audioDescriptions(Consumer<AudioDescription.Builder>... audioDescriptions);

        /**
         * (CaptionDescriptions) contains groups of captions settings. For each output that has captions, include one
         * instance of (CaptionDescriptions). (CaptionDescriptions) can contain multiple groups of captions settings.
         * 
         * @param captionDescriptions
         *        (CaptionDescriptions) contains groups of captions settings. For each output that has captions, include
         *        one instance of (CaptionDescriptions). (CaptionDescriptions) can contain multiple groups of captions
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionDescriptions(Collection<CaptionDescription> captionDescriptions);

        /**
         * (CaptionDescriptions) contains groups of captions settings. For each output that has captions, include one
         * instance of (CaptionDescriptions). (CaptionDescriptions) can contain multiple groups of captions settings.
         * 
         * @param captionDescriptions
         *        (CaptionDescriptions) contains groups of captions settings. For each output that has captions, include
         *        one instance of (CaptionDescriptions). (CaptionDescriptions) can contain multiple groups of captions
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionDescriptions(CaptionDescription... captionDescriptions);

        /**
         * (CaptionDescriptions) contains groups of captions settings. For each output that has captions, include one
         * instance of (CaptionDescriptions). (CaptionDescriptions) can contain multiple groups of captions settings.
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconvert.model.CaptionDescription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mediaconvert.model.CaptionDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.CaptionDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #captionDescriptions(List<CaptionDescription>)}.
         * 
         * @param captionDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.CaptionDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captionDescriptions(java.util.Collection<CaptionDescription>)
         */
        Builder captionDescriptions(Consumer<CaptionDescription.Builder>... captionDescriptions);

        /**
         * Container specific settings.
         * 
         * @param containerSettings
         *        Container specific settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerSettings(ContainerSettings containerSettings);

        /**
         * Container specific settings. This is a convenience method that creates an instance of the
         * {@link ContainerSettings.Builder} avoiding the need to create one manually via
         * {@link ContainerSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #containerSettings(ContainerSettings)}.
         * 
         * @param containerSettings
         *        a consumer that will call methods on {@link ContainerSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerSettings(ContainerSettings)
         */
        default Builder containerSettings(Consumer<ContainerSettings.Builder> containerSettings) {
            return containerSettings(ContainerSettings.builder().applyMutation(containerSettings).build());
        }

        /**
         * Use Extension (Extension) to specify the file extension for outputs in File output groups. If you do not
         * specify a value, the service will use default extensions by container type as follows * MPEG-2 transport
         * stream, m2ts * Quicktime, mov * MXF container, mxf * MPEG-4 container, mp4 * WebM container, webm * No
         * Container, the service will use codec extensions (e.g. AAC, H265, H265, AC3)
         * 
         * @param extension
         *        Use Extension (Extension) to specify the file extension for outputs in File output groups. If you do
         *        not specify a value, the service will use default extensions by container type as follows * MPEG-2
         *        transport stream, m2ts * Quicktime, mov * MXF container, mxf * MPEG-4 container, mp4 * WebM container,
         *        webm * No Container, the service will use codec extensions (e.g. AAC, H265, H265, AC3)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extension(String extension);

        /**
         * Use Name modifier (NameModifier) to have the service add a string to the end of each output filename. You
         * specify the base filename as part of your destination URI. When you create multiple outputs in the same
         * output group, Name modifier (NameModifier) is required. Name modifier also accepts format identifiers. For
         * DASH ISO outputs, if you use the format identifiers $Number$ or $Time$ in one output, you must use them in
         * the same way in all outputs of the output group.
         * 
         * @param nameModifier
         *        Use Name modifier (NameModifier) to have the service add a string to the end of each output filename.
         *        You specify the base filename as part of your destination URI. When you create multiple outputs in the
         *        same output group, Name modifier (NameModifier) is required. Name modifier also accepts format
         *        identifiers. For DASH ISO outputs, if you use the format identifiers $Number$ or $Time$ in one output,
         *        you must use them in the same way in all outputs of the output group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameModifier(String nameModifier);

        /**
         * Specific settings for this type of output.
         * 
         * @param outputSettings
         *        Specific settings for this type of output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSettings(OutputSettings outputSettings);

        /**
         * Specific settings for this type of output. This is a convenience method that creates an instance of the
         * {@link OutputSettings.Builder} avoiding the need to create one manually via {@link OutputSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #outputSettings(OutputSettings)}.
         * 
         * @param outputSettings
         *        a consumer that will call methods on {@link OutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSettings(OutputSettings)
         */
        default Builder outputSettings(Consumer<OutputSettings.Builder> outputSettings) {
            return outputSettings(OutputSettings.builder().applyMutation(outputSettings).build());
        }

        /**
         * Use Preset (Preset) to specify a preset for your transcoding settings. Provide the system or custom preset
         * name. You can specify either Preset (Preset) or Container settings (ContainerSettings), but not both.
         * 
         * @param preset
         *        Use Preset (Preset) to specify a preset for your transcoding settings. Provide the system or custom
         *        preset name. You can specify either Preset (Preset) or Container settings (ContainerSettings), but not
         *        both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preset(String preset);

        /**
         * VideoDescription contains a group of video encoding settings. The specific video settings depend on the video
         * codec that you choose for the property codec. Include one instance of VideoDescription per output.
         * 
         * @param videoDescription
         *        VideoDescription contains a group of video encoding settings. The specific video settings depend on
         *        the video codec that you choose for the property codec. Include one instance of VideoDescription per
         *        output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoDescription(VideoDescription videoDescription);

        /**
         * VideoDescription contains a group of video encoding settings. The specific video settings depend on the video
         * codec that you choose for the property codec. Include one instance of VideoDescription per output. This is a
         * convenience method that creates an instance of the {@link VideoDescription.Builder} avoiding the need to
         * create one manually via {@link VideoDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #videoDescription(VideoDescription)}.
         * 
         * @param videoDescription
         *        a consumer that will call methods on {@link VideoDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoDescription(VideoDescription)
         */
        default Builder videoDescription(Consumer<VideoDescription.Builder> videoDescription) {
            return videoDescription(VideoDescription.builder().applyMutation(videoDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<AudioDescription> audioDescriptions = DefaultSdkAutoConstructList.getInstance();

        private List<CaptionDescription> captionDescriptions = DefaultSdkAutoConstructList.getInstance();

        private ContainerSettings containerSettings;

        private String extension;

        private String nameModifier;

        private OutputSettings outputSettings;

        private String preset;

        private VideoDescription videoDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            audioDescriptions(model.audioDescriptions);
            captionDescriptions(model.captionDescriptions);
            containerSettings(model.containerSettings);
            extension(model.extension);
            nameModifier(model.nameModifier);
            outputSettings(model.outputSettings);
            preset(model.preset);
            videoDescription(model.videoDescription);
        }

        public final List<AudioDescription.Builder> getAudioDescriptions() {
            List<AudioDescription.Builder> result = ___listOfAudioDescriptionCopier.copyToBuilder(this.audioDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudioDescriptions(Collection<AudioDescription.BuilderImpl> audioDescriptions) {
            this.audioDescriptions = ___listOfAudioDescriptionCopier.copyFromBuilder(audioDescriptions);
        }

        @Override
        public final Builder audioDescriptions(Collection<AudioDescription> audioDescriptions) {
            this.audioDescriptions = ___listOfAudioDescriptionCopier.copy(audioDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(AudioDescription... audioDescriptions) {
            audioDescriptions(Arrays.asList(audioDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(Consumer<AudioDescription.Builder>... audioDescriptions) {
            audioDescriptions(Stream.of(audioDescriptions).map(c -> AudioDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CaptionDescription.Builder> getCaptionDescriptions() {
            List<CaptionDescription.Builder> result = ___listOfCaptionDescriptionCopier.copyToBuilder(this.captionDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCaptionDescriptions(Collection<CaptionDescription.BuilderImpl> captionDescriptions) {
            this.captionDescriptions = ___listOfCaptionDescriptionCopier.copyFromBuilder(captionDescriptions);
        }

        @Override
        public final Builder captionDescriptions(Collection<CaptionDescription> captionDescriptions) {
            this.captionDescriptions = ___listOfCaptionDescriptionCopier.copy(captionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(CaptionDescription... captionDescriptions) {
            captionDescriptions(Arrays.asList(captionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(Consumer<CaptionDescription.Builder>... captionDescriptions) {
            captionDescriptions(Stream.of(captionDescriptions).map(c -> CaptionDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ContainerSettings.Builder getContainerSettings() {
            return containerSettings != null ? containerSettings.toBuilder() : null;
        }

        public final void setContainerSettings(ContainerSettings.BuilderImpl containerSettings) {
            this.containerSettings = containerSettings != null ? containerSettings.build() : null;
        }

        @Override
        public final Builder containerSettings(ContainerSettings containerSettings) {
            this.containerSettings = containerSettings;
            return this;
        }

        public final String getExtension() {
            return extension;
        }

        public final void setExtension(String extension) {
            this.extension = extension;
        }

        @Override
        public final Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public final String getNameModifier() {
            return nameModifier;
        }

        public final void setNameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
        }

        @Override
        public final Builder nameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
            return this;
        }

        public final OutputSettings.Builder getOutputSettings() {
            return outputSettings != null ? outputSettings.toBuilder() : null;
        }

        public final void setOutputSettings(OutputSettings.BuilderImpl outputSettings) {
            this.outputSettings = outputSettings != null ? outputSettings.build() : null;
        }

        @Override
        public final Builder outputSettings(OutputSettings outputSettings) {
            this.outputSettings = outputSettings;
            return this;
        }

        public final String getPreset() {
            return preset;
        }

        public final void setPreset(String preset) {
            this.preset = preset;
        }

        @Override
        public final Builder preset(String preset) {
            this.preset = preset;
            return this;
        }

        public final VideoDescription.Builder getVideoDescription() {
            return videoDescription != null ? videoDescription.toBuilder() : null;
        }

        public final void setVideoDescription(VideoDescription.BuilderImpl videoDescription) {
            this.videoDescription = videoDescription != null ? videoDescription.build() : null;
        }

        @Override
        public final Builder videoDescription(VideoDescription videoDescription) {
            this.videoDescription = videoDescription;
            return this;
        }

        @Override
        public Output build() {
            return new Output(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
