/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify whether MediaConvert should use any downmix metadata from your input file. Keep the default value, Custom
 * (SPECIFIED) to provide downmix values in your job settings. Choose Follow source (INITIALIZE_FROM_SOURCE) to use the
 * metadata from your input. Related settings--Use these settings to specify your downmix values: Left only/Right only
 * surround (LoRoSurroundMixLevel), Left total/Right total surround (LtRtSurroundMixLevel), Left total/Right total
 * center (LtRtCenterMixLevel), Left only/Right only center (LoRoCenterMixLevel), and Stereo downmix (StereoDownmix).
 * When you keep Custom (SPECIFIED) for Downmix control (DownmixControl) and you don't specify values for the related
 * settings, MediaConvert uses default values for those settings.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Eac3AtmosDownmixControl {
    SPECIFIED("SPECIFIED"),

    INITIALIZE_FROM_SOURCE("INITIALIZE_FROM_SOURCE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Eac3AtmosDownmixControl> VALUE_MAP = EnumUtils.uniqueIndex(Eac3AtmosDownmixControl.class,
            Eac3AtmosDownmixControl::toString);

    private final String value;

    private Eac3AtmosDownmixControl(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Eac3AtmosDownmixControl corresponding to the value
     */
    public static Eac3AtmosDownmixControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Eac3AtmosDownmixControl}s
     */
    public static Set<Eac3AtmosDownmixControl> knownValues() {
        Set<Eac3AtmosDownmixControl> knownValues = EnumSet.allOf(Eac3AtmosDownmixControl.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
