/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * The cadence MediaConvert follows for generating thumbnails. If set to FOLLOW_IFRAME, MediaConvert generates
 * thumbnails for each IDR frame in the output (matching the GOP cadence). If set to FOLLOW_CUSTOM, MediaConvert
 * generates thumbnails according to the interval you specify in thumbnailInterval.
 */
@Generated("software.amazon.awssdk:codegen")
public enum HlsIntervalCadence {
    FOLLOW_IFRAME("FOLLOW_IFRAME"),

    FOLLOW_CUSTOM("FOLLOW_CUSTOM"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HlsIntervalCadence> VALUE_MAP = EnumUtils.uniqueIndex(HlsIntervalCadence.class,
            HlsIntervalCadence::toString);

    private final String value;

    private HlsIntervalCadence(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return HlsIntervalCadence corresponding to the value
     */
    public static HlsIntervalCadence fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link HlsIntervalCadence}s
     */
    public static Set<HlsIntervalCadence> knownValues() {
        Set<HlsIntervalCadence> knownValues = EnumSet.allOf(HlsIntervalCadence.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
