/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use the image inserter feature to include a graphic overlay on your video. Enable or disable this feature for each
 * input or output individually. For more information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/graphic-overlay.html. This setting is disabled by default.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageInserter implements SdkPojo, Serializable, ToCopyableBuilder<ImageInserter.Builder, ImageInserter> {
    private static final SdkField<List<InsertableImage>> INSERTABLE_IMAGES_FIELD = SdkField
            .<List<InsertableImage>> builder(MarshallingType.LIST)
            .memberName("InsertableImages")
            .getter(getter(ImageInserter::insertableImages))
            .setter(setter(Builder::insertableImages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insertableImages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InsertableImage> builder(MarshallingType.SDK_POJO)
                                            .constructor(InsertableImage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSERTABLE_IMAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<InsertableImage> insertableImages;

    private ImageInserter(BuilderImpl builder) {
        this.insertableImages = builder.insertableImages;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsertableImages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInsertableImages() {
        return insertableImages != null && !(insertableImages instanceof SdkAutoConstructList);
    }

    /**
     * Specify the images that you want to overlay on your video. The images must be PNG or TGA files.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsertableImages} method.
     * </p>
     * 
     * @return Specify the images that you want to overlay on your video. The images must be PNG or TGA files.
     */
    public final List<InsertableImage> insertableImages() {
        return insertableImages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInsertableImages() ? insertableImages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageInserter)) {
            return false;
        }
        ImageInserter other = (ImageInserter) obj;
        return hasInsertableImages() == other.hasInsertableImages()
                && Objects.equals(insertableImages(), other.insertableImages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageInserter").add("InsertableImages", hasInsertableImages() ? insertableImages() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsertableImages":
            return Optional.ofNullable(clazz.cast(insertableImages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageInserter, T> g) {
        return obj -> g.apply((ImageInserter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageInserter> {
        /**
         * Specify the images that you want to overlay on your video. The images must be PNG or TGA files.
         * 
         * @param insertableImages
         *        Specify the images that you want to overlay on your video. The images must be PNG or TGA files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insertableImages(Collection<InsertableImage> insertableImages);

        /**
         * Specify the images that you want to overlay on your video. The images must be PNG or TGA files.
         * 
         * @param insertableImages
         *        Specify the images that you want to overlay on your video. The images must be PNG or TGA files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insertableImages(InsertableImage... insertableImages);

        /**
         * Specify the images that you want to overlay on your video. The images must be PNG or TGA files. This is a
         * convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconvert.model.InsertableImage.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.mediaconvert.model.InsertableImage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.InsertableImage.Builder#build()} is called
         * immediately and its result is passed to {@link #insertableImages(List<InsertableImage>)}.
         * 
         * @param insertableImages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.InsertableImage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insertableImages(java.util.Collection<InsertableImage>)
         */
        Builder insertableImages(Consumer<InsertableImage.Builder>... insertableImages);
    }

    static final class BuilderImpl implements Builder {
        private List<InsertableImage> insertableImages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageInserter model) {
            insertableImages(model.insertableImages);
        }

        public final List<InsertableImage.Builder> getInsertableImages() {
            List<InsertableImage.Builder> result = ___listOfInsertableImageCopier.copyToBuilder(this.insertableImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsertableImages(Collection<InsertableImage.BuilderImpl> insertableImages) {
            this.insertableImages = ___listOfInsertableImageCopier.copyFromBuilder(insertableImages);
        }

        @Override
        public final Builder insertableImages(Collection<InsertableImage> insertableImages) {
            this.insertableImages = ___listOfInsertableImageCopier.copy(insertableImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insertableImages(InsertableImage... insertableImages) {
            insertableImages(Arrays.asList(insertableImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insertableImages(Consumer<InsertableImage.Builder>... insertableImages) {
            insertableImages(Stream.of(insertableImages).map(c -> InsertableImage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ImageInserter build() {
            return new ImageInserter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
