/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed
 * in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of
 * how much or how little you use it. Reserved pricing requires a 12-month commitment.
 */
@Generated("software.amazon.awssdk:codegen")
public enum PricingPlan {
    ON_DEMAND("ON_DEMAND"),

    RESERVED("RESERVED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PricingPlan> VALUE_MAP = EnumUtils.uniqueIndex(PricingPlan.class, PricingPlan::toString);

    private final String value;

    private PricingPlan(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return PricingPlan corresponding to the value
     */
    public static PricingPlan fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link PricingPlan}s
     */
    public static Set<PricingPlan> knownValues() {
        Set<PricingPlan> knownValues = EnumSet.allOf(PricingPlan.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
