/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings related to SCC captions. SCC is a sidecar format that holds captions in a file that is separate from the
 * video container. Set up sidecar captions in the same output group, but different output from your video. For more
 * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/scc-srt-output-captions.html. When you work
 * directly in your JSON job specification, include this object and any required children when you set destinationType
 * to SCC.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SccDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<SccDestinationSettings.Builder, SccDestinationSettings> {
    private static final SdkField<String> FRAMERATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Framerate").getter(getter(SccDestinationSettings::framerateAsString)).setter(setter(Builder::framerate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMERATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String framerate;

    private SccDestinationSettings(BuilderImpl builder) {
        this.framerate = builder.framerate;
    }

    /**
     * Set Framerate (SccDestinationFramerate) to make sure that the captions and the video are synchronized in the
     * output. Specify a frame rate that matches the frame rate of the associated video. If the video frame rate is
     * 29.97, choose 29.97 dropframe (FRAMERATE_29_97_DROPFRAME) only if the video has video_insertion=true and
     * drop_frame_timecode=true; otherwise, choose 29.97 non-dropframe (FRAMERATE_29_97_NON_DROPFRAME).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerate} will
     * return {@link SccDestinationFramerate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #framerateAsString}.
     * </p>
     * 
     * @return Set Framerate (SccDestinationFramerate) to make sure that the captions and the video are synchronized in
     *         the output. Specify a frame rate that matches the frame rate of the associated video. If the video frame
     *         rate is 29.97, choose 29.97 dropframe (FRAMERATE_29_97_DROPFRAME) only if the video has
     *         video_insertion=true and drop_frame_timecode=true; otherwise, choose 29.97 non-dropframe
     *         (FRAMERATE_29_97_NON_DROPFRAME).
     * @see SccDestinationFramerate
     */
    public final SccDestinationFramerate framerate() {
        return SccDestinationFramerate.fromValue(framerate);
    }

    /**
     * Set Framerate (SccDestinationFramerate) to make sure that the captions and the video are synchronized in the
     * output. Specify a frame rate that matches the frame rate of the associated video. If the video frame rate is
     * 29.97, choose 29.97 dropframe (FRAMERATE_29_97_DROPFRAME) only if the video has video_insertion=true and
     * drop_frame_timecode=true; otherwise, choose 29.97 non-dropframe (FRAMERATE_29_97_NON_DROPFRAME).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerate} will
     * return {@link SccDestinationFramerate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #framerateAsString}.
     * </p>
     * 
     * @return Set Framerate (SccDestinationFramerate) to make sure that the captions and the video are synchronized in
     *         the output. Specify a frame rate that matches the frame rate of the associated video. If the video frame
     *         rate is 29.97, choose 29.97 dropframe (FRAMERATE_29_97_DROPFRAME) only if the video has
     *         video_insertion=true and drop_frame_timecode=true; otherwise, choose 29.97 non-dropframe
     *         (FRAMERATE_29_97_NON_DROPFRAME).
     * @see SccDestinationFramerate
     */
    public final String framerateAsString() {
        return framerate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(framerateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SccDestinationSettings)) {
            return false;
        }
        SccDestinationSettings other = (SccDestinationSettings) obj;
        return Objects.equals(framerateAsString(), other.framerateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SccDestinationSettings").add("Framerate", framerateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Framerate":
            return Optional.ofNullable(clazz.cast(framerateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SccDestinationSettings, T> g) {
        return obj -> g.apply((SccDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SccDestinationSettings> {
        /**
         * Set Framerate (SccDestinationFramerate) to make sure that the captions and the video are synchronized in the
         * output. Specify a frame rate that matches the frame rate of the associated video. If the video frame rate is
         * 29.97, choose 29.97 dropframe (FRAMERATE_29_97_DROPFRAME) only if the video has video_insertion=true and
         * drop_frame_timecode=true; otherwise, choose 29.97 non-dropframe (FRAMERATE_29_97_NON_DROPFRAME).
         * 
         * @param framerate
         *        Set Framerate (SccDestinationFramerate) to make sure that the captions and the video are synchronized
         *        in the output. Specify a frame rate that matches the frame rate of the associated video. If the video
         *        frame rate is 29.97, choose 29.97 dropframe (FRAMERATE_29_97_DROPFRAME) only if the video has
         *        video_insertion=true and drop_frame_timecode=true; otherwise, choose 29.97 non-dropframe
         *        (FRAMERATE_29_97_NON_DROPFRAME).
         * @see SccDestinationFramerate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SccDestinationFramerate
         */
        Builder framerate(String framerate);

        /**
         * Set Framerate (SccDestinationFramerate) to make sure that the captions and the video are synchronized in the
         * output. Specify a frame rate that matches the frame rate of the associated video. If the video frame rate is
         * 29.97, choose 29.97 dropframe (FRAMERATE_29_97_DROPFRAME) only if the video has video_insertion=true and
         * drop_frame_timecode=true; otherwise, choose 29.97 non-dropframe (FRAMERATE_29_97_NON_DROPFRAME).
         * 
         * @param framerate
         *        Set Framerate (SccDestinationFramerate) to make sure that the captions and the video are synchronized
         *        in the output. Specify a frame rate that matches the frame rate of the associated video. If the video
         *        frame rate is 29.97, choose 29.97 dropframe (FRAMERATE_29_97_DROPFRAME) only if the video has
         *        video_insertion=true and drop_frame_timecode=true; otherwise, choose 29.97 non-dropframe
         *        (FRAMERATE_29_97_NON_DROPFRAME).
         * @see SccDestinationFramerate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SccDestinationFramerate
         */
        Builder framerate(SccDestinationFramerate framerate);
    }

    static final class BuilderImpl implements Builder {
        private String framerate;

        private BuilderImpl() {
        }

        private BuilderImpl(SccDestinationSettings model) {
            framerate(model.framerate);
        }

        public final String getFramerate() {
            return framerate;
        }

        public final void setFramerate(String framerate) {
            this.framerate = framerate;
        }

        @Override
        public final Builder framerate(String framerate) {
            this.framerate = framerate;
            return this;
        }

        @Override
        public final Builder framerate(SccDestinationFramerate framerate) {
            this.framerate(framerate == null ? null : framerate.toString());
            return this;
        }

        @Override
        public SccDestinationSettings build() {
            return new SccDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
