/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use automated ABR to have MediaConvert set up the renditions in your ABR package for you automatically, based on
 * characteristics of your input video. This feature optimizes video quality while minimizing the overall size of your
 * ABR package.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedAbrSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedAbrSettings.Builder, AutomatedAbrSettings> {
    private static final SdkField<Integer> MAX_ABR_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAbrBitrate").getter(getter(AutomatedAbrSettings::maxAbrBitrate))
            .setter(setter(Builder::maxAbrBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAbrBitrate").build()).build();

    private static final SdkField<Integer> MAX_RENDITIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRenditions").getter(getter(AutomatedAbrSettings::maxRenditions))
            .setter(setter(Builder::maxRenditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRenditions").build()).build();

    private static final SdkField<Integer> MIN_ABR_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinAbrBitrate").getter(getter(AutomatedAbrSettings::minAbrBitrate))
            .setter(setter(Builder::minAbrBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minAbrBitrate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ABR_BITRATE_FIELD,
            MAX_RENDITIONS_FIELD, MIN_ABR_BITRATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxAbrBitrate;

    private final Integer maxRenditions;

    private final Integer minAbrBitrate;

    private AutomatedAbrSettings(BuilderImpl builder) {
        this.maxAbrBitrate = builder.maxAbrBitrate;
        this.maxRenditions = builder.maxRenditions;
        this.minAbrBitrate = builder.minAbrBitrate;
    }

    /**
     * Optional. The maximum target bit rate used in your automated ABR stack. Use this value to set an upper limit on
     * the bandwidth consumed by the highest-quality rendition. This is the rendition that is delivered to viewers with
     * the fastest internet connections. If you don't specify a value, MediaConvert uses 8,000,000 (8 mb/s) by default.
     * 
     * @return Optional. The maximum target bit rate used in your automated ABR stack. Use this value to set an upper
     *         limit on the bandwidth consumed by the highest-quality rendition. This is the rendition that is delivered
     *         to viewers with the fastest internet connections. If you don't specify a value, MediaConvert uses
     *         8,000,000 (8 mb/s) by default.
     */
    public final Integer maxAbrBitrate() {
        return maxAbrBitrate;
    }

    /**
     * Optional. The maximum number of renditions that MediaConvert will create in your automated ABR stack. The number
     * of renditions is determined automatically, based on analysis of each job, but will never exceed this limit. When
     * you set this to Auto in the console, which is equivalent to excluding it from your JSON job specification,
     * MediaConvert defaults to a limit of 15.
     * 
     * @return Optional. The maximum number of renditions that MediaConvert will create in your automated ABR stack. The
     *         number of renditions is determined automatically, based on analysis of each job, but will never exceed
     *         this limit. When you set this to Auto in the console, which is equivalent to excluding it from your JSON
     *         job specification, MediaConvert defaults to a limit of 15.
     */
    public final Integer maxRenditions() {
        return maxRenditions;
    }

    /**
     * Optional. The minimum target bitrate used in your automated ABR stack. Use this value to set a lower limit on the
     * bitrate of video delivered to viewers with slow internet connections. If you don't specify a value, MediaConvert
     * uses 600,000 (600 kb/s) by default.
     * 
     * @return Optional. The minimum target bitrate used in your automated ABR stack. Use this value to set a lower
     *         limit on the bitrate of video delivered to viewers with slow internet connections. If you don't specify a
     *         value, MediaConvert uses 600,000 (600 kb/s) by default.
     */
    public final Integer minAbrBitrate() {
        return minAbrBitrate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxAbrBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(maxRenditions());
        hashCode = 31 * hashCode + Objects.hashCode(minAbrBitrate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedAbrSettings)) {
            return false;
        }
        AutomatedAbrSettings other = (AutomatedAbrSettings) obj;
        return Objects.equals(maxAbrBitrate(), other.maxAbrBitrate()) && Objects.equals(maxRenditions(), other.maxRenditions())
                && Objects.equals(minAbrBitrate(), other.minAbrBitrate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedAbrSettings").add("MaxAbrBitrate", maxAbrBitrate())
                .add("MaxRenditions", maxRenditions()).add("MinAbrBitrate", minAbrBitrate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxAbrBitrate":
            return Optional.ofNullable(clazz.cast(maxAbrBitrate()));
        case "MaxRenditions":
            return Optional.ofNullable(clazz.cast(maxRenditions()));
        case "MinAbrBitrate":
            return Optional.ofNullable(clazz.cast(minAbrBitrate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomatedAbrSettings, T> g) {
        return obj -> g.apply((AutomatedAbrSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedAbrSettings> {
        /**
         * Optional. The maximum target bit rate used in your automated ABR stack. Use this value to set an upper limit
         * on the bandwidth consumed by the highest-quality rendition. This is the rendition that is delivered to
         * viewers with the fastest internet connections. If you don't specify a value, MediaConvert uses 8,000,000 (8
         * mb/s) by default.
         * 
         * @param maxAbrBitrate
         *        Optional. The maximum target bit rate used in your automated ABR stack. Use this value to set an upper
         *        limit on the bandwidth consumed by the highest-quality rendition. This is the rendition that is
         *        delivered to viewers with the fastest internet connections. If you don't specify a value, MediaConvert
         *        uses 8,000,000 (8 mb/s) by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAbrBitrate(Integer maxAbrBitrate);

        /**
         * Optional. The maximum number of renditions that MediaConvert will create in your automated ABR stack. The
         * number of renditions is determined automatically, based on analysis of each job, but will never exceed this
         * limit. When you set this to Auto in the console, which is equivalent to excluding it from your JSON job
         * specification, MediaConvert defaults to a limit of 15.
         * 
         * @param maxRenditions
         *        Optional. The maximum number of renditions that MediaConvert will create in your automated ABR stack.
         *        The number of renditions is determined automatically, based on analysis of each job, but will never
         *        exceed this limit. When you set this to Auto in the console, which is equivalent to excluding it from
         *        your JSON job specification, MediaConvert defaults to a limit of 15.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRenditions(Integer maxRenditions);

        /**
         * Optional. The minimum target bitrate used in your automated ABR stack. Use this value to set a lower limit on
         * the bitrate of video delivered to viewers with slow internet connections. If you don't specify a value,
         * MediaConvert uses 600,000 (600 kb/s) by default.
         * 
         * @param minAbrBitrate
         *        Optional. The minimum target bitrate used in your automated ABR stack. Use this value to set a lower
         *        limit on the bitrate of video delivered to viewers with slow internet connections. If you don't
         *        specify a value, MediaConvert uses 600,000 (600 kb/s) by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAbrBitrate(Integer minAbrBitrate);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxAbrBitrate;

        private Integer maxRenditions;

        private Integer minAbrBitrate;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedAbrSettings model) {
            maxAbrBitrate(model.maxAbrBitrate);
            maxRenditions(model.maxRenditions);
            minAbrBitrate(model.minAbrBitrate);
        }

        public final Integer getMaxAbrBitrate() {
            return maxAbrBitrate;
        }

        public final void setMaxAbrBitrate(Integer maxAbrBitrate) {
            this.maxAbrBitrate = maxAbrBitrate;
        }

        @Override
        @Transient
        public final Builder maxAbrBitrate(Integer maxAbrBitrate) {
            this.maxAbrBitrate = maxAbrBitrate;
            return this;
        }

        public final Integer getMaxRenditions() {
            return maxRenditions;
        }

        public final void setMaxRenditions(Integer maxRenditions) {
            this.maxRenditions = maxRenditions;
        }

        @Override
        @Transient
        public final Builder maxRenditions(Integer maxRenditions) {
            this.maxRenditions = maxRenditions;
            return this;
        }

        public final Integer getMinAbrBitrate() {
            return minAbrBitrate;
        }

        public final void setMinAbrBitrate(Integer minAbrBitrate) {
            this.minAbrBitrate = minAbrBitrate;
        }

        @Override
        @Transient
        public final Builder minAbrBitrate(Integer minAbrBitrate) {
            this.minAbrBitrate = minAbrBitrate;
            return this;
        }

        @Override
        public AutomatedAbrSettings build() {
            return new AutomatedAbrSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
