/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobRequest extends MediaConvertRequest implements
        ToCopyableBuilder<CreateJobRequest.Builder, CreateJobRequest> {
    private static final SdkField<AccelerationSettings> ACCELERATION_SETTINGS_FIELD = SdkField
            .<AccelerationSettings> builder(MarshallingType.SDK_POJO).memberName("AccelerationSettings")
            .getter(getter(CreateJobRequest::accelerationSettings)).setter(setter(Builder::accelerationSettings))
            .constructor(AccelerationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerationSettings").build())
            .build();

    private static final SdkField<String> BILLING_TAGS_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingTagsSource").getter(getter(CreateJobRequest::billingTagsSourceAsString))
            .setter(setter(Builder::billingTagsSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingTagsSource").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateJobRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<HopDestination>> HOP_DESTINATIONS_FIELD = SdkField
            .<List<HopDestination>> builder(MarshallingType.LIST)
            .memberName("HopDestinations")
            .getter(getter(CreateJobRequest::hopDestinations))
            .setter(setter(Builder::hopDestinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hopDestinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HopDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(HopDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JOB_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobTemplate").getter(getter(CreateJobRequest::jobTemplate)).setter(setter(Builder::jobTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplate").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(CreateJobRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Queue")
            .getter(getter(CreateJobRequest::queue)).setter(setter(Builder::queue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(CreateJobRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<JobSettings> SETTINGS_FIELD = SdkField.<JobSettings> builder(MarshallingType.SDK_POJO)
            .memberName("Settings").getter(getter(CreateJobRequest::settings)).setter(setter(Builder::settings))
            .constructor(JobSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()).build();

    private static final SdkField<String> SIMULATE_RESERVED_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SimulateReservedQueue").getter(getter(CreateJobRequest::simulateReservedQueueAsString))
            .setter(setter(Builder::simulateReservedQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulateReservedQueue").build())
            .build();

    private static final SdkField<String> STATUS_UPDATE_INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusUpdateInterval").getter(getter(CreateJobRequest::statusUpdateIntervalAsString))
            .setter(setter(Builder::statusUpdateInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusUpdateInterval").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> USER_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("UserMetadata")
            .getter(getter(CreateJobRequest::userMetadata))
            .setter(setter(Builder::userMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATION_SETTINGS_FIELD,
            BILLING_TAGS_SOURCE_FIELD, CLIENT_REQUEST_TOKEN_FIELD, HOP_DESTINATIONS_FIELD, JOB_TEMPLATE_FIELD, PRIORITY_FIELD,
            QUEUE_FIELD, ROLE_FIELD, SETTINGS_FIELD, SIMULATE_RESERVED_QUEUE_FIELD, STATUS_UPDATE_INTERVAL_FIELD, TAGS_FIELD,
            USER_METADATA_FIELD));

    private final AccelerationSettings accelerationSettings;

    private final String billingTagsSource;

    private final String clientRequestToken;

    private final List<HopDestination> hopDestinations;

    private final String jobTemplate;

    private final Integer priority;

    private final String queue;

    private final String role;

    private final JobSettings settings;

    private final String simulateReservedQueue;

    private final String statusUpdateInterval;

    private final Map<String, String> tags;

    private final Map<String, String> userMetadata;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.accelerationSettings = builder.accelerationSettings;
        this.billingTagsSource = builder.billingTagsSource;
        this.clientRequestToken = builder.clientRequestToken;
        this.hopDestinations = builder.hopDestinations;
        this.jobTemplate = builder.jobTemplate;
        this.priority = builder.priority;
        this.queue = builder.queue;
        this.role = builder.role;
        this.settings = builder.settings;
        this.simulateReservedQueue = builder.simulateReservedQueue;
        this.statusUpdateInterval = builder.statusUpdateInterval;
        this.tags = builder.tags;
        this.userMetadata = builder.userMetadata;
    }

    /**
     * Optional. Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs
     * that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental
     * MediaConvert User Guide.
     * 
     * @return Optional. Accelerated transcoding can significantly speed up jobs with long, visually complex content.
     *         Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the
     *         AWS Elemental MediaConvert User Guide.
     */
    public final AccelerationSettings accelerationSettings() {
        return accelerationSettings;
    }

    /**
     * Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert
     * costs on any billing report that you set up. Any transcoding outputs that don't have an associated tag will
     * appear in your billing report unsorted. If you don't choose a valid value for this field, your job outputs will
     * appear on the billing report unsorted.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingTagsSource}
     * will return {@link BillingTagsSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #billingTagsSourceAsString}.
     * </p>
     * 
     * @return Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental
     *         MediaConvert costs on any billing report that you set up. Any transcoding outputs that don't have an
     *         associated tag will appear in your billing report unsorted. If you don't choose a valid value for this
     *         field, your job outputs will appear on the billing report unsorted.
     * @see BillingTagsSource
     */
    public final BillingTagsSource billingTagsSource() {
        return BillingTagsSource.fromValue(billingTagsSource);
    }

    /**
     * Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert
     * costs on any billing report that you set up. Any transcoding outputs that don't have an associated tag will
     * appear in your billing report unsorted. If you don't choose a valid value for this field, your job outputs will
     * appear on the billing report unsorted.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingTagsSource}
     * will return {@link BillingTagsSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #billingTagsSourceAsString}.
     * </p>
     * 
     * @return Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental
     *         MediaConvert costs on any billing report that you set up. Any transcoding outputs that don't have an
     *         associated tag will appear in your billing report unsorted. If you don't choose a valid value for this
     *         field, your job outputs will appear on the billing report unsorted.
     * @see BillingTagsSource
     */
    public final String billingTagsSourceAsString() {
        return billingTagsSource;
    }

    /**
     * Optional. Idempotency token for CreateJob operation.
     * 
     * @return Optional. Idempotency token for CreateJob operation.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the HopDestinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHopDestinations() {
        return hopDestinations != null && !(hopDestinations instanceof SdkAutoConstructList);
    }

    /**
     * Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job to.
     * Specify an alternate queue and the maximum time that your job will wait in the initial queue before hopping. For
     * more information about this feature, see the AWS Elemental MediaConvert User Guide.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHopDestinations} method.
     * </p>
     * 
     * @return Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your
     *         job to. Specify an alternate queue and the maximum time that your job will wait in the initial queue
     *         before hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide.
     */
    public final List<HopDestination> hopDestinations() {
        return hopDestinations;
    }

    /**
     * Optional. When you create a job, you can either specify a job template or specify the transcoding settings
     * individually.
     * 
     * @return Optional. When you create a job, you can either specify a job template or specify the transcoding
     *         settings individually.
     */
    public final String jobTemplate() {
        return jobTemplate;
    }

    /**
     * Optional. Specify the relative priority for this job. In any given queue, the service begins processing the job
     * with the highest value first. When more than one job has the same priority, the service begins processing the job
     * that you submitted first. If you don't specify a priority, the service uses the default value 0.
     * 
     * @return Optional. Specify the relative priority for this job. In any given queue, the service begins processing
     *         the job with the highest value first. When more than one job has the same priority, the service begins
     *         processing the job that you submitted first. If you don't specify a priority, the service uses the
     *         default value 0.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * Optional. When you create a job, you can specify a queue to send it to. If you don't specify, the job will go to
     * the default queue. For more about queues, see the User Guide topic at
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html.
     * 
     * @return Optional. When you create a job, you can specify a queue to send it to. If you don't specify, the job
     *         will go to the default queue. For more about queues, see the User Guide topic at
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html.
     */
    public final String queue() {
        return queue;
    }

    /**
     * Required. The IAM role you use for creating this job. For details about permissions, see the User Guide topic at
     * the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
     * 
     * @return Required. The IAM role you use for creating this job. For details about permissions, see the User Guide
     *         topic at the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
     */
    public final String role() {
        return role;
    }

    /**
     * JobSettings contains all the transcode settings for a job.
     * 
     * @return JobSettings contains all the transcode settings for a job.
     */
    public final JobSettings settings() {
        return settings;
    }

    /**
     * Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you
     * need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what
     * you will see with one RTS in a reserved queue. This setting is disabled by default.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #simulateReservedQueue} will return {@link SimulateReservedQueue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #simulateReservedQueueAsString}.
     * </p>
     * 
     * @return Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots
     *         (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar
     *         performance to what you will see with one RTS in a reserved queue. This setting is disabled by default.
     * @see SimulateReservedQueue
     */
    public final SimulateReservedQueue simulateReservedQueue() {
        return SimulateReservedQueue.fromValue(simulateReservedQueue);
    }

    /**
     * Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you
     * need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what
     * you will see with one RTS in a reserved queue. This setting is disabled by default.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #simulateReservedQueue} will return {@link SimulateReservedQueue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #simulateReservedQueueAsString}.
     * </p>
     * 
     * @return Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots
     *         (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar
     *         performance to what you will see with one RTS in a reserved queue. This setting is disabled by default.
     * @see SimulateReservedQueue
     */
    public final String simulateReservedQueueAsString() {
        return simulateReservedQueue;
    }

    /**
     * Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the
     * interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the
     * service begins processing your job to the time it completes the transcode or encounters an error.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #statusUpdateInterval} will return {@link StatusUpdateInterval#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #statusUpdateIntervalAsString}.
     * </p>
     * 
     * @return Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the
     *         interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time
     *         the service begins processing your job to the time it completes the transcode or encounters an error.
     * @see StatusUpdateInterval
     */
    public final StatusUpdateInterval statusUpdateInterval() {
        return StatusUpdateInterval.fromValue(statusUpdateInterval);
    }

    /**
     * Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the
     * interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the
     * service begins processing your job to the time it completes the transcode or encounters an error.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #statusUpdateInterval} will return {@link StatusUpdateInterval#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #statusUpdateIntervalAsString}.
     * </p>
     * 
     * @return Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the
     *         interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time
     *         the service begins processing your job to the time it completes the transcode or encounters an error.
     * @see StatusUpdateInterval
     */
    public final String statusUpdateIntervalAsString() {
        return statusUpdateInterval;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Optional. The tags that you want to add to the resource. You can tag resources with a key-value pair or with only
     * a key. Use standard AWS tags on your job for automatic integration with AWS services and for custom integrations
     * and workflows.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional. The tags that you want to add to the resource. You can tag resources with a key-value pair or
     *         with only a key. Use standard AWS tags on your job for automatic integration with AWS services and for
     *         custom integrations and workflows.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserMetadata() {
        return userMetadata != null && !(userMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * Optional. User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in
     * key/value pairs. Use only for existing integrations or workflows that rely on job metadata tags. Otherwise, we
     * recommend that you use standard AWS tags.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserMetadata} method.
     * </p>
     * 
     * @return Optional. User-defined metadata that you want to associate with an MediaConvert job. You specify metadata
     *         in key/value pairs. Use only for existing integrations or workflows that rely on job metadata tags.
     *         Otherwise, we recommend that you use standard AWS tags.
     */
    public final Map<String, String> userMetadata() {
        return userMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accelerationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(billingTagsSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasHopDestinations() ? hopDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(queue());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(simulateReservedQueueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusUpdateIntervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserMetadata() ? userMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest) obj;
        return Objects.equals(accelerationSettings(), other.accelerationSettings())
                && Objects.equals(billingTagsSourceAsString(), other.billingTagsSourceAsString())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && hasHopDestinations() == other.hasHopDestinations()
                && Objects.equals(hopDestinations(), other.hopDestinations())
                && Objects.equals(jobTemplate(), other.jobTemplate()) && Objects.equals(priority(), other.priority())
                && Objects.equals(queue(), other.queue()) && Objects.equals(role(), other.role())
                && Objects.equals(settings(), other.settings())
                && Objects.equals(simulateReservedQueueAsString(), other.simulateReservedQueueAsString())
                && Objects.equals(statusUpdateIntervalAsString(), other.statusUpdateIntervalAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasUserMetadata() == other.hasUserMetadata() && Objects.equals(userMetadata(), other.userMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateJobRequest").add("AccelerationSettings", accelerationSettings())
                .add("BillingTagsSource", billingTagsSourceAsString()).add("ClientRequestToken", clientRequestToken())
                .add("HopDestinations", hasHopDestinations() ? hopDestinations() : null).add("JobTemplate", jobTemplate())
                .add("Priority", priority()).add("Queue", queue()).add("Role", role()).add("Settings", settings())
                .add("SimulateReservedQueue", simulateReservedQueueAsString())
                .add("StatusUpdateInterval", statusUpdateIntervalAsString()).add("Tags", hasTags() ? tags() : null)
                .add("UserMetadata", hasUserMetadata() ? userMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccelerationSettings":
            return Optional.ofNullable(clazz.cast(accelerationSettings()));
        case "BillingTagsSource":
            return Optional.ofNullable(clazz.cast(billingTagsSourceAsString()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "HopDestinations":
            return Optional.ofNullable(clazz.cast(hopDestinations()));
        case "JobTemplate":
            return Optional.ofNullable(clazz.cast(jobTemplate()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Queue":
            return Optional.ofNullable(clazz.cast(queue()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "SimulateReservedQueue":
            return Optional.ofNullable(clazz.cast(simulateReservedQueueAsString()));
        case "StatusUpdateInterval":
            return Optional.ofNullable(clazz.cast(statusUpdateIntervalAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UserMetadata":
            return Optional.ofNullable(clazz.cast(userMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobRequest> {
        /**
         * Optional. Accelerated transcoding can significantly speed up jobs with long, visually complex content.
         * Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS
         * Elemental MediaConvert User Guide.
         * 
         * @param accelerationSettings
         *        Optional. Accelerated transcoding can significantly speed up jobs with long, visually complex content.
         *        Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see
         *        the AWS Elemental MediaConvert User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerationSettings(AccelerationSettings accelerationSettings);

        /**
         * Optional. Accelerated transcoding can significantly speed up jobs with long, visually complex content.
         * Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS
         * Elemental MediaConvert User Guide. This is a convenience that creates an instance of the
         * {@link AccelerationSettings.Builder} avoiding the need to create one manually via
         * {@link AccelerationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccelerationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #accelerationSettings(AccelerationSettings)}.
         * 
         * @param accelerationSettings
         *        a consumer that will call methods on {@link AccelerationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accelerationSettings(AccelerationSettings)
         */
        default Builder accelerationSettings(Consumer<AccelerationSettings.Builder> accelerationSettings) {
            return accelerationSettings(AccelerationSettings.builder().applyMutation(accelerationSettings).build());
        }

        /**
         * Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental
         * MediaConvert costs on any billing report that you set up. Any transcoding outputs that don't have an
         * associated tag will appear in your billing report unsorted. If you don't choose a valid value for this field,
         * your job outputs will appear on the billing report unsorted.
         * 
         * @param billingTagsSource
         *        Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental
         *        MediaConvert costs on any billing report that you set up. Any transcoding outputs that don't have an
         *        associated tag will appear in your billing report unsorted. If you don't choose a valid value for this
         *        field, your job outputs will appear on the billing report unsorted.
         * @see BillingTagsSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingTagsSource
         */
        Builder billingTagsSource(String billingTagsSource);

        /**
         * Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental
         * MediaConvert costs on any billing report that you set up. Any transcoding outputs that don't have an
         * associated tag will appear in your billing report unsorted. If you don't choose a valid value for this field,
         * your job outputs will appear on the billing report unsorted.
         * 
         * @param billingTagsSource
         *        Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental
         *        MediaConvert costs on any billing report that you set up. Any transcoding outputs that don't have an
         *        associated tag will appear in your billing report unsorted. If you don't choose a valid value for this
         *        field, your job outputs will appear on the billing report unsorted.
         * @see BillingTagsSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingTagsSource
         */
        Builder billingTagsSource(BillingTagsSource billingTagsSource);

        /**
         * Optional. Idempotency token for CreateJob operation.
         * 
         * @param clientRequestToken
         *        Optional. Idempotency token for CreateJob operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job
         * to. Specify an alternate queue and the maximum time that your job will wait in the initial queue before
         * hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide.
         * 
         * @param hopDestinations
         *        Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit
         *        your job to. Specify an alternate queue and the maximum time that your job will wait in the initial
         *        queue before hopping. For more information about this feature, see the AWS Elemental MediaConvert User
         *        Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hopDestinations(Collection<HopDestination> hopDestinations);

        /**
         * Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job
         * to. Specify an alternate queue and the maximum time that your job will wait in the initial queue before
         * hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide.
         * 
         * @param hopDestinations
         *        Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit
         *        your job to. Specify an alternate queue and the maximum time that your job will wait in the initial
         *        queue before hopping. For more information about this feature, see the AWS Elemental MediaConvert User
         *        Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hopDestinations(HopDestination... hopDestinations);

        /**
         * Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job
         * to. Specify an alternate queue and the maximum time that your job will wait in the initial queue before
         * hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide. This is a
         * convenience that creates an instance of the {@link List<HopDestination>.Builder} avoiding the need to create
         * one manually via {@link List<HopDestination>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HopDestination>.Builder#build()} is called immediately and
         * its result is passed to {@link #hopDestinations(List<HopDestination>)}.
         * 
         * @param hopDestinations
         *        a consumer that will call methods on {@link List<HopDestination>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hopDestinations(List<HopDestination>)
         */
        Builder hopDestinations(Consumer<HopDestination.Builder>... hopDestinations);

        /**
         * Optional. When you create a job, you can either specify a job template or specify the transcoding settings
         * individually.
         * 
         * @param jobTemplate
         *        Optional. When you create a job, you can either specify a job template or specify the transcoding
         *        settings individually.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplate(String jobTemplate);

        /**
         * Optional. Specify the relative priority for this job. In any given queue, the service begins processing the
         * job with the highest value first. When more than one job has the same priority, the service begins processing
         * the job that you submitted first. If you don't specify a priority, the service uses the default value 0.
         * 
         * @param priority
         *        Optional. Specify the relative priority for this job. In any given queue, the service begins
         *        processing the job with the highest value first. When more than one job has the same priority, the
         *        service begins processing the job that you submitted first. If you don't specify a priority, the
         *        service uses the default value 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * Optional. When you create a job, you can specify a queue to send it to. If you don't specify, the job will go
         * to the default queue. For more about queues, see the User Guide topic at
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html.
         * 
         * @param queue
         *        Optional. When you create a job, you can specify a queue to send it to. If you don't specify, the job
         *        will go to the default queue. For more about queues, see the User Guide topic at
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queue(String queue);

        /**
         * Required. The IAM role you use for creating this job. For details about permissions, see the User Guide topic
         * at the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
         * 
         * @param role
         *        Required. The IAM role you use for creating this job. For details about permissions, see the User
         *        Guide topic at the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * JobSettings contains all the transcode settings for a job.
         * 
         * @param settings
         *        JobSettings contains all the transcode settings for a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(JobSettings settings);

        /**
         * JobSettings contains all the transcode settings for a job. This is a convenience that creates an instance of
         * the {@link JobSettings.Builder} avoiding the need to create one manually via {@link JobSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #settings(JobSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link JobSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(JobSettings)
         */
        default Builder settings(Consumer<JobSettings.Builder> settings) {
            return settings(JobSettings.builder().applyMutation(settings).build());
        }

        /**
         * Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS)
         * you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance
         * to what you will see with one RTS in a reserved queue. This setting is disabled by default.
         * 
         * @param simulateReservedQueue
         *        Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots
         *        (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar
         *        performance to what you will see with one RTS in a reserved queue. This setting is disabled by
         *        default.
         * @see SimulateReservedQueue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulateReservedQueue
         */
        Builder simulateReservedQueue(String simulateReservedQueue);

        /**
         * Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS)
         * you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance
         * to what you will see with one RTS in a reserved queue. This setting is disabled by default.
         * 
         * @param simulateReservedQueue
         *        Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots
         *        (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar
         *        performance to what you will see with one RTS in a reserved queue. This setting is disabled by
         *        default.
         * @see SimulateReservedQueue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulateReservedQueue
         */
        Builder simulateReservedQueue(SimulateReservedQueue simulateReservedQueue);

        /**
         * Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the
         * interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the
         * service begins processing your job to the time it completes the transcode or encounters an error.
         * 
         * @param statusUpdateInterval
         *        Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set
         *        the interval, in seconds, between status updates. MediaConvert sends an update at this interval from
         *        the time the service begins processing your job to the time it completes the transcode or encounters
         *        an error.
         * @see StatusUpdateInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusUpdateInterval
         */
        Builder statusUpdateInterval(String statusUpdateInterval);

        /**
         * Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the
         * interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the
         * service begins processing your job to the time it completes the transcode or encounters an error.
         * 
         * @param statusUpdateInterval
         *        Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set
         *        the interval, in seconds, between status updates. MediaConvert sends an update at this interval from
         *        the time the service begins processing your job to the time it completes the transcode or encounters
         *        an error.
         * @see StatusUpdateInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusUpdateInterval
         */
        Builder statusUpdateInterval(StatusUpdateInterval statusUpdateInterval);

        /**
         * Optional. The tags that you want to add to the resource. You can tag resources with a key-value pair or with
         * only a key. Use standard AWS tags on your job for automatic integration with AWS services and for custom
         * integrations and workflows.
         * 
         * @param tags
         *        Optional. The tags that you want to add to the resource. You can tag resources with a key-value pair
         *        or with only a key. Use standard AWS tags on your job for automatic integration with AWS services and
         *        for custom integrations and workflows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * Optional. User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in
         * key/value pairs. Use only for existing integrations or workflows that rely on job metadata tags. Otherwise,
         * we recommend that you use standard AWS tags.
         * 
         * @param userMetadata
         *        Optional. User-defined metadata that you want to associate with an MediaConvert job. You specify
         *        metadata in key/value pairs. Use only for existing integrations or workflows that rely on job metadata
         *        tags. Otherwise, we recommend that you use standard AWS tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMetadata(Map<String, String> userMetadata);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConvertRequest.BuilderImpl implements Builder {
        private AccelerationSettings accelerationSettings;

        private String billingTagsSource;

        private String clientRequestToken;

        private List<HopDestination> hopDestinations = DefaultSdkAutoConstructList.getInstance();

        private String jobTemplate;

        private Integer priority;

        private String queue;

        private String role;

        private JobSettings settings;

        private String simulateReservedQueue;

        private String statusUpdateInterval;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> userMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            accelerationSettings(model.accelerationSettings);
            billingTagsSource(model.billingTagsSource);
            clientRequestToken(model.clientRequestToken);
            hopDestinations(model.hopDestinations);
            jobTemplate(model.jobTemplate);
            priority(model.priority);
            queue(model.queue);
            role(model.role);
            settings(model.settings);
            simulateReservedQueue(model.simulateReservedQueue);
            statusUpdateInterval(model.statusUpdateInterval);
            tags(model.tags);
            userMetadata(model.userMetadata);
        }

        public final AccelerationSettings.Builder getAccelerationSettings() {
            return accelerationSettings != null ? accelerationSettings.toBuilder() : null;
        }

        public final void setAccelerationSettings(AccelerationSettings.BuilderImpl accelerationSettings) {
            this.accelerationSettings = accelerationSettings != null ? accelerationSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder accelerationSettings(AccelerationSettings accelerationSettings) {
            this.accelerationSettings = accelerationSettings;
            return this;
        }

        public final String getBillingTagsSource() {
            return billingTagsSource;
        }

        public final void setBillingTagsSource(String billingTagsSource) {
            this.billingTagsSource = billingTagsSource;
        }

        @Override
        @Transient
        public final Builder billingTagsSource(String billingTagsSource) {
            this.billingTagsSource = billingTagsSource;
            return this;
        }

        @Override
        @Transient
        public final Builder billingTagsSource(BillingTagsSource billingTagsSource) {
            this.billingTagsSource(billingTagsSource == null ? null : billingTagsSource.toString());
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<HopDestination.Builder> getHopDestinations() {
            List<HopDestination.Builder> result = ___listOfHopDestinationCopier.copyToBuilder(this.hopDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHopDestinations(Collection<HopDestination.BuilderImpl> hopDestinations) {
            this.hopDestinations = ___listOfHopDestinationCopier.copyFromBuilder(hopDestinations);
        }

        @Override
        @Transient
        public final Builder hopDestinations(Collection<HopDestination> hopDestinations) {
            this.hopDestinations = ___listOfHopDestinationCopier.copy(hopDestinations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder hopDestinations(HopDestination... hopDestinations) {
            hopDestinations(Arrays.asList(hopDestinations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder hopDestinations(Consumer<HopDestination.Builder>... hopDestinations) {
            hopDestinations(Stream.of(hopDestinations).map(c -> HopDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getJobTemplate() {
            return jobTemplate;
        }

        public final void setJobTemplate(String jobTemplate) {
            this.jobTemplate = jobTemplate;
        }

        @Override
        @Transient
        public final Builder jobTemplate(String jobTemplate) {
            this.jobTemplate = jobTemplate;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getQueue() {
            return queue;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        @Override
        @Transient
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        @Transient
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final JobSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(JobSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(JobSettings settings) {
            this.settings = settings;
            return this;
        }

        public final String getSimulateReservedQueue() {
            return simulateReservedQueue;
        }

        public final void setSimulateReservedQueue(String simulateReservedQueue) {
            this.simulateReservedQueue = simulateReservedQueue;
        }

        @Override
        @Transient
        public final Builder simulateReservedQueue(String simulateReservedQueue) {
            this.simulateReservedQueue = simulateReservedQueue;
            return this;
        }

        @Override
        @Transient
        public final Builder simulateReservedQueue(SimulateReservedQueue simulateReservedQueue) {
            this.simulateReservedQueue(simulateReservedQueue == null ? null : simulateReservedQueue.toString());
            return this;
        }

        public final String getStatusUpdateInterval() {
            return statusUpdateInterval;
        }

        public final void setStatusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
        }

        @Override
        @Transient
        public final Builder statusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
            return this;
        }

        @Override
        @Transient
        public final Builder statusUpdateInterval(StatusUpdateInterval statusUpdateInterval) {
            this.statusUpdateInterval(statusUpdateInterval == null ? null : statusUpdateInterval.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getUserMetadata() {
            if (userMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return userMetadata;
        }

        public final void setUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = ___mapOf__stringCopier.copy(userMetadata);
        }

        @Override
        @Transient
        public final Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = ___mapOf__stringCopier.copy(userMetadata);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
