/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Ignore this setting unless Style Passthrough (StylePassthrough) is set to Enabled and Font color (FontColor) set to
 * Black, Yellow, Red, Green, Blue, or Hex. Use Apply font color (ApplyFontColor) for additional font color controls.
 * When you choose White text only (WHITE_TEXT_ONLY), or leave blank, your font color setting only applies to white text
 * in your input captions. For example, if your font color setting is Yellow, and your input captions have red and white
 * text, your output captions will have red and yellow text. When you choose ALL_TEXT, your font color setting applies
 * to all of your output captions text.
 */
@Generated("software.amazon.awssdk:codegen")
public enum DvbSubtitleApplyFontColor {
    WHITE_TEXT_ONLY("WHITE_TEXT_ONLY"),

    ALL_TEXT("ALL_TEXT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DvbSubtitleApplyFontColor> VALUE_MAP = EnumUtils.uniqueIndex(
            DvbSubtitleApplyFontColor.class, DvbSubtitleApplyFontColor::toString);

    private final String value;

    private DvbSubtitleApplyFontColor(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DvbSubtitleApplyFontColor corresponding to the value
     */
    public static DvbSubtitleApplyFontColor fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DvbSubtitleApplyFontColor}s
     */
    public static Set<DvbSubtitleApplyFontColor> knownValues() {
        Set<DvbSubtitleApplyFontColor> knownValues = EnumSet.allOf(DvbSubtitleApplyFontColor.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
