/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings related to your File output group. MediaConvert uses this group of settings to generate a single standalone
 * file, rather than a streaming package. When you work directly in your JSON job specification, include this object and
 * any required children when you set Type, under OutputGroupSettings, to FILE_GROUP_SETTINGS.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<FileGroupSettings.Builder, FileGroupSettings> {
    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(FileGroupSettings::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField
            .<DestinationSettings> builder(MarshallingType.SDK_POJO).memberName("DestinationSettings")
            .getter(getter(FileGroupSettings::destinationSettings)).setter(setter(Builder::destinationSettings))
            .constructor(DestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            DESTINATION_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destination;

    private final DestinationSettings destinationSettings;

    private FileGroupSettings(BuilderImpl builder) {
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
    }

    /**
     * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts
     * format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the
     * input file. If your job has multiple inputs, the service uses the filename of the first input file.
     * 
     * @return Use Destination (Destination) to specify the S3 output location and the output filename base. Destination
     *         accepts format identifiers. If you do not specify the base filename in the URI, the service will use the
     *         filename of the input file. If your job has multiple inputs, the service uses the filename of the first
     *         input file.
     */
    public final String destination() {
        return destination;
    }

    /**
     * Settings associated with the destination. Will vary based on the type of destination
     * 
     * @return Settings associated with the destination. Will vary based on the type of destination
     */
    public final DestinationSettings destinationSettings() {
        return destinationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileGroupSettings)) {
            return false;
        }
        FileGroupSettings other = (FileGroupSettings) obj;
        return Objects.equals(destination(), other.destination())
                && Objects.equals(destinationSettings(), other.destinationSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileGroupSettings").add("Destination", destination())
                .add("DestinationSettings", destinationSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DestinationSettings":
            return Optional.ofNullable(clazz.cast(destinationSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileGroupSettings, T> g) {
        return obj -> g.apply((FileGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileGroupSettings> {
        /**
         * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination
         * accepts format identifiers. If you do not specify the base filename in the URI, the service will use the
         * filename of the input file. If your job has multiple inputs, the service uses the filename of the first input
         * file.
         * 
         * @param destination
         *        Use Destination (Destination) to specify the S3 output location and the output filename base.
         *        Destination accepts format identifiers. If you do not specify the base filename in the URI, the
         *        service will use the filename of the input file. If your job has multiple inputs, the service uses the
         *        filename of the first input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * Settings associated with the destination. Will vary based on the type of destination
         * 
         * @param destinationSettings
         *        Settings associated with the destination. Will vary based on the type of destination
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSettings(DestinationSettings destinationSettings);

        /**
         * Settings associated with the destination. Will vary based on the type of destination This is a convenience
         * that creates an instance of the {@link DestinationSettings.Builder} avoiding the need to create one manually
         * via {@link DestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationSettings(DestinationSettings)}.
         * 
         * @param destinationSettings
         *        a consumer that will call methods on {@link DestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSettings(DestinationSettings)
         */
        default Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return destinationSettings(DestinationSettings.builder().applyMutation(destinationSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String destination;

        private DestinationSettings destinationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(FileGroupSettings model) {
            destination(model.destination);
            destinationSettings(model.destinationSettings);
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        @Transient
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return destinationSettings != null ? destinationSettings.toBuilder() : null;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        @Override
        public FileGroupSettings build() {
            return new FileGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
