/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPolicyResponse extends MediaConvertResponse implements
        ToCopyableBuilder<GetPolicyResponse.Builder, GetPolicyResponse> {
    private static final SdkField<Policy> POLICY_FIELD = SdkField.<Policy> builder(MarshallingType.SDK_POJO).memberName("Policy")
            .getter(getter(GetPolicyResponse::policy)).setter(setter(Builder::policy)).constructor(Policy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD));

    private final Policy policy;

    private GetPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
    }

    /**
     * A policy configures behavior that you allow or disallow for your account. For information about MediaConvert
     * policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     * 
     * @return A policy configures behavior that you allow or disallow for your account. For information about
     *         MediaConvert policies, see the user guide at
     *         http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    public final Policy policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyResponse)) {
            return false;
        }
        GetPolicyResponse other = (GetPolicyResponse) obj;
        return Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPolicyResponse").add("Policy", policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPolicyResponse, T> g) {
        return obj -> g.apply((GetPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPolicyResponse> {
        /**
         * A policy configures behavior that you allow or disallow for your account. For information about MediaConvert
         * policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
         * 
         * @param policy
         *        A policy configures behavior that you allow or disallow for your account. For information about
         *        MediaConvert policies, see the user guide at
         *        http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(Policy policy);

        /**
         * A policy configures behavior that you allow or disallow for your account. For information about MediaConvert
         * policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html This is a
         * convenience that creates an instance of the {@link Policy.Builder} avoiding the need to create one manually
         * via {@link Policy#builder()}.
         *
         * When the {@link Consumer} completes, {@link Policy.Builder#build()} is called immediately and its result is
         * passed to {@link #policy(Policy)}.
         * 
         * @param policy
         *        a consumer that will call methods on {@link Policy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policy(Policy)
         */
        default Builder policy(Consumer<Policy.Builder> policy) {
            return policy(Policy.builder().applyMutation(policy).build());
        }
    }

    static final class BuilderImpl extends MediaConvertResponse.BuilderImpl implements Builder {
        private Policy policy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyResponse model) {
            super(model);
            policy(model.policy);
        }

        public final Policy.Builder getPolicy() {
            return policy != null ? policy.toBuilder() : null;
        }

        public final void setPolicy(Policy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        @Transient
        public final Builder policy(Policy policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public GetPolicyResponse build() {
            return new GetPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
