/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking. MediaConvert supports
 * both PreRelease Content (NGPR/G2) and OTT Streaming workflows.
 */
@Generated("software.amazon.awssdk:codegen")
public final class NexGuardFileMarkerSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<NexGuardFileMarkerSettings.Builder, NexGuardFileMarkerSettings> {
    private static final SdkField<String> LICENSE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("License")
            .getter(getter(NexGuardFileMarkerSettings::license)).setter(setter(Builder::license))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("license").build()).build();

    private static final SdkField<Integer> PAYLOAD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Payload").getter(getter(NexGuardFileMarkerSettings::payload)).setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final SdkField<String> PRESET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Preset")
            .getter(getter(NexGuardFileMarkerSettings::preset)).setter(setter(Builder::preset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preset").build()).build();

    private static final SdkField<String> STRENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Strength").getter(getter(NexGuardFileMarkerSettings::strengthAsString))
            .setter(setter(Builder::strength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_FIELD, PAYLOAD_FIELD,
            PRESET_FIELD, STRENGTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String license;

    private final Integer payload;

    private final String preset;

    private final String strength;

    private NexGuardFileMarkerSettings(BuilderImpl builder) {
        this.license = builder.license;
        this.payload = builder.payload;
        this.preset = builder.preset;
        this.strength = builder.strength;
    }

    /**
     * Use the base64 license string that Nagra provides you. Enter it directly in your JSON job specification or in the
     * console. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your
     * job.
     * 
     * @return Use the base64 license string that Nagra provides you. Enter it directly in your JSON job specification
     *         or in the console. Required when you include Nagra NexGuard File Marker watermarking
     *         (NexGuardWatermarkingSettings) in your job.
     */
    public final String license() {
        return license;
    }

    /**
     * Specify the payload ID that you want associated with this output. Valid values vary depending on your Nagra
     * NexGuard forensic watermarking workflow. Required when you include Nagra NexGuard File Marker watermarking
     * (NexGuardWatermarkingSettings) in your job. For PreRelease Content (NGPR/G2), specify an integer from 1 through
     * 4,194,303. You must generate a unique ID for each asset you watermark, and keep a record of which ID you have
     * assigned to each asset. Neither Nagra nor MediaConvert keep track of the relationship between output files and
     * your IDs. For OTT Streaming, create two adaptive bitrate (ABR) stacks for each asset. Do this by setting up two
     * output groups. For one output group, set the value of Payload ID (payload) to 0 in every output. For the other
     * output group, set Payload ID (payload) to 1 in every output.
     * 
     * @return Specify the payload ID that you want associated with this output. Valid values vary depending on your
     *         Nagra NexGuard forensic watermarking workflow. Required when you include Nagra NexGuard File Marker
     *         watermarking (NexGuardWatermarkingSettings) in your job. For PreRelease Content (NGPR/G2), specify an
     *         integer from 1 through 4,194,303. You must generate a unique ID for each asset you watermark, and keep a
     *         record of which ID you have assigned to each asset. Neither Nagra nor MediaConvert keep track of the
     *         relationship between output files and your IDs. For OTT Streaming, create two adaptive bitrate (ABR)
     *         stacks for each asset. Do this by setting up two output groups. For one output group, set the value of
     *         Payload ID (payload) to 0 in every output. For the other output group, set Payload ID (payload) to 1 in
     *         every output.
     */
    public final Integer payload() {
        return payload;
    }

    /**
     * Enter one of the watermarking preset strings that Nagra provides you. Required when you include Nagra NexGuard
     * File Marker watermarking (NexGuardWatermarkingSettings) in your job.
     * 
     * @return Enter one of the watermarking preset strings that Nagra provides you. Required when you include Nagra
     *         NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
     */
    public final String preset() {
        return preset;
    }

    /**
     * Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't specify a value
     * here, the Nagra NexGuard library uses its default value.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strength} will
     * return {@link WatermarkingStrength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #strengthAsString}.
     * </p>
     * 
     * @return Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't specify
     *         a value here, the Nagra NexGuard library uses its default value.
     * @see WatermarkingStrength
     */
    public final WatermarkingStrength strength() {
        return WatermarkingStrength.fromValue(strength);
    }

    /**
     * Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't specify a value
     * here, the Nagra NexGuard library uses its default value.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strength} will
     * return {@link WatermarkingStrength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #strengthAsString}.
     * </p>
     * 
     * @return Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't specify
     *         a value here, the Nagra NexGuard library uses its default value.
     * @see WatermarkingStrength
     */
    public final String strengthAsString() {
        return strength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(license());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(preset());
        hashCode = 31 * hashCode + Objects.hashCode(strengthAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NexGuardFileMarkerSettings)) {
            return false;
        }
        NexGuardFileMarkerSettings other = (NexGuardFileMarkerSettings) obj;
        return Objects.equals(license(), other.license()) && Objects.equals(payload(), other.payload())
                && Objects.equals(preset(), other.preset()) && Objects.equals(strengthAsString(), other.strengthAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NexGuardFileMarkerSettings").add("License", license()).add("Payload", payload())
                .add("Preset", preset()).add("Strength", strengthAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "License":
            return Optional.ofNullable(clazz.cast(license()));
        case "Payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "Preset":
            return Optional.ofNullable(clazz.cast(preset()));
        case "Strength":
            return Optional.ofNullable(clazz.cast(strengthAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NexGuardFileMarkerSettings, T> g) {
        return obj -> g.apply((NexGuardFileMarkerSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NexGuardFileMarkerSettings> {
        /**
         * Use the base64 license string that Nagra provides you. Enter it directly in your JSON job specification or in
         * the console. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings)
         * in your job.
         * 
         * @param license
         *        Use the base64 license string that Nagra provides you. Enter it directly in your JSON job
         *        specification or in the console. Required when you include Nagra NexGuard File Marker watermarking
         *        (NexGuardWatermarkingSettings) in your job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder license(String license);

        /**
         * Specify the payload ID that you want associated with this output. Valid values vary depending on your Nagra
         * NexGuard forensic watermarking workflow. Required when you include Nagra NexGuard File Marker watermarking
         * (NexGuardWatermarkingSettings) in your job. For PreRelease Content (NGPR/G2), specify an integer from 1
         * through 4,194,303. You must generate a unique ID for each asset you watermark, and keep a record of which ID
         * you have assigned to each asset. Neither Nagra nor MediaConvert keep track of the relationship between output
         * files and your IDs. For OTT Streaming, create two adaptive bitrate (ABR) stacks for each asset. Do this by
         * setting up two output groups. For one output group, set the value of Payload ID (payload) to 0 in every
         * output. For the other output group, set Payload ID (payload) to 1 in every output.
         * 
         * @param payload
         *        Specify the payload ID that you want associated with this output. Valid values vary depending on your
         *        Nagra NexGuard forensic watermarking workflow. Required when you include Nagra NexGuard File Marker
         *        watermarking (NexGuardWatermarkingSettings) in your job. For PreRelease Content (NGPR/G2), specify an
         *        integer from 1 through 4,194,303. You must generate a unique ID for each asset you watermark, and keep
         *        a record of which ID you have assigned to each asset. Neither Nagra nor MediaConvert keep track of the
         *        relationship between output files and your IDs. For OTT Streaming, create two adaptive bitrate (ABR)
         *        stacks for each asset. Do this by setting up two output groups. For one output group, set the value of
         *        Payload ID (payload) to 0 in every output. For the other output group, set Payload ID (payload) to 1
         *        in every output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(Integer payload);

        /**
         * Enter one of the watermarking preset strings that Nagra provides you. Required when you include Nagra
         * NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
         * 
         * @param preset
         *        Enter one of the watermarking preset strings that Nagra provides you. Required when you include Nagra
         *        NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preset(String preset);

        /**
         * Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't specify a
         * value here, the Nagra NexGuard library uses its default value.
         * 
         * @param strength
         *        Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't
         *        specify a value here, the Nagra NexGuard library uses its default value.
         * @see WatermarkingStrength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WatermarkingStrength
         */
        Builder strength(String strength);

        /**
         * Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't specify a
         * value here, the Nagra NexGuard library uses its default value.
         * 
         * @param strength
         *        Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't
         *        specify a value here, the Nagra NexGuard library uses its default value.
         * @see WatermarkingStrength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WatermarkingStrength
         */
        Builder strength(WatermarkingStrength strength);
    }

    static final class BuilderImpl implements Builder {
        private String license;

        private Integer payload;

        private String preset;

        private String strength;

        private BuilderImpl() {
        }

        private BuilderImpl(NexGuardFileMarkerSettings model) {
            license(model.license);
            payload(model.payload);
            preset(model.preset);
            strength(model.strength);
        }

        public final String getLicense() {
            return license;
        }

        public final void setLicense(String license) {
            this.license = license;
        }

        @Override
        @Transient
        public final Builder license(String license) {
            this.license = license;
            return this;
        }

        public final Integer getPayload() {
            return payload;
        }

        public final void setPayload(Integer payload) {
            this.payload = payload;
        }

        @Override
        @Transient
        public final Builder payload(Integer payload) {
            this.payload = payload;
            return this;
        }

        public final String getPreset() {
            return preset;
        }

        public final void setPreset(String preset) {
            this.preset = preset;
        }

        @Override
        @Transient
        public final Builder preset(String preset) {
            this.preset = preset;
            return this;
        }

        public final String getStrength() {
            return strength;
        }

        public final void setStrength(String strength) {
            this.strength = strength;
        }

        @Override
        @Transient
        public final Builder strength(String strength) {
            this.strength = strength;
            return this;
        }

        @Override
        @Transient
        public final Builder strength(WatermarkingStrength strength) {
            this.strength(strength == null ? null : strength.toString());
            return this;
        }

        @Override
        public NexGuardFileMarkerSettings build() {
            return new NexGuardFileMarkerSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
