/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary. Enable or
 * disable this feature for each output individually. This setting is disabled by default. When you enable Noise reducer
 * (NoiseReducer), you must also select a value for Noise reducer filter (NoiseReducerFilter).
 */
@Generated("software.amazon.awssdk:codegen")
public final class NoiseReducer implements SdkPojo, Serializable, ToCopyableBuilder<NoiseReducer.Builder, NoiseReducer> {
    private static final SdkField<String> FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Filter")
            .getter(getter(NoiseReducer::filterAsString)).setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<NoiseReducerFilterSettings> FILTER_SETTINGS_FIELD = SdkField
            .<NoiseReducerFilterSettings> builder(MarshallingType.SDK_POJO).memberName("FilterSettings")
            .getter(getter(NoiseReducer::filterSettings)).setter(setter(Builder::filterSettings))
            .constructor(NoiseReducerFilterSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterSettings").build()).build();

    private static final SdkField<NoiseReducerSpatialFilterSettings> SPATIAL_FILTER_SETTINGS_FIELD = SdkField
            .<NoiseReducerSpatialFilterSettings> builder(MarshallingType.SDK_POJO).memberName("SpatialFilterSettings")
            .getter(getter(NoiseReducer::spatialFilterSettings)).setter(setter(Builder::spatialFilterSettings))
            .constructor(NoiseReducerSpatialFilterSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialFilterSettings").build())
            .build();

    private static final SdkField<NoiseReducerTemporalFilterSettings> TEMPORAL_FILTER_SETTINGS_FIELD = SdkField
            .<NoiseReducerTemporalFilterSettings> builder(MarshallingType.SDK_POJO).memberName("TemporalFilterSettings")
            .getter(getter(NoiseReducer::temporalFilterSettings)).setter(setter(Builder::temporalFilterSettings))
            .constructor(NoiseReducerTemporalFilterSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalFilterSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            FILTER_SETTINGS_FIELD, SPATIAL_FILTER_SETTINGS_FIELD, TEMPORAL_FILTER_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filter;

    private final NoiseReducerFilterSettings filterSettings;

    private final NoiseReducerSpatialFilterSettings spatialFilterSettings;

    private final NoiseReducerTemporalFilterSettings temporalFilterSettings;

    private NoiseReducer(BuilderImpl builder) {
        this.filter = builder.filter;
        this.filterSettings = builder.filterSettings;
        this.spatialFilterSettings = builder.spatialFilterSettings;
        this.temporalFilterSettings = builder.temporalFilterSettings;
    }

    /**
     * Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering functions.
     * To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves edges while
     * reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution filtering. * Conserve
     * does min/max noise reduction. * Spatial does frequency-domain filtering based on JND principles. * Temporal
     * optimizes video quality for complex motion.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filter} will
     * return {@link NoiseReducerFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterAsString}.
     * </p>
     * 
     * @return Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering
     *         functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves
     *         edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution
     *         filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain filtering based on
     *         JND principles. * Temporal optimizes video quality for complex motion.
     * @see NoiseReducerFilter
     */
    public final NoiseReducerFilter filter() {
        return NoiseReducerFilter.fromValue(filter);
    }

    /**
     * Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering functions.
     * To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves edges while
     * reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution filtering. * Conserve
     * does min/max noise reduction. * Spatial does frequency-domain filtering based on JND principles. * Temporal
     * optimizes video quality for complex motion.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filter} will
     * return {@link NoiseReducerFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterAsString}.
     * </p>
     * 
     * @return Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering
     *         functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves
     *         edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution
     *         filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain filtering based on
     *         JND principles. * Temporal optimizes video quality for complex motion.
     * @see NoiseReducerFilter
     */
    public final String filterAsString() {
        return filter;
    }

    /**
     * Settings for a noise reducer filter
     * 
     * @return Settings for a noise reducer filter
     */
    public final NoiseReducerFilterSettings filterSettings() {
        return filterSettings;
    }

    /**
     * Noise reducer filter settings for spatial filter.
     * 
     * @return Noise reducer filter settings for spatial filter.
     */
    public final NoiseReducerSpatialFilterSettings spatialFilterSettings() {
        return spatialFilterSettings;
    }

    /**
     * Noise reducer filter settings for temporal filter.
     * 
     * @return Noise reducer filter settings for temporal filter.
     */
    public final NoiseReducerTemporalFilterSettings temporalFilterSettings() {
        return temporalFilterSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(spatialFilterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(temporalFilterSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NoiseReducer)) {
            return false;
        }
        NoiseReducer other = (NoiseReducer) obj;
        return Objects.equals(filterAsString(), other.filterAsString())
                && Objects.equals(filterSettings(), other.filterSettings())
                && Objects.equals(spatialFilterSettings(), other.spatialFilterSettings())
                && Objects.equals(temporalFilterSettings(), other.temporalFilterSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NoiseReducer").add("Filter", filterAsString()).add("FilterSettings", filterSettings())
                .add("SpatialFilterSettings", spatialFilterSettings()).add("TemporalFilterSettings", temporalFilterSettings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.ofNullable(clazz.cast(filterAsString()));
        case "FilterSettings":
            return Optional.ofNullable(clazz.cast(filterSettings()));
        case "SpatialFilterSettings":
            return Optional.ofNullable(clazz.cast(spatialFilterSettings()));
        case "TemporalFilterSettings":
            return Optional.ofNullable(clazz.cast(temporalFilterSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NoiseReducer, T> g) {
        return obj -> g.apply((NoiseReducer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NoiseReducer> {
        /**
         * Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering
         * functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves
         * edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution
         * filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain filtering based on JND
         * principles. * Temporal optimizes video quality for complex motion.
         * 
         * @param filter
         *        Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering
         *        functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral
         *        preserves edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do
         *        convolution filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain
         *        filtering based on JND principles. * Temporal optimizes video quality for complex motion.
         * @see NoiseReducerFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NoiseReducerFilter
         */
        Builder filter(String filter);

        /**
         * Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering
         * functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves
         * edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution
         * filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain filtering based on JND
         * principles. * Temporal optimizes video quality for complex motion.
         * 
         * @param filter
         *        Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering
         *        functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral
         *        preserves edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do
         *        convolution filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain
         *        filtering based on JND principles. * Temporal optimizes video quality for complex motion.
         * @see NoiseReducerFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NoiseReducerFilter
         */
        Builder filter(NoiseReducerFilter filter);

        /**
         * Settings for a noise reducer filter
         * 
         * @param filterSettings
         *        Settings for a noise reducer filter
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterSettings(NoiseReducerFilterSettings filterSettings);

        /**
         * Settings for a noise reducer filter This is a convenience that creates an instance of the
         * {@link NoiseReducerFilterSettings.Builder} avoiding the need to create one manually via
         * {@link NoiseReducerFilterSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link NoiseReducerFilterSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #filterSettings(NoiseReducerFilterSettings)}.
         * 
         * @param filterSettings
         *        a consumer that will call methods on {@link NoiseReducerFilterSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterSettings(NoiseReducerFilterSettings)
         */
        default Builder filterSettings(Consumer<NoiseReducerFilterSettings.Builder> filterSettings) {
            return filterSettings(NoiseReducerFilterSettings.builder().applyMutation(filterSettings).build());
        }

        /**
         * Noise reducer filter settings for spatial filter.
         * 
         * @param spatialFilterSettings
         *        Noise reducer filter settings for spatial filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spatialFilterSettings(NoiseReducerSpatialFilterSettings spatialFilterSettings);

        /**
         * Noise reducer filter settings for spatial filter. This is a convenience that creates an instance of the
         * {@link NoiseReducerSpatialFilterSettings.Builder} avoiding the need to create one manually via
         * {@link NoiseReducerSpatialFilterSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link NoiseReducerSpatialFilterSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #spatialFilterSettings(NoiseReducerSpatialFilterSettings)}.
         * 
         * @param spatialFilterSettings
         *        a consumer that will call methods on {@link NoiseReducerSpatialFilterSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spatialFilterSettings(NoiseReducerSpatialFilterSettings)
         */
        default Builder spatialFilterSettings(Consumer<NoiseReducerSpatialFilterSettings.Builder> spatialFilterSettings) {
            return spatialFilterSettings(NoiseReducerSpatialFilterSettings.builder().applyMutation(spatialFilterSettings).build());
        }

        /**
         * Noise reducer filter settings for temporal filter.
         * 
         * @param temporalFilterSettings
         *        Noise reducer filter settings for temporal filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temporalFilterSettings(NoiseReducerTemporalFilterSettings temporalFilterSettings);

        /**
         * Noise reducer filter settings for temporal filter. This is a convenience that creates an instance of the
         * {@link NoiseReducerTemporalFilterSettings.Builder} avoiding the need to create one manually via
         * {@link NoiseReducerTemporalFilterSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link NoiseReducerTemporalFilterSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #temporalFilterSettings(NoiseReducerTemporalFilterSettings)}.
         * 
         * @param temporalFilterSettings
         *        a consumer that will call methods on {@link NoiseReducerTemporalFilterSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #temporalFilterSettings(NoiseReducerTemporalFilterSettings)
         */
        default Builder temporalFilterSettings(Consumer<NoiseReducerTemporalFilterSettings.Builder> temporalFilterSettings) {
            return temporalFilterSettings(NoiseReducerTemporalFilterSettings.builder().applyMutation(temporalFilterSettings)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filter;

        private NoiseReducerFilterSettings filterSettings;

        private NoiseReducerSpatialFilterSettings spatialFilterSettings;

        private NoiseReducerTemporalFilterSettings temporalFilterSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(NoiseReducer model) {
            filter(model.filter);
            filterSettings(model.filterSettings);
            spatialFilterSettings(model.spatialFilterSettings);
            temporalFilterSettings(model.temporalFilterSettings);
        }

        public final String getFilter() {
            return filter;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        @Transient
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        @Transient
        public final Builder filter(NoiseReducerFilter filter) {
            this.filter(filter == null ? null : filter.toString());
            return this;
        }

        public final NoiseReducerFilterSettings.Builder getFilterSettings() {
            return filterSettings != null ? filterSettings.toBuilder() : null;
        }

        public final void setFilterSettings(NoiseReducerFilterSettings.BuilderImpl filterSettings) {
            this.filterSettings = filterSettings != null ? filterSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder filterSettings(NoiseReducerFilterSettings filterSettings) {
            this.filterSettings = filterSettings;
            return this;
        }

        public final NoiseReducerSpatialFilterSettings.Builder getSpatialFilterSettings() {
            return spatialFilterSettings != null ? spatialFilterSettings.toBuilder() : null;
        }

        public final void setSpatialFilterSettings(NoiseReducerSpatialFilterSettings.BuilderImpl spatialFilterSettings) {
            this.spatialFilterSettings = spatialFilterSettings != null ? spatialFilterSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder spatialFilterSettings(NoiseReducerSpatialFilterSettings spatialFilterSettings) {
            this.spatialFilterSettings = spatialFilterSettings;
            return this;
        }

        public final NoiseReducerTemporalFilterSettings.Builder getTemporalFilterSettings() {
            return temporalFilterSettings != null ? temporalFilterSettings.toBuilder() : null;
        }

        public final void setTemporalFilterSettings(NoiseReducerTemporalFilterSettings.BuilderImpl temporalFilterSettings) {
            this.temporalFilterSettings = temporalFilterSettings != null ? temporalFilterSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder temporalFilterSettings(NoiseReducerTemporalFilterSettings temporalFilterSettings) {
            this.temporalFilterSettings = temporalFilterSettings;
            return this;
        }

        @Override
        public NoiseReducer build() {
            return new NoiseReducer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
