/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * OutputChannel mapping settings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputChannelMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputChannelMapping.Builder, OutputChannelMapping> {
    private static final SdkField<List<Integer>> INPUT_CHANNELS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("InputChannels")
            .getter(getter(OutputChannelMapping::inputChannels))
            .setter(setter(Builder::inputChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputChannels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> INPUT_CHANNELS_FINE_TUNE_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("InputChannelsFineTune")
            .getter(getter(OutputChannelMapping::inputChannelsFineTune))
            .setter(setter(Builder::inputChannelsFineTune))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputChannelsFineTune").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_CHANNELS_FIELD,
            INPUT_CHANNELS_FINE_TUNE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Integer> inputChannels;

    private final List<Double> inputChannelsFineTune;

    private OutputChannelMapping(BuilderImpl builder) {
        this.inputChannels = builder.inputChannels;
        this.inputChannelsFineTune = builder.inputChannelsFineTune;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputChannels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputChannels() {
        return inputChannels != null && !(inputChannels instanceof SdkAutoConstructList);
    }

    /**
     * Use this setting to specify your remix values when they are integers, such as -10, 0, or 4.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputChannels} method.
     * </p>
     * 
     * @return Use this setting to specify your remix values when they are integers, such as -10, 0, or 4.
     */
    public final List<Integer> inputChannels() {
        return inputChannels;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputChannelsFineTune property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInputChannelsFineTune() {
        return inputChannelsFineTune != null && !(inputChannelsFineTune instanceof SdkAutoConstructList);
    }

    /**
     * Use this setting to specify your remix values when they have a decimal component, such as -10.312, 0.08, or 4.9.
     * MediaConvert rounds your remixing values to the nearest thousandth.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputChannelsFineTune} method.
     * </p>
     * 
     * @return Use this setting to specify your remix values when they have a decimal component, such as -10.312, 0.08,
     *         or 4.9. MediaConvert rounds your remixing values to the nearest thousandth.
     */
    public final List<Double> inputChannelsFineTune() {
        return inputChannelsFineTune;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInputChannels() ? inputChannels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputChannelsFineTune() ? inputChannelsFineTune() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputChannelMapping)) {
            return false;
        }
        OutputChannelMapping other = (OutputChannelMapping) obj;
        return hasInputChannels() == other.hasInputChannels() && Objects.equals(inputChannels(), other.inputChannels())
                && hasInputChannelsFineTune() == other.hasInputChannelsFineTune()
                && Objects.equals(inputChannelsFineTune(), other.inputChannelsFineTune());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputChannelMapping").add("InputChannels", hasInputChannels() ? inputChannels() : null)
                .add("InputChannelsFineTune", hasInputChannelsFineTune() ? inputChannelsFineTune() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputChannels":
            return Optional.ofNullable(clazz.cast(inputChannels()));
        case "InputChannelsFineTune":
            return Optional.ofNullable(clazz.cast(inputChannelsFineTune()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputChannelMapping, T> g) {
        return obj -> g.apply((OutputChannelMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputChannelMapping> {
        /**
         * Use this setting to specify your remix values when they are integers, such as -10, 0, or 4.
         * 
         * @param inputChannels
         *        Use this setting to specify your remix values when they are integers, such as -10, 0, or 4.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputChannels(Collection<Integer> inputChannels);

        /**
         * Use this setting to specify your remix values when they are integers, such as -10, 0, or 4.
         * 
         * @param inputChannels
         *        Use this setting to specify your remix values when they are integers, such as -10, 0, or 4.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputChannels(Integer... inputChannels);

        /**
         * Use this setting to specify your remix values when they have a decimal component, such as -10.312, 0.08, or
         * 4.9. MediaConvert rounds your remixing values to the nearest thousandth.
         * 
         * @param inputChannelsFineTune
         *        Use this setting to specify your remix values when they have a decimal component, such as -10.312,
         *        0.08, or 4.9. MediaConvert rounds your remixing values to the nearest thousandth.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputChannelsFineTune(Collection<Double> inputChannelsFineTune);

        /**
         * Use this setting to specify your remix values when they have a decimal component, such as -10.312, 0.08, or
         * 4.9. MediaConvert rounds your remixing values to the nearest thousandth.
         * 
         * @param inputChannelsFineTune
         *        Use this setting to specify your remix values when they have a decimal component, such as -10.312,
         *        0.08, or 4.9. MediaConvert rounds your remixing values to the nearest thousandth.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputChannelsFineTune(Double... inputChannelsFineTune);
    }

    static final class BuilderImpl implements Builder {
        private List<Integer> inputChannels = DefaultSdkAutoConstructList.getInstance();

        private List<Double> inputChannelsFineTune = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputChannelMapping model) {
            inputChannels(model.inputChannels);
            inputChannelsFineTune(model.inputChannelsFineTune);
        }

        public final Collection<Integer> getInputChannels() {
            if (inputChannels instanceof SdkAutoConstructList) {
                return null;
            }
            return inputChannels;
        }

        public final void setInputChannels(Collection<Integer> inputChannels) {
            this.inputChannels = ___listOf__integerMinNegative60Max6Copier.copy(inputChannels);
        }

        @Override
        @Transient
        public final Builder inputChannels(Collection<Integer> inputChannels) {
            this.inputChannels = ___listOf__integerMinNegative60Max6Copier.copy(inputChannels);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputChannels(Integer... inputChannels) {
            inputChannels(Arrays.asList(inputChannels));
            return this;
        }

        public final Collection<Double> getInputChannelsFineTune() {
            if (inputChannelsFineTune instanceof SdkAutoConstructList) {
                return null;
            }
            return inputChannelsFineTune;
        }

        public final void setInputChannelsFineTune(Collection<Double> inputChannelsFineTune) {
            this.inputChannelsFineTune = ___listOf__doubleMinNegative60Max6Copier.copy(inputChannelsFineTune);
        }

        @Override
        @Transient
        public final Builder inputChannelsFineTune(Collection<Double> inputChannelsFineTune) {
            this.inputChannelsFineTune = ___listOf__doubleMinNegative60Max6Copier.copy(inputChannelsFineTune);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputChannelsFineTune(Double... inputChannelsFineTune) {
            inputChannelsFineTune(Arrays.asList(inputChannelsFineTune));
            return this;
        }

        @Override
        public OutputChannelMapping build() {
            return new OutputChannelMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
