/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Video codec settings, (CodecSettings) under (VideoDescription), contains the group of settings related to video
 * encoding. The settings in this group vary depending on the value that you choose for Video codec (Codec). For each
 * codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings
 * object pairs. * AV1, Av1Settings * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264,
 * H264Settings * H_265, H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings * VP8,
 * Vp8Settings * VP9, Vp9Settings * XAVC, XavcSettings
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoCodecSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoCodecSettings.Builder, VideoCodecSettings> {
    private static final SdkField<Av1Settings> AV1_SETTINGS_FIELD = SdkField.<Av1Settings> builder(MarshallingType.SDK_POJO)
            .memberName("Av1Settings").getter(getter(VideoCodecSettings::av1Settings)).setter(setter(Builder::av1Settings))
            .constructor(Av1Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("av1Settings").build()).build();

    private static final SdkField<AvcIntraSettings> AVC_INTRA_SETTINGS_FIELD = SdkField
            .<AvcIntraSettings> builder(MarshallingType.SDK_POJO).memberName("AvcIntraSettings")
            .getter(getter(VideoCodecSettings::avcIntraSettings)).setter(setter(Builder::avcIntraSettings))
            .constructor(AvcIntraSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("avcIntraSettings").build()).build();

    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Codec")
            .getter(getter(VideoCodecSettings::codecAsString)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()).build();

    private static final SdkField<FrameCaptureSettings> FRAME_CAPTURE_SETTINGS_FIELD = SdkField
            .<FrameCaptureSettings> builder(MarshallingType.SDK_POJO).memberName("FrameCaptureSettings")
            .getter(getter(VideoCodecSettings::frameCaptureSettings)).setter(setter(Builder::frameCaptureSettings))
            .constructor(FrameCaptureSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureSettings").build())
            .build();

    private static final SdkField<H264Settings> H264_SETTINGS_FIELD = SdkField.<H264Settings> builder(MarshallingType.SDK_POJO)
            .memberName("H264Settings").getter(getter(VideoCodecSettings::h264Settings)).setter(setter(Builder::h264Settings))
            .constructor(H264Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h264Settings").build()).build();

    private static final SdkField<H265Settings> H265_SETTINGS_FIELD = SdkField.<H265Settings> builder(MarshallingType.SDK_POJO)
            .memberName("H265Settings").getter(getter(VideoCodecSettings::h265Settings)).setter(setter(Builder::h265Settings))
            .constructor(H265Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h265Settings").build()).build();

    private static final SdkField<Mpeg2Settings> MPEG2_SETTINGS_FIELD = SdkField
            .<Mpeg2Settings> builder(MarshallingType.SDK_POJO).memberName("Mpeg2Settings")
            .getter(getter(VideoCodecSettings::mpeg2Settings)).setter(setter(Builder::mpeg2Settings))
            .constructor(Mpeg2Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpeg2Settings").build()).build();

    private static final SdkField<ProresSettings> PRORES_SETTINGS_FIELD = SdkField
            .<ProresSettings> builder(MarshallingType.SDK_POJO).memberName("ProresSettings")
            .getter(getter(VideoCodecSettings::proresSettings)).setter(setter(Builder::proresSettings))
            .constructor(ProresSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proresSettings").build()).build();

    private static final SdkField<Vc3Settings> VC3_SETTINGS_FIELD = SdkField.<Vc3Settings> builder(MarshallingType.SDK_POJO)
            .memberName("Vc3Settings").getter(getter(VideoCodecSettings::vc3Settings)).setter(setter(Builder::vc3Settings))
            .constructor(Vc3Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vc3Settings").build()).build();

    private static final SdkField<Vp8Settings> VP8_SETTINGS_FIELD = SdkField.<Vp8Settings> builder(MarshallingType.SDK_POJO)
            .memberName("Vp8Settings").getter(getter(VideoCodecSettings::vp8Settings)).setter(setter(Builder::vp8Settings))
            .constructor(Vp8Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vp8Settings").build()).build();

    private static final SdkField<Vp9Settings> VP9_SETTINGS_FIELD = SdkField.<Vp9Settings> builder(MarshallingType.SDK_POJO)
            .memberName("Vp9Settings").getter(getter(VideoCodecSettings::vp9Settings)).setter(setter(Builder::vp9Settings))
            .constructor(Vp9Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vp9Settings").build()).build();

    private static final SdkField<XavcSettings> XAVC_SETTINGS_FIELD = SdkField.<XavcSettings> builder(MarshallingType.SDK_POJO)
            .memberName("XavcSettings").getter(getter(VideoCodecSettings::xavcSettings)).setter(setter(Builder::xavcSettings))
            .constructor(XavcSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavcSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AV1_SETTINGS_FIELD,
            AVC_INTRA_SETTINGS_FIELD, CODEC_FIELD, FRAME_CAPTURE_SETTINGS_FIELD, H264_SETTINGS_FIELD, H265_SETTINGS_FIELD,
            MPEG2_SETTINGS_FIELD, PRORES_SETTINGS_FIELD, VC3_SETTINGS_FIELD, VP8_SETTINGS_FIELD, VP9_SETTINGS_FIELD,
            XAVC_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Av1Settings av1Settings;

    private final AvcIntraSettings avcIntraSettings;

    private final String codec;

    private final FrameCaptureSettings frameCaptureSettings;

    private final H264Settings h264Settings;

    private final H265Settings h265Settings;

    private final Mpeg2Settings mpeg2Settings;

    private final ProresSettings proresSettings;

    private final Vc3Settings vc3Settings;

    private final Vp8Settings vp8Settings;

    private final Vp9Settings vp9Settings;

    private final XavcSettings xavcSettings;

    private VideoCodecSettings(BuilderImpl builder) {
        this.av1Settings = builder.av1Settings;
        this.avcIntraSettings = builder.avcIntraSettings;
        this.codec = builder.codec;
        this.frameCaptureSettings = builder.frameCaptureSettings;
        this.h264Settings = builder.h264Settings;
        this.h265Settings = builder.h265Settings;
        this.mpeg2Settings = builder.mpeg2Settings;
        this.proresSettings = builder.proresSettings;
        this.vc3Settings = builder.vc3Settings;
        this.vp8Settings = builder.vp8Settings;
        this.vp9Settings = builder.vp9Settings;
        this.xavcSettings = builder.xavcSettings;
    }

    /**
     * Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.
     * 
     * @return Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.
     */
    public final Av1Settings av1Settings() {
        return av1Settings;
    }

    /**
     * Required when you choose AVC-Intra for your output video codec. For more information about the AVC-Intra
     * settings, see the relevant specification. For detailed information about SD and HD in AVC-Intra, see
     * https://ieeexplore.ieee.org/document/7290936. For information about 4K/2K in AVC-Intra, see
     * https://pro-av.panasonic.net/en/avc-ultra/AVC-ULTRAoverview.pdf.
     * 
     * @return Required when you choose AVC-Intra for your output video codec. For more information about the AVC-Intra
     *         settings, see the relevant specification. For detailed information about SD and HD in AVC-Intra, see
     *         https://ieeexplore.ieee.org/document/7290936. For information about 4K/2K in AVC-Intra, see
     *         https://pro-av.panasonic.net/en/avc-ultra/AVC-ULTRAoverview.pdf.
     */
    public final AvcIntraSettings avcIntraSettings() {
        return avcIntraSettings;
    }

    /**
     * Specifies the video codec. This must be equal to one of the enum values defined by the object VideoCodec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link VideoCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return Specifies the video codec. This must be equal to one of the enum values defined by the object VideoCodec.
     * @see VideoCodec
     */
    public final VideoCodec codec() {
        return VideoCodec.fromValue(codec);
    }

    /**
     * Specifies the video codec. This must be equal to one of the enum values defined by the object VideoCodec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link VideoCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return Specifies the video codec. This must be equal to one of the enum values defined by the object VideoCodec.
     * @see VideoCodec
     */
    public final String codecAsString() {
        return codec;
    }

    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
     * 
     * @return Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
     */
    public final FrameCaptureSettings frameCaptureSettings() {
        return frameCaptureSettings;
    }

    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
     * 
     * @return Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
     */
    public final H264Settings h264Settings() {
        return h264Settings;
    }

    /**
     * Settings for H265 codec
     * 
     * @return Settings for H265 codec
     */
    public final H265Settings h265Settings() {
        return h265Settings;
    }

    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
     * 
     * @return Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
     */
    public final Mpeg2Settings mpeg2Settings() {
        return mpeg2Settings;
    }

    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
     * 
     * @return Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
     */
    public final ProresSettings proresSettings() {
        return proresSettings;
    }

    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VC3
     * 
     * @return Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VC3
     */
    public final Vc3Settings vc3Settings() {
        return vc3Settings;
    }

    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8.
     * 
     * @return Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8.
     */
    public final Vp8Settings vp8Settings() {
        return vp8Settings;
    }

    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.
     * 
     * @return Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.
     */
    public final Vp9Settings vp9Settings() {
        return vp9Settings;
    }

    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value XAVC.
     * 
     * @return Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value XAVC.
     */
    public final XavcSettings xavcSettings() {
        return xavcSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(av1Settings());
        hashCode = 31 * hashCode + Objects.hashCode(avcIntraSettings());
        hashCode = 31 * hashCode + Objects.hashCode(codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(frameCaptureSettings());
        hashCode = 31 * hashCode + Objects.hashCode(h264Settings());
        hashCode = 31 * hashCode + Objects.hashCode(h265Settings());
        hashCode = 31 * hashCode + Objects.hashCode(mpeg2Settings());
        hashCode = 31 * hashCode + Objects.hashCode(proresSettings());
        hashCode = 31 * hashCode + Objects.hashCode(vc3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(vp8Settings());
        hashCode = 31 * hashCode + Objects.hashCode(vp9Settings());
        hashCode = 31 * hashCode + Objects.hashCode(xavcSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoCodecSettings)) {
            return false;
        }
        VideoCodecSettings other = (VideoCodecSettings) obj;
        return Objects.equals(av1Settings(), other.av1Settings()) && Objects.equals(avcIntraSettings(), other.avcIntraSettings())
                && Objects.equals(codecAsString(), other.codecAsString())
                && Objects.equals(frameCaptureSettings(), other.frameCaptureSettings())
                && Objects.equals(h264Settings(), other.h264Settings()) && Objects.equals(h265Settings(), other.h265Settings())
                && Objects.equals(mpeg2Settings(), other.mpeg2Settings())
                && Objects.equals(proresSettings(), other.proresSettings()) && Objects.equals(vc3Settings(), other.vc3Settings())
                && Objects.equals(vp8Settings(), other.vp8Settings()) && Objects.equals(vp9Settings(), other.vp9Settings())
                && Objects.equals(xavcSettings(), other.xavcSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoCodecSettings").add("Av1Settings", av1Settings())
                .add("AvcIntraSettings", avcIntraSettings()).add("Codec", codecAsString())
                .add("FrameCaptureSettings", frameCaptureSettings()).add("H264Settings", h264Settings())
                .add("H265Settings", h265Settings()).add("Mpeg2Settings", mpeg2Settings())
                .add("ProresSettings", proresSettings()).add("Vc3Settings", vc3Settings()).add("Vp8Settings", vp8Settings())
                .add("Vp9Settings", vp9Settings()).add("XavcSettings", xavcSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Av1Settings":
            return Optional.ofNullable(clazz.cast(av1Settings()));
        case "AvcIntraSettings":
            return Optional.ofNullable(clazz.cast(avcIntraSettings()));
        case "Codec":
            return Optional.ofNullable(clazz.cast(codecAsString()));
        case "FrameCaptureSettings":
            return Optional.ofNullable(clazz.cast(frameCaptureSettings()));
        case "H264Settings":
            return Optional.ofNullable(clazz.cast(h264Settings()));
        case "H265Settings":
            return Optional.ofNullable(clazz.cast(h265Settings()));
        case "Mpeg2Settings":
            return Optional.ofNullable(clazz.cast(mpeg2Settings()));
        case "ProresSettings":
            return Optional.ofNullable(clazz.cast(proresSettings()));
        case "Vc3Settings":
            return Optional.ofNullable(clazz.cast(vc3Settings()));
        case "Vp8Settings":
            return Optional.ofNullable(clazz.cast(vp8Settings()));
        case "Vp9Settings":
            return Optional.ofNullable(clazz.cast(vp9Settings()));
        case "XavcSettings":
            return Optional.ofNullable(clazz.cast(xavcSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoCodecSettings, T> g) {
        return obj -> g.apply((VideoCodecSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoCodecSettings> {
        /**
         * Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.
         * 
         * @param av1Settings
         *        Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder av1Settings(Av1Settings av1Settings);

        /**
         * Required when you set Codec, under VideoDescription>CodecSettings to the value AV1. This is a convenience
         * that creates an instance of the {@link Av1Settings.Builder} avoiding the need to create one manually via
         * {@link Av1Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Av1Settings.Builder#build()} is called immediately and its result
         * is passed to {@link #av1Settings(Av1Settings)}.
         * 
         * @param av1Settings
         *        a consumer that will call methods on {@link Av1Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #av1Settings(Av1Settings)
         */
        default Builder av1Settings(Consumer<Av1Settings.Builder> av1Settings) {
            return av1Settings(Av1Settings.builder().applyMutation(av1Settings).build());
        }

        /**
         * Required when you choose AVC-Intra for your output video codec. For more information about the AVC-Intra
         * settings, see the relevant specification. For detailed information about SD and HD in AVC-Intra, see
         * https://ieeexplore.ieee.org/document/7290936. For information about 4K/2K in AVC-Intra, see
         * https://pro-av.panasonic.net/en/avc-ultra/AVC-ULTRAoverview.pdf.
         * 
         * @param avcIntraSettings
         *        Required when you choose AVC-Intra for your output video codec. For more information about the
         *        AVC-Intra settings, see the relevant specification. For detailed information about SD and HD in
         *        AVC-Intra, see https://ieeexplore.ieee.org/document/7290936. For information about 4K/2K in AVC-Intra,
         *        see https://pro-av.panasonic.net/en/avc-ultra/AVC-ULTRAoverview.pdf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avcIntraSettings(AvcIntraSettings avcIntraSettings);

        /**
         * Required when you choose AVC-Intra for your output video codec. For more information about the AVC-Intra
         * settings, see the relevant specification. For detailed information about SD and HD in AVC-Intra, see
         * https://ieeexplore.ieee.org/document/7290936. For information about 4K/2K in AVC-Intra, see
         * https://pro-av.panasonic.net/en/avc-ultra/AVC-ULTRAoverview.pdf. This is a convenience that creates an
         * instance of the {@link AvcIntraSettings.Builder} avoiding the need to create one manually via
         * {@link AvcIntraSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AvcIntraSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #avcIntraSettings(AvcIntraSettings)}.
         * 
         * @param avcIntraSettings
         *        a consumer that will call methods on {@link AvcIntraSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #avcIntraSettings(AvcIntraSettings)
         */
        default Builder avcIntraSettings(Consumer<AvcIntraSettings.Builder> avcIntraSettings) {
            return avcIntraSettings(AvcIntraSettings.builder().applyMutation(avcIntraSettings).build());
        }

        /**
         * Specifies the video codec. This must be equal to one of the enum values defined by the object VideoCodec.
         * 
         * @param codec
         *        Specifies the video codec. This must be equal to one of the enum values defined by the object
         *        VideoCodec.
         * @see VideoCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoCodec
         */
        Builder codec(String codec);

        /**
         * Specifies the video codec. This must be equal to one of the enum values defined by the object VideoCodec.
         * 
         * @param codec
         *        Specifies the video codec. This must be equal to one of the enum values defined by the object
         *        VideoCodec.
         * @see VideoCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoCodec
         */
        Builder codec(VideoCodec codec);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
         * 
         * @param frameCaptureSettings
         *        Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameCaptureSettings(FrameCaptureSettings frameCaptureSettings);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE. This is a
         * convenience that creates an instance of the {@link FrameCaptureSettings.Builder} avoiding the need to create
         * one manually via {@link FrameCaptureSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link FrameCaptureSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #frameCaptureSettings(FrameCaptureSettings)}.
         * 
         * @param frameCaptureSettings
         *        a consumer that will call methods on {@link FrameCaptureSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameCaptureSettings(FrameCaptureSettings)
         */
        default Builder frameCaptureSettings(Consumer<FrameCaptureSettings.Builder> frameCaptureSettings) {
            return frameCaptureSettings(FrameCaptureSettings.builder().applyMutation(frameCaptureSettings).build());
        }

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
         * 
         * @param h264Settings
         *        Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder h264Settings(H264Settings h264Settings);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264. This is a
         * convenience that creates an instance of the {@link H264Settings.Builder} avoiding the need to create one
         * manually via {@link H264Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link H264Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #h264Settings(H264Settings)}.
         * 
         * @param h264Settings
         *        a consumer that will call methods on {@link H264Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #h264Settings(H264Settings)
         */
        default Builder h264Settings(Consumer<H264Settings.Builder> h264Settings) {
            return h264Settings(H264Settings.builder().applyMutation(h264Settings).build());
        }

        /**
         * Settings for H265 codec
         * 
         * @param h265Settings
         *        Settings for H265 codec
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder h265Settings(H265Settings h265Settings);

        /**
         * Settings for H265 codec This is a convenience that creates an instance of the {@link H265Settings.Builder}
         * avoiding the need to create one manually via {@link H265Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link H265Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #h265Settings(H265Settings)}.
         * 
         * @param h265Settings
         *        a consumer that will call methods on {@link H265Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #h265Settings(H265Settings)
         */
        default Builder h265Settings(Consumer<H265Settings.Builder> h265Settings) {
            return h265Settings(H265Settings.builder().applyMutation(h265Settings).build());
        }

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
         * 
         * @param mpeg2Settings
         *        Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mpeg2Settings(Mpeg2Settings mpeg2Settings);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2. This is a
         * convenience that creates an instance of the {@link Mpeg2Settings.Builder} avoiding the need to create one
         * manually via {@link Mpeg2Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Mpeg2Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #mpeg2Settings(Mpeg2Settings)}.
         * 
         * @param mpeg2Settings
         *        a consumer that will call methods on {@link Mpeg2Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mpeg2Settings(Mpeg2Settings)
         */
        default Builder mpeg2Settings(Consumer<Mpeg2Settings.Builder> mpeg2Settings) {
            return mpeg2Settings(Mpeg2Settings.builder().applyMutation(mpeg2Settings).build());
        }

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
         * 
         * @param proresSettings
         *        Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proresSettings(ProresSettings proresSettings);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES. This is a
         * convenience that creates an instance of the {@link ProresSettings.Builder} avoiding the need to create one
         * manually via {@link ProresSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProresSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #proresSettings(ProresSettings)}.
         * 
         * @param proresSettings
         *        a consumer that will call methods on {@link ProresSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proresSettings(ProresSettings)
         */
        default Builder proresSettings(Consumer<ProresSettings.Builder> proresSettings) {
            return proresSettings(ProresSettings.builder().applyMutation(proresSettings).build());
        }

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VC3
         * 
         * @param vc3Settings
         *        Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VC3
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vc3Settings(Vc3Settings vc3Settings);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VC3 This is a convenience
         * that creates an instance of the {@link Vc3Settings.Builder} avoiding the need to create one manually via
         * {@link Vc3Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Vc3Settings.Builder#build()} is called immediately and its result
         * is passed to {@link #vc3Settings(Vc3Settings)}.
         * 
         * @param vc3Settings
         *        a consumer that will call methods on {@link Vc3Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vc3Settings(Vc3Settings)
         */
        default Builder vc3Settings(Consumer<Vc3Settings.Builder> vc3Settings) {
            return vc3Settings(Vc3Settings.builder().applyMutation(vc3Settings).build());
        }

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8.
         * 
         * @param vp8Settings
         *        Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vp8Settings(Vp8Settings vp8Settings);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8. This is a
         * convenience that creates an instance of the {@link Vp8Settings.Builder} avoiding the need to create one
         * manually via {@link Vp8Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Vp8Settings.Builder#build()} is called immediately and its result
         * is passed to {@link #vp8Settings(Vp8Settings)}.
         * 
         * @param vp8Settings
         *        a consumer that will call methods on {@link Vp8Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vp8Settings(Vp8Settings)
         */
        default Builder vp8Settings(Consumer<Vp8Settings.Builder> vp8Settings) {
            return vp8Settings(Vp8Settings.builder().applyMutation(vp8Settings).build());
        }

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.
         * 
         * @param vp9Settings
         *        Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vp9Settings(Vp9Settings vp9Settings);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9. This is a
         * convenience that creates an instance of the {@link Vp9Settings.Builder} avoiding the need to create one
         * manually via {@link Vp9Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Vp9Settings.Builder#build()} is called immediately and its result
         * is passed to {@link #vp9Settings(Vp9Settings)}.
         * 
         * @param vp9Settings
         *        a consumer that will call methods on {@link Vp9Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vp9Settings(Vp9Settings)
         */
        default Builder vp9Settings(Consumer<Vp9Settings.Builder> vp9Settings) {
            return vp9Settings(Vp9Settings.builder().applyMutation(vp9Settings).build());
        }

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value XAVC.
         * 
         * @param xavcSettings
         *        Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value XAVC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xavcSettings(XavcSettings xavcSettings);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value XAVC. This is a
         * convenience that creates an instance of the {@link XavcSettings.Builder} avoiding the need to create one
         * manually via {@link XavcSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link XavcSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #xavcSettings(XavcSettings)}.
         * 
         * @param xavcSettings
         *        a consumer that will call methods on {@link XavcSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xavcSettings(XavcSettings)
         */
        default Builder xavcSettings(Consumer<XavcSettings.Builder> xavcSettings) {
            return xavcSettings(XavcSettings.builder().applyMutation(xavcSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Av1Settings av1Settings;

        private AvcIntraSettings avcIntraSettings;

        private String codec;

        private FrameCaptureSettings frameCaptureSettings;

        private H264Settings h264Settings;

        private H265Settings h265Settings;

        private Mpeg2Settings mpeg2Settings;

        private ProresSettings proresSettings;

        private Vc3Settings vc3Settings;

        private Vp8Settings vp8Settings;

        private Vp9Settings vp9Settings;

        private XavcSettings xavcSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoCodecSettings model) {
            av1Settings(model.av1Settings);
            avcIntraSettings(model.avcIntraSettings);
            codec(model.codec);
            frameCaptureSettings(model.frameCaptureSettings);
            h264Settings(model.h264Settings);
            h265Settings(model.h265Settings);
            mpeg2Settings(model.mpeg2Settings);
            proresSettings(model.proresSettings);
            vc3Settings(model.vc3Settings);
            vp8Settings(model.vp8Settings);
            vp9Settings(model.vp9Settings);
            xavcSettings(model.xavcSettings);
        }

        public final Av1Settings.Builder getAv1Settings() {
            return av1Settings != null ? av1Settings.toBuilder() : null;
        }

        public final void setAv1Settings(Av1Settings.BuilderImpl av1Settings) {
            this.av1Settings = av1Settings != null ? av1Settings.build() : null;
        }

        @Override
        @Transient
        public final Builder av1Settings(Av1Settings av1Settings) {
            this.av1Settings = av1Settings;
            return this;
        }

        public final AvcIntraSettings.Builder getAvcIntraSettings() {
            return avcIntraSettings != null ? avcIntraSettings.toBuilder() : null;
        }

        public final void setAvcIntraSettings(AvcIntraSettings.BuilderImpl avcIntraSettings) {
            this.avcIntraSettings = avcIntraSettings != null ? avcIntraSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder avcIntraSettings(AvcIntraSettings avcIntraSettings) {
            this.avcIntraSettings = avcIntraSettings;
            return this;
        }

        public final String getCodec() {
            return codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        @Transient
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        @Transient
        public final Builder codec(VideoCodec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final FrameCaptureSettings.Builder getFrameCaptureSettings() {
            return frameCaptureSettings != null ? frameCaptureSettings.toBuilder() : null;
        }

        public final void setFrameCaptureSettings(FrameCaptureSettings.BuilderImpl frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings != null ? frameCaptureSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder frameCaptureSettings(FrameCaptureSettings frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings;
            return this;
        }

        public final H264Settings.Builder getH264Settings() {
            return h264Settings != null ? h264Settings.toBuilder() : null;
        }

        public final void setH264Settings(H264Settings.BuilderImpl h264Settings) {
            this.h264Settings = h264Settings != null ? h264Settings.build() : null;
        }

        @Override
        @Transient
        public final Builder h264Settings(H264Settings h264Settings) {
            this.h264Settings = h264Settings;
            return this;
        }

        public final H265Settings.Builder getH265Settings() {
            return h265Settings != null ? h265Settings.toBuilder() : null;
        }

        public final void setH265Settings(H265Settings.BuilderImpl h265Settings) {
            this.h265Settings = h265Settings != null ? h265Settings.build() : null;
        }

        @Override
        @Transient
        public final Builder h265Settings(H265Settings h265Settings) {
            this.h265Settings = h265Settings;
            return this;
        }

        public final Mpeg2Settings.Builder getMpeg2Settings() {
            return mpeg2Settings != null ? mpeg2Settings.toBuilder() : null;
        }

        public final void setMpeg2Settings(Mpeg2Settings.BuilderImpl mpeg2Settings) {
            this.mpeg2Settings = mpeg2Settings != null ? mpeg2Settings.build() : null;
        }

        @Override
        @Transient
        public final Builder mpeg2Settings(Mpeg2Settings mpeg2Settings) {
            this.mpeg2Settings = mpeg2Settings;
            return this;
        }

        public final ProresSettings.Builder getProresSettings() {
            return proresSettings != null ? proresSettings.toBuilder() : null;
        }

        public final void setProresSettings(ProresSettings.BuilderImpl proresSettings) {
            this.proresSettings = proresSettings != null ? proresSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder proresSettings(ProresSettings proresSettings) {
            this.proresSettings = proresSettings;
            return this;
        }

        public final Vc3Settings.Builder getVc3Settings() {
            return vc3Settings != null ? vc3Settings.toBuilder() : null;
        }

        public final void setVc3Settings(Vc3Settings.BuilderImpl vc3Settings) {
            this.vc3Settings = vc3Settings != null ? vc3Settings.build() : null;
        }

        @Override
        @Transient
        public final Builder vc3Settings(Vc3Settings vc3Settings) {
            this.vc3Settings = vc3Settings;
            return this;
        }

        public final Vp8Settings.Builder getVp8Settings() {
            return vp8Settings != null ? vp8Settings.toBuilder() : null;
        }

        public final void setVp8Settings(Vp8Settings.BuilderImpl vp8Settings) {
            this.vp8Settings = vp8Settings != null ? vp8Settings.build() : null;
        }

        @Override
        @Transient
        public final Builder vp8Settings(Vp8Settings vp8Settings) {
            this.vp8Settings = vp8Settings;
            return this;
        }

        public final Vp9Settings.Builder getVp9Settings() {
            return vp9Settings != null ? vp9Settings.toBuilder() : null;
        }

        public final void setVp9Settings(Vp9Settings.BuilderImpl vp9Settings) {
            this.vp9Settings = vp9Settings != null ? vp9Settings.build() : null;
        }

        @Override
        @Transient
        public final Builder vp9Settings(Vp9Settings vp9Settings) {
            this.vp9Settings = vp9Settings;
            return this;
        }

        public final XavcSettings.Builder getXavcSettings() {
            return xavcSettings != null ? xavcSettings.toBuilder() : null;
        }

        public final void setXavcSettings(XavcSettings.BuilderImpl xavcSettings) {
            this.xavcSettings = xavcSettings != null ? xavcSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder xavcSettings(XavcSettings xavcSettings) {
            this.xavcSettings = xavcSettings;
            return this;
        }

        @Override
        public VideoCodecSettings build() {
            return new VideoCodecSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
