/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AudioSelectorType {
    PID("PID"),
    TRACK("TRACK"),
    LANGUAGE_CODE("LANGUAGE_CODE"),
    HLS_RENDITION_GROUP("HLS_RENDITION_GROUP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AudioSelectorType> VALUE_MAP;
    private final String value;

    private AudioSelectorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AudioSelectorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AudioSelectorType> knownValues() {
        EnumSet<AudioSelectorType> knownValues = EnumSet.allOf(AudioSelectorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AudioSelectorType.class, AudioSelectorType::toString);
    }
}

