/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Vp9Settings implements SdkPojo, Serializable, ToCopyableBuilder<Vp9Settings.Builder, Vp9Settings> {
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Bitrate").getter(getter(Vp9Settings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FramerateControl").getter(getter(Vp9Settings::framerateControlAsString))
            .setter(setter(Builder::framerateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()).build();

    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FramerateConversionAlgorithm")
            .getter(getter(Vp9Settings::framerateConversionAlgorithmAsString))
            .setter(setter(Builder::framerateConversionAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm")
                    .build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(Vp9Settings::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(Vp9Settings::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("GopSize").getter(getter(Vp9Settings::gopSize)).setter(setter(Builder::gopSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()).build();

    private static final SdkField<Integer> HRD_BUFFER_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HrdBufferSize").getter(getter(Vp9Settings::hrdBufferSize)).setter(setter(Builder::hrdBufferSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferSize").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(Vp9Settings::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<String> PAR_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParControl").getter(getter(Vp9Settings::parControlAsString)).setter(setter(Builder::parControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parControl").build()).build();

    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParDenominator").getter(getter(Vp9Settings::parDenominator)).setter(setter(Builder::parDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()).build();

    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParNumerator").getter(getter(Vp9Settings::parNumerator)).setter(setter(Builder::parNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()).build();

    private static final SdkField<String> QUALITY_TUNING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualityTuningLevel").getter(getter(Vp9Settings::qualityTuningLevelAsString))
            .setter(setter(Builder::qualityTuningLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityTuningLevel").build())
            .build();

    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RateControlMode").getter(getter(Vp9Settings::rateControlModeAsString))
            .setter(setter(Builder::rateControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD,
            FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD,
            FRAMERATE_NUMERATOR_FIELD, GOP_SIZE_FIELD, HRD_BUFFER_SIZE_FIELD, MAX_BITRATE_FIELD, PAR_CONTROL_FIELD,
            PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, QUALITY_TUNING_LEVEL_FIELD, RATE_CONTROL_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer bitrate;

    private final String framerateControl;

    private final String framerateConversionAlgorithm;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final Double gopSize;

    private final Integer hrdBufferSize;

    private final Integer maxBitrate;

    private final String parControl;

    private final Integer parDenominator;

    private final Integer parNumerator;

    private final String qualityTuningLevel;

    private final String rateControlMode;

    private Vp9Settings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopSize = builder.gopSize;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.maxBitrate = builder.maxBitrate;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.rateControlMode = builder.rateControlMode;
    }

    /**
     * Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
     * 
     * @return Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
     */
    public final Integer bitrate() {
        return bitrate;
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link Vp9FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see Vp9FramerateControl
     */
    public final Vp9FramerateControl framerateControl() {
        return Vp9FramerateControl.fromValue(framerateControl);
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link Vp9FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see Vp9FramerateControl
     */
    public final String framerateControlAsString() {
        return framerateControl;
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend
     * using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For
     * numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth
     * picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your
     * source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do
     * motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using
     * FrameFormer increases the transcoding time and incurs a significant add-on cost.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link Vp9FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
     *         recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30
     *         fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This
     *         results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
     *         conversions, especially if your source video has already been converted from its original cadence, use
     *         FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion
     *         method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a
     *         significant add-on cost.
     * @see Vp9FramerateConversionAlgorithm
     */
    public final Vp9FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return Vp9FramerateConversionAlgorithm.fromValue(framerateConversionAlgorithm);
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend
     * using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For
     * numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth
     * picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your
     * source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do
     * motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using
     * FrameFormer increases the transcoding time and incurs a significant add-on cost.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link Vp9FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
     *         recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30
     *         fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This
     *         results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
     *         conversions, especially if your source video has already been converted from its original cadence, use
     *         FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion
     *         method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a
     *         significant add-on cost.
     * @see Vp9FramerateConversionAlgorithm
     */
    public final String framerateConversionAlgorithmAsString() {
        return framerateConversionAlgorithm;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this
     * example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of
     *         this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console
     *         for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate.
     *         In this example, specify 23.976.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this
     * example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this
     *         fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for
     *         transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In
     *         this example, specify 23.976.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * GOP Length (keyframe interval) in frames. Must be greater than zero.
     * 
     * @return GOP Length (keyframe interval) in frames. Must be greater than zero.
     */
    public final Double gopSize() {
        return gopSize;
    }

    /**
     * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     * 
     * @return Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     */
    public final Integer hrdBufferSize() {
        return hrdBufferSize;
    }

    /**
     * Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in
     * bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the target
     * bitrate as the maximum bitrate.
     * 
     * @return Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum
     *         bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior uses
     *         twice the target bitrate as the maximum bitrate.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * Optional. Specify how the service determines the pixel aspect ratio for this output. The default behavior is to
     * use the same pixel aspect ratio as your input video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link Vp9ParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return Optional. Specify how the service determines the pixel aspect ratio for this output. The default behavior
     *         is to use the same pixel aspect ratio as your input video.
     * @see Vp9ParControl
     */
    public final Vp9ParControl parControl() {
        return Vp9ParControl.fromValue(parControl);
    }

    /**
     * Optional. Specify how the service determines the pixel aspect ratio for this output. The default behavior is to
     * use the same pixel aspect ratio as your input video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link Vp9ParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return Optional. Specify how the service determines the pixel aspect ratio for this output. The default behavior
     *         is to use the same pixel aspect ratio as your input video.
     * @see Vp9ParControl
     */
    public final String parControlAsString() {
        return parControl;
    }

    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value
     * other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input
     * video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the
     * ratio 40:33. In this example, the value for parDenominator is 33.
     * 
     * @return Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to
     *         any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different
     *         from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen,
     *         you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
     */
    public final Integer parDenominator() {
        return parDenominator;
    }

    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value
     * other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input
     * video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the
     * ratio 40:33. In this example, the value for parNumerator is 40.
     * 
     * @return Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to
     *         any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different
     *         from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen,
     *         you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
     */
    public final Integer parNumerator() {
        return parNumerator;
    }

    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for
     * output video quality. The default behavior is faster, lower quality, multi-pass encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link Vp9QualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
     *         speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
     * @see Vp9QualityTuningLevel
     */
    public final Vp9QualityTuningLevel qualityTuningLevel() {
        return Vp9QualityTuningLevel.fromValue(qualityTuningLevel);
    }

    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for
     * output video quality. The default behavior is faster, lower quality, multi-pass encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link Vp9QualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
     *         speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
     * @see Vp9QualityTuningLevel
     */
    public final String qualityTuningLevelAsString() {
        return qualityTuningLevel;
    }

    /**
     * With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link Vp9RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
     * @see Vp9RateControlMode
     */
    public final Vp9RateControlMode rateControlMode() {
        return Vp9RateControlMode.fromValue(rateControlMode);
    }

    /**
     * With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link Vp9RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
     * @see Vp9RateControlMode
     */
    public final String rateControlModeAsString() {
        return rateControlMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rateControlModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vp9Settings)) {
            return false;
        }
        Vp9Settings other = (Vp9Settings) obj;
        return Objects.equals(bitrate(), other.bitrate())
                && Objects.equals(framerateControlAsString(), other.framerateControlAsString())
                && Objects.equals(framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator()) && Objects.equals(gopSize(), other.gopSize())
                && Objects.equals(hrdBufferSize(), other.hrdBufferSize()) && Objects.equals(maxBitrate(), other.maxBitrate())
                && Objects.equals(parControlAsString(), other.parControlAsString())
                && Objects.equals(parDenominator(), other.parDenominator())
                && Objects.equals(parNumerator(), other.parNumerator())
                && Objects.equals(qualityTuningLevelAsString(), other.qualityTuningLevelAsString())
                && Objects.equals(rateControlModeAsString(), other.rateControlModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Vp9Settings").add("Bitrate", bitrate()).add("FramerateControl", framerateControlAsString())
                .add("FramerateConversionAlgorithm", framerateConversionAlgorithmAsString())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("GopSize", gopSize()).add("HrdBufferSize", hrdBufferSize()).add("MaxBitrate", maxBitrate())
                .add("ParControl", parControlAsString()).add("ParDenominator", parDenominator())
                .add("ParNumerator", parNumerator()).add("QualityTuningLevel", qualityTuningLevelAsString())
                .add("RateControlMode", rateControlModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "FramerateControl":
            return Optional.ofNullable(clazz.cast(framerateControlAsString()));
        case "FramerateConversionAlgorithm":
            return Optional.ofNullable(clazz.cast(framerateConversionAlgorithmAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "GopSize":
            return Optional.ofNullable(clazz.cast(gopSize()));
        case "HrdBufferSize":
            return Optional.ofNullable(clazz.cast(hrdBufferSize()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "ParControl":
            return Optional.ofNullable(clazz.cast(parControlAsString()));
        case "ParDenominator":
            return Optional.ofNullable(clazz.cast(parDenominator()));
        case "ParNumerator":
            return Optional.ofNullable(clazz.cast(parNumerator()));
        case "QualityTuningLevel":
            return Optional.ofNullable(clazz.cast(qualityTuningLevelAsString()));
        case "RateControlMode":
            return Optional.ofNullable(clazz.cast(rateControlModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Vp9Settings, T> g) {
        return obj -> g.apply((Vp9Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Vp9Settings> {
        /**
         * Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
         * 
         * @param bitrate
         *        Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see Vp9FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vp9FramerateControl
         */
        Builder framerateControl(String framerateControl);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see Vp9FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vp9FramerateControl
         */
        Builder framerateControl(Vp9FramerateControl framerateControl);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         * recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps.
         * For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in
         * a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence, use FrameFormer
         * (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by
         * frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         *        recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
         *        30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter.
         *        This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame
         *        rate conversions, especially if your source video has already been converted from its original
         *        cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the
         *        best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and
         *        incurs a significant add-on cost.
         * @see Vp9FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vp9FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(String framerateConversionAlgorithm);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         * recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps.
         * For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in
         * a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence, use FrameFormer
         * (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by
         * frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         *        recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
         *        30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter.
         *        This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame
         *        rate conversions, especially if your source video has already been converted from its original
         *        cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the
         *        best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and
         *        incurs a significant add-on cost.
         * @see Vp9FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vp9FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(Vp9FramerateConversionAlgorithm framerateConversionAlgorithm);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction.
         * In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs
         * that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateDenominator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator
         *        of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In
         * this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that
         * use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateNumerator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of
         *        this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * GOP Length (keyframe interval) in frames. Must be greater than zero.
         * 
         * @param gopSize
         *        GOP Length (keyframe interval) in frames. Must be greater than zero.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopSize(Double gopSize);

        /**
         * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         * 
         * @param hrdBufferSize
         *        Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hrdBufferSize(Integer hrdBufferSize);

        /**
         * Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in
         * bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the
         * target bitrate as the maximum bitrate.
         * 
         * @param maxBitrate
         *        Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum
         *        bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior
         *        uses twice the target bitrate as the maximum bitrate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * Optional. Specify how the service determines the pixel aspect ratio for this output. The default behavior is
         * to use the same pixel aspect ratio as your input video.
         * 
         * @param parControl
         *        Optional. Specify how the service determines the pixel aspect ratio for this output. The default
         *        behavior is to use the same pixel aspect ratio as your input video.
         * @see Vp9ParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vp9ParControl
         */
        Builder parControl(String parControl);

        /**
         * Optional. Specify how the service determines the pixel aspect ratio for this output. The default behavior is
         * to use the same pixel aspect ratio as your input video.
         * 
         * @param parControl
         *        Optional. Specify how the service determines the pixel aspect ratio for this output. The default
         *        behavior is to use the same pixel aspect ratio as your input video.
         * @see Vp9ParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vp9ParControl
         */
        Builder parControl(Vp9ParControl parControl);

        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any
         * value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from
         * your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would
         * specify the ratio 40:33. In this example, the value for parDenominator is 33.
         * 
         * @param parDenominator
         *        Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds
         *        to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is
         *        different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC
         *        widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parDenominator(Integer parDenominator);

        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any
         * value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from
         * your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would
         * specify the ratio 40:33. In this example, the value for parNumerator is 40.
         * 
         * @param parNumerator
         *        Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds
         *        to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is
         *        different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC
         *        widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parNumerator(Integer parNumerator);

        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed
         * for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
         * 
         * @param qualityTuningLevel
         *        Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
         *        speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
         * @see Vp9QualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vp9QualityTuningLevel
         */
        Builder qualityTuningLevel(String qualityTuningLevel);

        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed
         * for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
         * 
         * @param qualityTuningLevel
         *        Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
         *        speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
         * @see Vp9QualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vp9QualityTuningLevel
         */
        Builder qualityTuningLevel(Vp9QualityTuningLevel qualityTuningLevel);

        /**
         * With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
         * 
         * @param rateControlMode
         *        With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
         * @see Vp9RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vp9RateControlMode
         */
        Builder rateControlMode(String rateControlMode);

        /**
         * With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
         * 
         * @param rateControlMode
         *        With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
         * @see Vp9RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Vp9RateControlMode
         */
        Builder rateControlMode(Vp9RateControlMode rateControlMode);
    }

    static final class BuilderImpl implements Builder {
        private Integer bitrate;

        private String framerateControl;

        private String framerateConversionAlgorithm;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private Double gopSize;

        private Integer hrdBufferSize;

        private Integer maxBitrate;

        private String parControl;

        private Integer parDenominator;

        private Integer parNumerator;

        private String qualityTuningLevel;

        private String rateControlMode;

        private BuilderImpl() {
        }

        private BuilderImpl(Vp9Settings model) {
            bitrate(model.bitrate);
            framerateControl(model.framerateControl);
            framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            gopSize(model.gopSize);
            hrdBufferSize(model.hrdBufferSize);
            maxBitrate(model.maxBitrate);
            parControl(model.parControl);
            parDenominator(model.parDenominator);
            parNumerator(model.parNumerator);
            qualityTuningLevel(model.qualityTuningLevel);
            rateControlMode(model.rateControlMode);
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getFramerateControl() {
            return framerateControl;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(Vp9FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final String getFramerateConversionAlgorithm() {
            return framerateConversionAlgorithm;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(Vp9FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm
                    .toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final Double getGopSize() {
            return gopSize;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final Integer getHrdBufferSize() {
            return hrdBufferSize;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final String getParControl() {
            return parControl;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(Vp9ParControl parControl) {
            this.parControl(parControl == null ? null : parControl.toString());
            return this;
        }

        public final Integer getParDenominator() {
            return parDenominator;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final Integer getParNumerator() {
            return parNumerator;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final String getQualityTuningLevel() {
            return qualityTuningLevel;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(Vp9QualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel == null ? null : qualityTuningLevel.toString());
            return this;
        }

        public final String getRateControlMode() {
            return rateControlMode;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(Vp9RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        @Override
        public Vp9Settings build() {
            return new Vp9Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
