/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specify YUV limits and RGB tolerances when you set Sample range conversion to Limited range clip.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClipLimits implements SdkPojo, Serializable, ToCopyableBuilder<ClipLimits.Builder, ClipLimits> {
    private static final SdkField<Integer> MAXIMUM_RGB_TOLERANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumRGBTolerance").getter(getter(ClipLimits::maximumRGBTolerance))
            .setter(setter(Builder::maximumRGBTolerance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumRGBTolerance").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_YUV_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumYUV").getter(getter(ClipLimits::maximumYUV)).setter(setter(Builder::maximumYUV))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumYUV").build()).build();

    private static final SdkField<Integer> MINIMUM_RGB_TOLERANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumRGBTolerance").getter(getter(ClipLimits::minimumRGBTolerance))
            .setter(setter(Builder::minimumRGBTolerance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumRGBTolerance").build())
            .build();

    private static final SdkField<Integer> MINIMUM_YUV_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumYUV").getter(getter(ClipLimits::minimumYUV)).setter(setter(Builder::minimumYUV))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumYUV").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_RGB_TOLERANCE_FIELD,
            MAXIMUM_YUV_FIELD, MINIMUM_RGB_TOLERANCE_FIELD, MINIMUM_YUV_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maximumRGBTolerance;

    private final Integer maximumYUV;

    private final Integer minimumRGBTolerance;

    private final Integer minimumYUV;

    private ClipLimits(BuilderImpl builder) {
        this.maximumRGBTolerance = builder.maximumRGBTolerance;
        this.maximumYUV = builder.maximumYUV;
        this.minimumRGBTolerance = builder.minimumRGBTolerance;
        this.minimumYUV = builder.minimumYUV;
    }

    /**
     * Specify the Maximum RGB color sample range tolerance for your output. MediaConvert corrects any YUV values that,
     * when converted to RGB, would be outside the upper tolerance that you specify. Enter an integer from 90 to 105 as
     * an offset percentage to the maximum possible value. Leave blank to use the default value 100. When you specify a
     * value for Maximum RGB tolerance, you must set Sample range conversion to Limited range clip.
     * 
     * @return Specify the Maximum RGB color sample range tolerance for your output. MediaConvert corrects any YUV
     *         values that, when converted to RGB, would be outside the upper tolerance that you specify. Enter an
     *         integer from 90 to 105 as an offset percentage to the maximum possible value. Leave blank to use the
     *         default value 100. When you specify a value for Maximum RGB tolerance, you must set Sample range
     *         conversion to Limited range clip.
     */
    public final Integer maximumRGBTolerance() {
        return maximumRGBTolerance;
    }

    /**
     * Specify the Maximum YUV color sample limit. MediaConvert conforms any pixels in your input above the value that
     * you specify to typical limited range bounds. Enter an integer from 920 to 1023. Leave blank to use the default
     * value 940. The value that you enter applies to 10-bit ranges. For 8-bit ranges, MediaConvert automatically scales
     * this value down. When you specify a value for Maximum YUV, you must set Sample range conversion to Limited range
     * clip.
     * 
     * @return Specify the Maximum YUV color sample limit. MediaConvert conforms any pixels in your input above the
     *         value that you specify to typical limited range bounds. Enter an integer from 920 to 1023. Leave blank to
     *         use the default value 940. The value that you enter applies to 10-bit ranges. For 8-bit ranges,
     *         MediaConvert automatically scales this value down. When you specify a value for Maximum YUV, you must set
     *         Sample range conversion to Limited range clip.
     */
    public final Integer maximumYUV() {
        return maximumYUV;
    }

    /**
     * Specify the Minimum RGB color sample range tolerance for your output. MediaConvert corrects any YUV values that,
     * when converted to RGB, would be outside the lower tolerance that you specify. Enter an integer from -5 to 10 as
     * an offset percentage to the minimum possible value. Leave blank to use the default value 0. When you specify a
     * value for Minimum RGB tolerance, you must set Sample range conversion to Limited range clip.
     * 
     * @return Specify the Minimum RGB color sample range tolerance for your output. MediaConvert corrects any YUV
     *         values that, when converted to RGB, would be outside the lower tolerance that you specify. Enter an
     *         integer from -5 to 10 as an offset percentage to the minimum possible value. Leave blank to use the
     *         default value 0. When you specify a value for Minimum RGB tolerance, you must set Sample range conversion
     *         to Limited range clip.
     */
    public final Integer minimumRGBTolerance() {
        return minimumRGBTolerance;
    }

    /**
     * Specify the Minimum YUV color sample limit. MediaConvert conforms any pixels in your input below the value that
     * you specify to typical limited range bounds. Enter an integer from 0 to 128. Leave blank to use the default value
     * 64. The value that you enter applies to 10-bit ranges. For 8-bit ranges, MediaConvert automatically scales this
     * value down. When you specify a value for Minumum YUV, you must set Sample range conversion to Limited range clip.
     * 
     * @return Specify the Minimum YUV color sample limit. MediaConvert conforms any pixels in your input below the
     *         value that you specify to typical limited range bounds. Enter an integer from 0 to 128. Leave blank to
     *         use the default value 64. The value that you enter applies to 10-bit ranges. For 8-bit ranges,
     *         MediaConvert automatically scales this value down. When you specify a value for Minumum YUV, you must set
     *         Sample range conversion to Limited range clip.
     */
    public final Integer minimumYUV() {
        return minimumYUV;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumRGBTolerance());
        hashCode = 31 * hashCode + Objects.hashCode(maximumYUV());
        hashCode = 31 * hashCode + Objects.hashCode(minimumRGBTolerance());
        hashCode = 31 * hashCode + Objects.hashCode(minimumYUV());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClipLimits)) {
            return false;
        }
        ClipLimits other = (ClipLimits) obj;
        return Objects.equals(maximumRGBTolerance(), other.maximumRGBTolerance())
                && Objects.equals(maximumYUV(), other.maximumYUV())
                && Objects.equals(minimumRGBTolerance(), other.minimumRGBTolerance())
                && Objects.equals(minimumYUV(), other.minimumYUV());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClipLimits").add("MaximumRGBTolerance", maximumRGBTolerance()).add("MaximumYUV", maximumYUV())
                .add("MinimumRGBTolerance", minimumRGBTolerance()).add("MinimumYUV", minimumYUV()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumRGBTolerance":
            return Optional.ofNullable(clazz.cast(maximumRGBTolerance()));
        case "MaximumYUV":
            return Optional.ofNullable(clazz.cast(maximumYUV()));
        case "MinimumRGBTolerance":
            return Optional.ofNullable(clazz.cast(minimumRGBTolerance()));
        case "MinimumYUV":
            return Optional.ofNullable(clazz.cast(minimumYUV()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClipLimits, T> g) {
        return obj -> g.apply((ClipLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClipLimits> {
        /**
         * Specify the Maximum RGB color sample range tolerance for your output. MediaConvert corrects any YUV values
         * that, when converted to RGB, would be outside the upper tolerance that you specify. Enter an integer from 90
         * to 105 as an offset percentage to the maximum possible value. Leave blank to use the default value 100. When
         * you specify a value for Maximum RGB tolerance, you must set Sample range conversion to Limited range clip.
         * 
         * @param maximumRGBTolerance
         *        Specify the Maximum RGB color sample range tolerance for your output. MediaConvert corrects any YUV
         *        values that, when converted to RGB, would be outside the upper tolerance that you specify. Enter an
         *        integer from 90 to 105 as an offset percentage to the maximum possible value. Leave blank to use the
         *        default value 100. When you specify a value for Maximum RGB tolerance, you must set Sample range
         *        conversion to Limited range clip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRGBTolerance(Integer maximumRGBTolerance);

        /**
         * Specify the Maximum YUV color sample limit. MediaConvert conforms any pixels in your input above the value
         * that you specify to typical limited range bounds. Enter an integer from 920 to 1023. Leave blank to use the
         * default value 940. The value that you enter applies to 10-bit ranges. For 8-bit ranges, MediaConvert
         * automatically scales this value down. When you specify a value for Maximum YUV, you must set Sample range
         * conversion to Limited range clip.
         * 
         * @param maximumYUV
         *        Specify the Maximum YUV color sample limit. MediaConvert conforms any pixels in your input above the
         *        value that you specify to typical limited range bounds. Enter an integer from 920 to 1023. Leave blank
         *        to use the default value 940. The value that you enter applies to 10-bit ranges. For 8-bit ranges,
         *        MediaConvert automatically scales this value down. When you specify a value for Maximum YUV, you must
         *        set Sample range conversion to Limited range clip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumYUV(Integer maximumYUV);

        /**
         * Specify the Minimum RGB color sample range tolerance for your output. MediaConvert corrects any YUV values
         * that, when converted to RGB, would be outside the lower tolerance that you specify. Enter an integer from -5
         * to 10 as an offset percentage to the minimum possible value. Leave blank to use the default value 0. When you
         * specify a value for Minimum RGB tolerance, you must set Sample range conversion to Limited range clip.
         * 
         * @param minimumRGBTolerance
         *        Specify the Minimum RGB color sample range tolerance for your output. MediaConvert corrects any YUV
         *        values that, when converted to RGB, would be outside the lower tolerance that you specify. Enter an
         *        integer from -5 to 10 as an offset percentage to the minimum possible value. Leave blank to use the
         *        default value 0. When you specify a value for Minimum RGB tolerance, you must set Sample range
         *        conversion to Limited range clip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumRGBTolerance(Integer minimumRGBTolerance);

        /**
         * Specify the Minimum YUV color sample limit. MediaConvert conforms any pixels in your input below the value
         * that you specify to typical limited range bounds. Enter an integer from 0 to 128. Leave blank to use the
         * default value 64. The value that you enter applies to 10-bit ranges. For 8-bit ranges, MediaConvert
         * automatically scales this value down. When you specify a value for Minumum YUV, you must set Sample range
         * conversion to Limited range clip.
         * 
         * @param minimumYUV
         *        Specify the Minimum YUV color sample limit. MediaConvert conforms any pixels in your input below the
         *        value that you specify to typical limited range bounds. Enter an integer from 0 to 128. Leave blank to
         *        use the default value 64. The value that you enter applies to 10-bit ranges. For 8-bit ranges,
         *        MediaConvert automatically scales this value down. When you specify a value for Minumum YUV, you must
         *        set Sample range conversion to Limited range clip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumYUV(Integer minimumYUV);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumRGBTolerance;

        private Integer maximumYUV;

        private Integer minimumRGBTolerance;

        private Integer minimumYUV;

        private BuilderImpl() {
        }

        private BuilderImpl(ClipLimits model) {
            maximumRGBTolerance(model.maximumRGBTolerance);
            maximumYUV(model.maximumYUV);
            minimumRGBTolerance(model.minimumRGBTolerance);
            minimumYUV(model.minimumYUV);
        }

        public final Integer getMaximumRGBTolerance() {
            return maximumRGBTolerance;
        }

        public final void setMaximumRGBTolerance(Integer maximumRGBTolerance) {
            this.maximumRGBTolerance = maximumRGBTolerance;
        }

        @Override
        public final Builder maximumRGBTolerance(Integer maximumRGBTolerance) {
            this.maximumRGBTolerance = maximumRGBTolerance;
            return this;
        }

        public final Integer getMaximumYUV() {
            return maximumYUV;
        }

        public final void setMaximumYUV(Integer maximumYUV) {
            this.maximumYUV = maximumYUV;
        }

        @Override
        public final Builder maximumYUV(Integer maximumYUV) {
            this.maximumYUV = maximumYUV;
            return this;
        }

        public final Integer getMinimumRGBTolerance() {
            return minimumRGBTolerance;
        }

        public final void setMinimumRGBTolerance(Integer minimumRGBTolerance) {
            this.minimumRGBTolerance = minimumRGBTolerance;
        }

        @Override
        public final Builder minimumRGBTolerance(Integer minimumRGBTolerance) {
            this.minimumRGBTolerance = minimumRGBTolerance;
            return this;
        }

        public final Integer getMinimumYUV() {
            return minimumYUV;
        }

        public final void setMinimumYUV(Integer minimumYUV) {
            this.minimumYUV = minimumYUV;
        }

        @Override
        public final Builder minimumYUV(Integer minimumYUV) {
            this.minimumYUV = minimumYUV;
            return this;
        }

        @Override
        public ClipLimits build() {
            return new ClipLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
