/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings associated with the destination. Will vary based on the type of destination
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationSettings.Builder, DestinationSettings> {
    private static final SdkField<S3DestinationSettings> S3_SETTINGS_FIELD = SdkField
            .<S3DestinationSettings> builder(MarshallingType.SDK_POJO).memberName("S3Settings")
            .getter(getter(DestinationSettings::s3Settings)).setter(setter(Builder::s3Settings))
            .constructor(S3DestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3DestinationSettings s3Settings;

    private DestinationSettings(BuilderImpl builder) {
        this.s3Settings = builder.s3Settings;
    }

    /**
     * Settings associated with S3 destination
     * 
     * @return Settings associated with S3 destination
     */
    public final S3DestinationSettings s3Settings() {
        return s3Settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationSettings)) {
            return false;
        }
        DestinationSettings other = (DestinationSettings) obj;
        return Objects.equals(s3Settings(), other.s3Settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationSettings").add("S3Settings", s3Settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Settings":
            return Optional.ofNullable(clazz.cast(s3Settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationSettings, T> g) {
        return obj -> g.apply((DestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationSettings> {
        /**
         * Settings associated with S3 destination
         * 
         * @param s3Settings
         *        Settings associated with S3 destination
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Settings(S3DestinationSettings s3Settings);

        /**
         * Settings associated with S3 destination This is a convenience method that creates an instance of the
         * {@link S3DestinationSettings.Builder} avoiding the need to create one manually via
         * {@link S3DestinationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Settings(S3DestinationSettings)}.
         * 
         * @param s3Settings
         *        a consumer that will call methods on {@link S3DestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Settings(S3DestinationSettings)
         */
        default Builder s3Settings(Consumer<S3DestinationSettings.Builder> s3Settings) {
            return s3Settings(S3DestinationSettings.builder().applyMutation(s3Settings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3DestinationSettings s3Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationSettings model) {
            s3Settings(model.s3Settings);
        }

        public final S3DestinationSettings.Builder getS3Settings() {
            return s3Settings != null ? s3Settings.toBuilder() : null;
        }

        public final void setS3Settings(S3DestinationSettings.BuilderImpl s3Settings) {
            this.s3Settings = s3Settings != null ? s3Settings.build() : null;
        }

        @Override
        public final Builder s3Settings(S3DestinationSettings s3Settings) {
            this.s3Settings = s3Settings;
            return this;
        }

        @Override
        public DestinationSettings build() {
            return new DestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
