/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the Dolby
 * stream for the RF operating mode. Default value: Film light (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related setting: To
 * have MediaConvert use the value you specify here, keep the default value, Custom (SPECIFIED) for the setting Dynamic
 * range control (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression RF
 * (DynamicRangeCompressionRf). For information about the Dolby DRC operating modes and profiles, see the Dynamic Range
 * Control chapter of the Dolby Metadata Guide at
 * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Eac3AtmosDynamicRangeCompressionRf {
    NONE("NONE"),

    FILM_STANDARD("FILM_STANDARD"),

    FILM_LIGHT("FILM_LIGHT"),

    MUSIC_STANDARD("MUSIC_STANDARD"),

    MUSIC_LIGHT("MUSIC_LIGHT"),

    SPEECH("SPEECH"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Eac3AtmosDynamicRangeCompressionRf> VALUE_MAP = EnumUtils.uniqueIndex(
            Eac3AtmosDynamicRangeCompressionRf.class, Eac3AtmosDynamicRangeCompressionRf::toString);

    private final String value;

    private Eac3AtmosDynamicRangeCompressionRf(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Eac3AtmosDynamicRangeCompressionRf corresponding to the value
     */
    public static Eac3AtmosDynamicRangeCompressionRf fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Eac3AtmosDynamicRangeCompressionRf}s
     */
    public static Set<Eac3AtmosDynamicRangeCompressionRf> knownValues() {
        Set<Eac3AtmosDynamicRangeCompressionRf> knownValues = EnumSet.allOf(Eac3AtmosDynamicRangeCompressionRf.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
