/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify the MXF profile, also called shim, for this output. When you choose Auto, MediaConvert chooses a profile
 * based on the video codec and resolution. For a list of codecs supported with each MXF profile, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/codecs-supported-with-each-mxf-profile.html. For more information
 * about the automatic selection behavior, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/default-automatic-selection-of-mxf-profiles.html.
 */
@Generated("software.amazon.awssdk:codegen")
public enum MxfProfile {
    D_10("D_10"),

    XDCAM("XDCAM"),

    OP1_A("OP1A"),

    XAVC("XAVC"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MxfProfile> VALUE_MAP = EnumUtils.uniqueIndex(MxfProfile.class, MxfProfile::toString);

    private final String value;

    private MxfProfile(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return MxfProfile corresponding to the value
     */
    public static MxfProfile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link MxfProfile}s
     */
    public static Set<MxfProfile> knownValues() {
        Set<MxfProfile> knownValues = EnumSet.allOf(MxfProfile.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
