/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify how MediaConvert limits the color sample range for this output. To create a limited range output from a full
 * range input: Choose Limited range squeeze. For full range inputs, MediaConvert performs a linear offset to color
 * samples equally across all pixels and frames. Color samples in 10-bit outputs are limited to 64 through 940, and
 * 8-bit outputs are limited to 16 through 235. Note: For limited range inputs, values for color samples are passed
 * through to your output unchanged. MediaConvert does not limit the sample range. To correct pixels in your input that
 * are out of range or out of gamut: Choose Limited range clip. Use for broadcast applications. MediaConvert conforms
 * any pixels outside of the values that you specify under Minimum YUV and Maximum YUV to limited range bounds.
 * MediaConvert also corrects any YUV values that, when converted to RGB, would be outside the bounds you specify under
 * Minimum RGB tolerance and Maximum RGB tolerance. With either limited range conversion, MediaConvert writes the sample
 * range metadata in the output.
 */
@Generated("software.amazon.awssdk:codegen")
public enum SampleRangeConversion {
    LIMITED_RANGE_SQUEEZE("LIMITED_RANGE_SQUEEZE"),

    NONE("NONE"),

    LIMITED_RANGE_CLIP("LIMITED_RANGE_CLIP"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SampleRangeConversion> VALUE_MAP = EnumUtils.uniqueIndex(SampleRangeConversion.class,
            SampleRangeConversion::toString);

    private final String value;

    private SampleRangeConversion(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return SampleRangeConversion corresponding to the value
     */
    public static SampleRangeConversion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link SampleRangeConversion}s
     */
    public static Set<SampleRangeConversion> knownValues() {
        Set<SampleRangeConversion> knownValues = EnumSet.allOf(SampleRangeConversion.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
