/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.mediaconvert.model.AssociateCertificateRequest;
import software.amazon.awssdk.services.mediaconvert.model.AssociateCertificateResponse;
import software.amazon.awssdk.services.mediaconvert.model.CancelJobRequest;
import software.amazon.awssdk.services.mediaconvert.model.CancelJobResponse;
import software.amazon.awssdk.services.mediaconvert.model.CreateJobRequest;
import software.amazon.awssdk.services.mediaconvert.model.CreateJobResponse;
import software.amazon.awssdk.services.mediaconvert.model.CreateJobTemplateRequest;
import software.amazon.awssdk.services.mediaconvert.model.CreateJobTemplateResponse;
import software.amazon.awssdk.services.mediaconvert.model.CreatePresetRequest;
import software.amazon.awssdk.services.mediaconvert.model.CreatePresetResponse;
import software.amazon.awssdk.services.mediaconvert.model.CreateQueueRequest;
import software.amazon.awssdk.services.mediaconvert.model.CreateQueueResponse;
import software.amazon.awssdk.services.mediaconvert.model.DeleteJobTemplateRequest;
import software.amazon.awssdk.services.mediaconvert.model.DeleteJobTemplateResponse;
import software.amazon.awssdk.services.mediaconvert.model.DeletePolicyRequest;
import software.amazon.awssdk.services.mediaconvert.model.DeletePolicyResponse;
import software.amazon.awssdk.services.mediaconvert.model.DeletePresetRequest;
import software.amazon.awssdk.services.mediaconvert.model.DeletePresetResponse;
import software.amazon.awssdk.services.mediaconvert.model.DeleteQueueRequest;
import software.amazon.awssdk.services.mediaconvert.model.DeleteQueueResponse;
import software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.mediaconvert.model.DisassociateCertificateRequest;
import software.amazon.awssdk.services.mediaconvert.model.DisassociateCertificateResponse;
import software.amazon.awssdk.services.mediaconvert.model.GetJobRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetJobResponse;
import software.amazon.awssdk.services.mediaconvert.model.GetJobTemplateRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetJobTemplateResponse;
import software.amazon.awssdk.services.mediaconvert.model.GetPolicyRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetPolicyResponse;
import software.amazon.awssdk.services.mediaconvert.model.GetPresetRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetPresetResponse;
import software.amazon.awssdk.services.mediaconvert.model.GetQueueRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetQueueResponse;
import software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesResponse;
import software.amazon.awssdk.services.mediaconvert.model.ListJobsRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListJobsResponse;
import software.amazon.awssdk.services.mediaconvert.model.ListPresetsRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListPresetsResponse;
import software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListQueuesResponse;
import software.amazon.awssdk.services.mediaconvert.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediaconvert.model.PutPolicyRequest;
import software.amazon.awssdk.services.mediaconvert.model.PutPolicyResponse;
import software.amazon.awssdk.services.mediaconvert.model.TagResourceRequest;
import software.amazon.awssdk.services.mediaconvert.model.TagResourceResponse;
import software.amazon.awssdk.services.mediaconvert.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediaconvert.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediaconvert.model.UpdateJobTemplateRequest;
import software.amazon.awssdk.services.mediaconvert.model.UpdateJobTemplateResponse;
import software.amazon.awssdk.services.mediaconvert.model.UpdatePresetRequest;
import software.amazon.awssdk.services.mediaconvert.model.UpdatePresetResponse;
import software.amazon.awssdk.services.mediaconvert.model.UpdateQueueRequest;
import software.amazon.awssdk.services.mediaconvert.model.UpdateQueueResponse;
import software.amazon.awssdk.services.mediaconvert.paginators.DescribeEndpointsPublisher;
import software.amazon.awssdk.services.mediaconvert.paginators.ListJobTemplatesPublisher;
import software.amazon.awssdk.services.mediaconvert.paginators.ListJobsPublisher;
import software.amazon.awssdk.services.mediaconvert.paginators.ListPresetsPublisher;
import software.amazon.awssdk.services.mediaconvert.paginators.ListQueuesPublisher;

/**
 * Service client for accessing MediaConvert asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * AWS Elemental MediaConvert
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MediaConvertAsyncClient extends AwsClient {
    String SERVICE_NAME = "mediaconvert";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mediaconvert";

    /**
     * Associates an AWS Certificate Manager (ACM) Amazon Resource Name (ARN) with AWS Elemental MediaConvert.
     *
     * @param associateCertificateRequest
     * @return A Java Future containing the result of the AssociateCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and cannot fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested does not exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service could not complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.AssociateCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/AssociateCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateCertificateResponse> associateCertificate(
            AssociateCertificateRequest associateCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Associates an AWS Certificate Manager (ACM) Amazon Resource Name (ARN) with AWS Elemental MediaConvert.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateCertificateRequest#builder()}
     * </p>
     *
     * @param associateCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.AssociateCertificateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and cannot fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested does not exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service could not complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.AssociateCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/AssociateCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateCertificateResponse> associateCertificate(
            Consumer<AssociateCertificateRequest.Builder> associateCertificateRequest) {
        return associateCertificate(AssociateCertificateRequest.builder().applyMutation(associateCertificateRequest).build());
    }

    /**
     * Permanently cancel a job. Once you have canceled a job, you can't start it again.
     *
     * @param cancelJobRequest
     * @return A Java Future containing the result of the CancelJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.CancelJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CancelJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelJobResponse> cancelJob(CancelJobRequest cancelJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Permanently cancel a job. Once you have canceled a job, you can't start it again.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelJobRequest.Builder} avoiding the need to
     * create one manually via {@link CancelJobRequest#builder()}
     * </p>
     *
     * @param cancelJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.CancelJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.CancelJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CancelJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelJobResponse> cancelJob(Consumer<CancelJobRequest.Builder> cancelJobRequest) {
        return cancelJob(CancelJobRequest.builder().applyMutation(cancelJobRequest).build());
    }

    /**
     * Create a new transcoding job. For information about jobs and job settings, see the User Guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     *
     * @param createJobRequest
     * @return A Java Future containing the result of the CreateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new transcoding job. For information about jobs and job settings, see the User Guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJobRequest#builder()}
     * </p>
     *
     * @param createJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.CreateJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateJobResponse> createJob(Consumer<CreateJobRequest.Builder> createJobRequest) {
        return createJob(CreateJobRequest.builder().applyMutation(createJobRequest).build());
    }

    /**
     * Create a new job template. For information about job templates see the User Guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     *
     * @param createJobTemplateRequest
     * @return A Java Future containing the result of the CreateJobTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.CreateJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreateJobTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateJobTemplateResponse> createJobTemplate(CreateJobTemplateRequest createJobTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new job template. For information about job templates see the User Guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link CreateJobTemplateRequest#builder()}
     * </p>
     *
     * @param createJobTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.CreateJobTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateJobTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.CreateJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreateJobTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateJobTemplateResponse> createJobTemplate(
            Consumer<CreateJobTemplateRequest.Builder> createJobTemplateRequest) {
        return createJobTemplate(CreateJobTemplateRequest.builder().applyMutation(createJobTemplateRequest).build());
    }

    /**
     * Create a new preset. For information about job templates see the User Guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     *
     * @param createPresetRequest
     * @return A Java Future containing the result of the CreatePreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.CreatePreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreatePreset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePresetResponse> createPreset(CreatePresetRequest createPresetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new preset. For information about job templates see the User Guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePresetRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePresetRequest#builder()}
     * </p>
     *
     * @param createPresetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.CreatePresetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.CreatePreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreatePreset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePresetResponse> createPreset(Consumer<CreatePresetRequest.Builder> createPresetRequest) {
        return createPreset(CreatePresetRequest.builder().applyMutation(createPresetRequest).build());
    }

    /**
     * Create a new transcoding queue. For information about queues, see Working With Queues in the User Guide at
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html
     *
     * @param createQueueRequest
     * @return A Java Future containing the result of the CreateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateQueueResponse> createQueue(CreateQueueRequest createQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new transcoding queue. For information about queues, see Working With Queues in the User Guide at
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQueueRequest.Builder} avoiding the need to
     * create one manually via {@link CreateQueueRequest#builder()}
     * </p>
     *
     * @param createQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.CreateQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateQueueResponse> createQueue(Consumer<CreateQueueRequest.Builder> createQueueRequest) {
        return createQueue(CreateQueueRequest.builder().applyMutation(createQueueRequest).build());
    }

    /**
     * Permanently delete a job template you have created.
     *
     * @param deleteJobTemplateRequest
     * @return A Java Future containing the result of the DeleteJobTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DeleteJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeleteJobTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteJobTemplateResponse> deleteJobTemplate(DeleteJobTemplateRequest deleteJobTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Permanently delete a job template you have created.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteJobTemplateRequest#builder()}
     * </p>
     *
     * @param deleteJobTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.DeleteJobTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteJobTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DeleteJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeleteJobTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteJobTemplateResponse> deleteJobTemplate(
            Consumer<DeleteJobTemplateRequest.Builder> deleteJobTemplateRequest) {
        return deleteJobTemplate(DeleteJobTemplateRequest.builder().applyMutation(deleteJobTemplateRequest).build());
    }

    /**
     * Permanently delete a policy that you created.
     *
     * @param deletePolicyRequest
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Permanently delete a policy that you created.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePolicyRequest#builder()}
     * </p>
     *
     * @param deletePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.DeletePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePolicyResponse> deletePolicy(Consumer<DeletePolicyRequest.Builder> deletePolicyRequest) {
        return deletePolicy(DeletePolicyRequest.builder().applyMutation(deletePolicyRequest).build());
    }

    /**
     * Permanently delete a preset you have created.
     *
     * @param deletePresetRequest
     * @return A Java Future containing the result of the DeletePreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DeletePreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeletePreset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePresetResponse> deletePreset(DeletePresetRequest deletePresetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Permanently delete a preset you have created.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePresetRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePresetRequest#builder()}
     * </p>
     *
     * @param deletePresetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.DeletePresetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DeletePreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeletePreset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePresetResponse> deletePreset(Consumer<DeletePresetRequest.Builder> deletePresetRequest) {
        return deletePreset(DeletePresetRequest.builder().applyMutation(deletePresetRequest).build());
    }

    /**
     * Permanently delete a queue you have created.
     *
     * @param deleteQueueRequest
     * @return A Java Future containing the result of the DeleteQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteQueueResponse> deleteQueue(DeleteQueueRequest deleteQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Permanently delete a queue you have created.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueueRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteQueueRequest#builder()}
     * </p>
     *
     * @param deleteQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.DeleteQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteQueueResponse> deleteQueue(Consumer<DeleteQueueRequest.Builder> deleteQueueRequest) {
        return deleteQueue(DeleteQueueRequest.builder().applyMutation(deleteQueueRequest).build());
    }

    /**
     * Send an request with an empty body to the regional API endpoint to get your account API endpoint.
     *
     * @param describeEndpointsRequest
     *        DescribeEndpointsRequest
     * @return A Java Future containing the result of the DescribeEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException BadRequestException</li>
     *         <li>InternalServerErrorException InternalServiceException</li>
     *         <li>ForbiddenException AccessDeniedException</li>
     *         <li>NotFoundException ResourceNotFoundException</li>
     *         <li>TooManyRequestsException LimitExceededException</li>
     *         <li>ConflictException ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DescribeEndpoints"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated DescribeEndpoints and account specific endpoints are no longer required. We recommend that you send
     *             your requests directly to the regional endpoint instead.
     */
    @Deprecated
    default CompletableFuture<DescribeEndpointsResponse> describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Send an request with an empty body to the regional API endpoint to get your account API endpoint.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointsRequest#builder()}
     * </p>
     *
     * @param describeEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest.Builder} to create a
     *        request. DescribeEndpointsRequest
     * @return A Java Future containing the result of the DescribeEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException BadRequestException</li>
     *         <li>InternalServerErrorException InternalServiceException</li>
     *         <li>ForbiddenException AccessDeniedException</li>
     *         <li>NotFoundException ResourceNotFoundException</li>
     *         <li>TooManyRequestsException LimitExceededException</li>
     *         <li>ConflictException ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DescribeEndpoints"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated DescribeEndpoints and account specific endpoints are no longer required. We recommend that you send
     *             your requests directly to the regional endpoint instead.
     */
    @Deprecated
    default CompletableFuture<DescribeEndpointsResponse> describeEndpoints(
            Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest) {
        return describeEndpoints(DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.DescribeEndpointsPublisher publisher = client.describeEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.DescribeEndpointsPublisher publisher = client.describeEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointsRequest
     *        DescribeEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException BadRequestException</li>
     *         <li>InternalServerErrorException InternalServiceException</li>
     *         <li>ForbiddenException AccessDeniedException</li>
     *         <li>NotFoundException ResourceNotFoundException</li>
     *         <li>TooManyRequestsException LimitExceededException</li>
     *         <li>ConflictException ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DescribeEndpoints"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated DescribeEndpoints and account specific endpoints are no longer required. We recommend that you send
     *             your requests directly to the regional endpoint instead.
     */
    @Deprecated
    default DescribeEndpointsPublisher describeEndpointsPaginator(DescribeEndpointsRequest describeEndpointsRequest) {
        return new DescribeEndpointsPublisher(this, describeEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.DescribeEndpointsPublisher publisher = client.describeEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.DescribeEndpointsPublisher publisher = client.describeEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointsRequest#builder()}
     * </p>
     *
     * @param describeEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest.Builder} to create a
     *        request. DescribeEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException BadRequestException</li>
     *         <li>InternalServerErrorException InternalServiceException</li>
     *         <li>ForbiddenException AccessDeniedException</li>
     *         <li>NotFoundException ResourceNotFoundException</li>
     *         <li>TooManyRequestsException LimitExceededException</li>
     *         <li>ConflictException ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DescribeEndpoints"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated DescribeEndpoints and account specific endpoints are no longer required. We recommend that you send
     *             your requests directly to the regional endpoint instead.
     */
    @Deprecated
    default DescribeEndpointsPublisher describeEndpointsPaginator(
            Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest) {
        return describeEndpointsPaginator(DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest).build());
    }

    /**
     * Removes an association between the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate and
     * an AWS Elemental MediaConvert resource.
     *
     * @param disassociateCertificateRequest
     * @return A Java Future containing the result of the DisassociateCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and cannot fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested does not exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service could not complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DisassociateCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DisassociateCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateCertificateResponse> disassociateCertificate(
            DisassociateCertificateRequest disassociateCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Removes an association between the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate and
     * an AWS Elemental MediaConvert resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateCertificateRequest#builder()}
     * </p>
     *
     * @param disassociateCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.DisassociateCertificateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and cannot fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested does not exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service could not complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.DisassociateCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DisassociateCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateCertificateResponse> disassociateCertificate(
            Consumer<DisassociateCertificateRequest.Builder> disassociateCertificateRequest) {
        return disassociateCertificate(DisassociateCertificateRequest.builder().applyMutation(disassociateCertificateRequest)
                .build());
    }

    /**
     * Retrieve the JSON for a specific transcoding job.
     *
     * @param getJobRequest
     * @return A Java Future containing the result of the GetJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobResponse> getJob(GetJobRequest getJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the JSON for a specific transcoding job.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobRequest#builder()}
     * </p>
     *
     * @param getJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.GetJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobResponse> getJob(Consumer<GetJobRequest.Builder> getJobRequest) {
        return getJob(GetJobRequest.builder().applyMutation(getJobRequest).build());
    }

    /**
     * Retrieve the JSON for a specific job template.
     *
     * @param getJobTemplateRequest
     * @return A Java Future containing the result of the GetJobTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.GetJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetJobTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetJobTemplateResponse> getJobTemplate(GetJobTemplateRequest getJobTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the JSON for a specific job template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobTemplateRequest#builder()}
     * </p>
     *
     * @param getJobTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.GetJobTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetJobTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.GetJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetJobTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetJobTemplateResponse> getJobTemplate(Consumer<GetJobTemplateRequest.Builder> getJobTemplateRequest) {
        return getJobTemplate(GetJobTemplateRequest.builder().applyMutation(getJobTemplateRequest).build());
    }

    /**
     * Retrieve the JSON for your policy.
     *
     * @param getPolicyRequest
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(GetPolicyRequest getPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the JSON for your policy.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.GetPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * Retrieve the JSON for a specific preset.
     *
     * @param getPresetRequest
     * @return A Java Future containing the result of the GetPreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.GetPreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetPreset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPresetResponse> getPreset(GetPresetRequest getPresetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the JSON for a specific preset.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPresetRequest.Builder} avoiding the need to
     * create one manually via {@link GetPresetRequest#builder()}
     * </p>
     *
     * @param getPresetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.GetPresetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.GetPreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetPreset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPresetResponse> getPreset(Consumer<GetPresetRequest.Builder> getPresetRequest) {
        return getPreset(GetPresetRequest.builder().applyMutation(getPresetRequest).build());
    }

    /**
     * Retrieve the JSON for a specific queue.
     *
     * @param getQueueRequest
     * @return A Java Future containing the result of the GetQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.GetQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQueueResponse> getQueue(GetQueueRequest getQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the JSON for a specific queue.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueueRequest.Builder} avoiding the need to
     * create one manually via {@link GetQueueRequest#builder()}
     * </p>
     *
     * @param getQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.GetQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.GetQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQueueResponse> getQueue(Consumer<GetQueueRequest.Builder> getQueueRequest) {
        return getQueue(GetQueueRequest.builder().applyMutation(getQueueRequest).build());
    }

    /**
     * Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just
     * a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array
     *
     * @param listJobTemplatesRequest
     * @return A Java Future containing the result of the ListJobTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListJobTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListJobTemplatesResponse> listJobTemplates(ListJobTemplatesRequest listJobTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just
     * a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobTemplatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListJobTemplatesRequest#builder()}
     * </p>
     *
     * @param listJobTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListJobTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListJobTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListJobTemplatesResponse> listJobTemplates(
            Consumer<ListJobTemplatesRequest.Builder> listJobTemplatesRequest) {
        return listJobTemplates(ListJobTemplatesRequest.builder().applyMutation(listJobTemplatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listJobTemplates(software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobTemplatesPublisher publisher = client.listJobTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobTemplatesPublisher publisher = client.listJobTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobTemplates(software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listJobTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListJobTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListJobTemplatesPublisher listJobTemplatesPaginator(ListJobTemplatesRequest listJobTemplatesRequest) {
        return new ListJobTemplatesPublisher(this, listJobTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listJobTemplates(software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobTemplatesPublisher publisher = client.listJobTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobTemplatesPublisher publisher = client.listJobTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobTemplates(software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobTemplatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListJobTemplatesRequest#builder()}
     * </p>
     *
     * @param listJobTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListJobTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListJobTemplatesPublisher listJobTemplatesPaginator(Consumer<ListJobTemplatesRequest.Builder> listJobTemplatesRequest) {
        return listJobTemplatesPaginator(ListJobTemplatesRequest.builder().applyMutation(listJobTemplatesRequest).build());
    }

    /**
     * Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process,
     * completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the
     * twenty next most recent jobs, use the nextToken string returned with the array.
     *
     * @param listJobsRequest
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process,
     * completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the
     * twenty next most recent jobs, use the nextToken string returned with the array.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.ListJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJobsResponse> listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) {
        return listJobs(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.mediaconvert.model.ListJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconvert.model.ListJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconvert.model.ListJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.mediaconvert.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsPublisher listJobsPaginator(ListJobsRequest listJobsRequest) {
        return new ListJobsPublisher(this, listJobsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.mediaconvert.model.ListJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconvert.model.ListJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconvert.model.ListJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.mediaconvert.model.ListJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.ListJobsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsPublisher listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest) {
        return listJobsPaginator(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list
     * of them. To retrieve the next twenty presets, use the nextToken string returned with the array.
     *
     * @param listPresetsRequest
     * @return A Java Future containing the result of the ListPresets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListPresets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListPresets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPresetsResponse> listPresets(ListPresetsRequest listPresetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list
     * of them. To retrieve the next twenty presets, use the nextToken string returned with the array.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPresetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPresetsRequest#builder()}
     * </p>
     *
     * @param listPresetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.ListPresetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPresets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListPresets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListPresets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPresetsResponse> listPresets(Consumer<ListPresetsRequest.Builder> listPresetsRequest) {
        return listPresets(ListPresetsRequest.builder().applyMutation(listPresetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPresets(software.amazon.awssdk.services.mediaconvert.model.ListPresetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListPresetsPublisher publisher = client.listPresetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListPresetsPublisher publisher = client.listPresetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconvert.model.ListPresetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconvert.model.ListPresetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPresets(software.amazon.awssdk.services.mediaconvert.model.ListPresetsRequest)} operation.</b>
     * </p>
     *
     * @param listPresetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListPresets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListPresets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPresetsPublisher listPresetsPaginator(ListPresetsRequest listPresetsRequest) {
        return new ListPresetsPublisher(this, listPresetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listPresets(software.amazon.awssdk.services.mediaconvert.model.ListPresetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListPresetsPublisher publisher = client.listPresetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListPresetsPublisher publisher = client.listPresetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconvert.model.ListPresetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconvert.model.ListPresetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPresets(software.amazon.awssdk.services.mediaconvert.model.ListPresetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPresetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPresetsRequest#builder()}
     * </p>
     *
     * @param listPresetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.ListPresetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListPresets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListPresets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPresetsPublisher listPresetsPaginator(Consumer<ListPresetsRequest.Builder> listPresetsRequest) {
        return listPresetsPaginator(ListPresetsRequest.builder().applyMutation(listPresetsRequest).build());
    }

    /**
     * Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of
     * them. To retrieve the next twenty queues, use the nextToken string returned with the array.
     *
     * @param listQueuesRequest
     * @return A Java Future containing the result of the ListQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQueuesResponse> listQueues(ListQueuesRequest listQueuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of
     * them. To retrieve the next twenty queues, use the nextToken string returned with the array.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQueuesResponse> listQueues(Consumer<ListQueuesRequest.Builder> listQueuesRequest) {
        return listQueues(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListQueuesPublisher publisher = client.listQueuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListQueuesPublisher publisher = client.listQueuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconvert.model.ListQueuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconvert.model.ListQueuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest)} operation.</b>
     * </p>
     *
     * @param listQueuesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesPublisher listQueuesPaginator(ListQueuesRequest listQueuesRequest) {
        return new ListQueuesPublisher(this, listQueuesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListQueuesPublisher publisher = client.listQueuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListQueuesPublisher publisher = client.listQueuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconvert.model.ListQueuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconvert.model.ListQueuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesPublisher listQueuesPaginator(Consumer<ListQueuesRequest.Builder> listQueuesRequest) {
        return listQueuesPaginator(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * Retrieve the tags for a MediaConvert resource.
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the tags for a MediaConvert resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * Create or change your policy. For more information about policies, see the user guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     *
     * @param putPolicyRequest
     * @return A Java Future containing the result of the PutPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.PutPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/PutPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutPolicyResponse> putPolicy(PutPolicyRequest putPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create or change your policy. For more information about policies, see the user guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutPolicyRequest#builder()}
     * </p>
     *
     * @param putPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.PutPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.PutPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/PutPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutPolicyResponse> putPolicy(Consumer<PutPolicyRequest.Builder> putPolicyRequest) {
        return putPolicy(PutPolicyRequest.builder().applyMutation(putPolicyRequest).build());
    }

    /**
     * Add tags to a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Add tags to a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * Remove tags from a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide
     * at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Remove tags from a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide
     * at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Modify one of your existing job templates.
     *
     * @param updateJobTemplateRequest
     * @return A Java Future containing the result of the UpdateJobTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.UpdateJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UpdateJobTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateJobTemplateResponse> updateJobTemplate(UpdateJobTemplateRequest updateJobTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Modify one of your existing job templates.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateJobTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateJobTemplateRequest#builder()}
     * </p>
     *
     * @param updateJobTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.UpdateJobTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateJobTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.UpdateJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UpdateJobTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateJobTemplateResponse> updateJobTemplate(
            Consumer<UpdateJobTemplateRequest.Builder> updateJobTemplateRequest) {
        return updateJobTemplate(UpdateJobTemplateRequest.builder().applyMutation(updateJobTemplateRequest).build());
    }

    /**
     * Modify one of your existing presets.
     *
     * @param updatePresetRequest
     * @return A Java Future containing the result of the UpdatePreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.UpdatePreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UpdatePreset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePresetResponse> updatePreset(UpdatePresetRequest updatePresetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Modify one of your existing presets.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePresetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePresetRequest#builder()}
     * </p>
     *
     * @param updatePresetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.UpdatePresetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.UpdatePreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UpdatePreset" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePresetResponse> updatePreset(Consumer<UpdatePresetRequest.Builder> updatePresetRequest) {
        return updatePreset(UpdatePresetRequest.builder().applyMutation(updatePresetRequest).build());
    }

    /**
     * Modify one of your existing queues.
     *
     * @param updateQueueRequest
     * @return A Java Future containing the result of the UpdateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.UpdateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UpdateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateQueueResponse> updateQueue(UpdateQueueRequest updateQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Modify one of your existing queues.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateQueueRequest#builder()}
     * </p>
     *
     * @param updateQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconvert.model.UpdateQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Please check your request form and syntax.</li>
     *         <li>InternalServerErrorException The service encountered an unexpected condition and can't fulfill your
     *         request.</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials you sent.</li>
     *         <li>NotFoundException The resource you requested doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service couldn't complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConvertException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConvertAsyncClient.UpdateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UpdateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateQueueResponse> updateQueue(Consumer<UpdateQueueRequest.Builder> updateQueueRequest) {
        return updateQueue(UpdateQueueRequest.builder().applyMutation(updateQueueRequest).build());
    }

    @Override
    default MediaConvertServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MediaConvertAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaConvertAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaConvertAsyncClient}.
     */
    static MediaConvertAsyncClientBuilder builder() {
        return new DefaultMediaConvertAsyncClientBuilder();
    }
}
