/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Overlay one or more videos on top of your input video. For more information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/video-overlays.html
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoOverlay implements SdkPojo, Serializable, ToCopyableBuilder<VideoOverlay.Builder, VideoOverlay> {
    private static final SdkField<String> END_TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTimecode").getter(getter(VideoOverlay::endTimecode)).setter(setter(Builder::endTimecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimecode").build()).build();

    private static final SdkField<VideoOverlayInput> INPUT_FIELD = SdkField.<VideoOverlayInput> builder(MarshallingType.SDK_POJO)
            .memberName("Input").getter(getter(VideoOverlay::input)).setter(setter(Builder::input))
            .constructor(VideoOverlayInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> START_TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTimecode").getter(getter(VideoOverlay::startTimecode)).setter(setter(Builder::startTimecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimecode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIMECODE_FIELD,
            INPUT_FIELD, START_TIMECODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endTimecode;

    private final VideoOverlayInput input;

    private final String startTimecode;

    private VideoOverlay(BuilderImpl builder) {
        this.endTimecode = builder.endTimecode;
        this.input = builder.input;
        this.startTimecode = builder.startTimecode;
    }

    /**
     * Enter the end timecode in the underlying input video for this overlay. Your overlay will be active through this
     * frame. To display your video overlay for the duration of the underlying video: Leave blank. Use the format
     * HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is the frame number.
     * When entering this value, take into account your choice for the underlying Input timecode source. For example, if
     * you have embedded timecodes that start at 01:00:00:00 and you want your overlay to end ten minutes into the
     * video, enter 01:10:00:00.
     * 
     * @return Enter the end timecode in the underlying input video for this overlay. Your overlay will be active
     *         through this frame. To display your video overlay for the duration of the underlying video: Leave blank.
     *         Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and
     *         FF is the frame number. When entering this value, take into account your choice for the underlying Input
     *         timecode source. For example, if you have embedded timecodes that start at 01:00:00:00 and you want your
     *         overlay to end ten minutes into the video, enter 01:10:00:00.
     */
    public final String endTimecode() {
        return endTimecode;
    }

    /**
     * Input settings for Video overlay. You can include one or more video overlays in sequence at different times that
     * you specify.
     * 
     * @return Input settings for Video overlay. You can include one or more video overlays in sequence at different
     *         times that you specify.
     */
    public final VideoOverlayInput input() {
        return input;
    }

    /**
     * Enter the start timecode in the underlying input video for this overlay. Your overlay will be active starting
     * with this frame. To display your video overlay starting at the beginning of the underlying video: Leave blank.
     * Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is
     * the frame number. When entering this value, take into account your choice for the underlying Input timecode
     * source. For example, if you have embedded timecodes that start at 01:00:00:00 and you want your overlay to begin
     * five minutes into the video, enter 01:05:00:00.
     * 
     * @return Enter the start timecode in the underlying input video for this overlay. Your overlay will be active
     *         starting with this frame. To display your video overlay starting at the beginning of the underlying
     *         video: Leave blank. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS
     *         is the second, and FF is the frame number. When entering this value, take into account your choice for
     *         the underlying Input timecode source. For example, if you have embedded timecodes that start at
     *         01:00:00:00 and you want your overlay to begin five minutes into the video, enter 01:05:00:00.
     */
    public final String startTimecode() {
        return startTimecode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTimecode());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(startTimecode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoOverlay)) {
            return false;
        }
        VideoOverlay other = (VideoOverlay) obj;
        return Objects.equals(endTimecode(), other.endTimecode()) && Objects.equals(input(), other.input())
                && Objects.equals(startTimecode(), other.startTimecode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoOverlay").add("EndTimecode", endTimecode()).add("Input", input())
                .add("StartTimecode", startTimecode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndTimecode":
            return Optional.ofNullable(clazz.cast(endTimecode()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "StartTimecode":
            return Optional.ofNullable(clazz.cast(startTimecode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoOverlay, T> g) {
        return obj -> g.apply((VideoOverlay) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoOverlay> {
        /**
         * Enter the end timecode in the underlying input video for this overlay. Your overlay will be active through
         * this frame. To display your video overlay for the duration of the underlying video: Leave blank. Use the
         * format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is the
         * frame number. When entering this value, take into account your choice for the underlying Input timecode
         * source. For example, if you have embedded timecodes that start at 01:00:00:00 and you want your overlay to
         * end ten minutes into the video, enter 01:10:00:00.
         * 
         * @param endTimecode
         *        Enter the end timecode in the underlying input video for this overlay. Your overlay will be active
         *        through this frame. To display your video overlay for the duration of the underlying video: Leave
         *        blank. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the
         *        second, and FF is the frame number. When entering this value, take into account your choice for the
         *        underlying Input timecode source. For example, if you have embedded timecodes that start at
         *        01:00:00:00 and you want your overlay to end ten minutes into the video, enter 01:10:00:00.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimecode(String endTimecode);

        /**
         * Input settings for Video overlay. You can include one or more video overlays in sequence at different times
         * that you specify.
         * 
         * @param input
         *        Input settings for Video overlay. You can include one or more video overlays in sequence at different
         *        times that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(VideoOverlayInput input);

        /**
         * Input settings for Video overlay. You can include one or more video overlays in sequence at different times
         * that you specify. This is a convenience method that creates an instance of the
         * {@link VideoOverlayInput.Builder} avoiding the need to create one manually via
         * {@link VideoOverlayInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoOverlayInput.Builder#build()} is called immediately and its
         * result is passed to {@link #input(VideoOverlayInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link VideoOverlayInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(VideoOverlayInput)
         */
        default Builder input(Consumer<VideoOverlayInput.Builder> input) {
            return input(VideoOverlayInput.builder().applyMutation(input).build());
        }

        /**
         * Enter the start timecode in the underlying input video for this overlay. Your overlay will be active starting
         * with this frame. To display your video overlay starting at the beginning of the underlying video: Leave
         * blank. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second,
         * and FF is the frame number. When entering this value, take into account your choice for the underlying Input
         * timecode source. For example, if you have embedded timecodes that start at 01:00:00:00 and you want your
         * overlay to begin five minutes into the video, enter 01:05:00:00.
         * 
         * @param startTimecode
         *        Enter the start timecode in the underlying input video for this overlay. Your overlay will be active
         *        starting with this frame. To display your video overlay starting at the beginning of the underlying
         *        video: Leave blank. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute,
         *        SS is the second, and FF is the frame number. When entering this value, take into account your choice
         *        for the underlying Input timecode source. For example, if you have embedded timecodes that start at
         *        01:00:00:00 and you want your overlay to begin five minutes into the video, enter 01:05:00:00.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimecode(String startTimecode);
    }

    static final class BuilderImpl implements Builder {
        private String endTimecode;

        private VideoOverlayInput input;

        private String startTimecode;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoOverlay model) {
            endTimecode(model.endTimecode);
            input(model.input);
            startTimecode(model.startTimecode);
        }

        public final String getEndTimecode() {
            return endTimecode;
        }

        public final void setEndTimecode(String endTimecode) {
            this.endTimecode = endTimecode;
        }

        @Override
        public final Builder endTimecode(String endTimecode) {
            this.endTimecode = endTimecode;
            return this;
        }

        public final VideoOverlayInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(VideoOverlayInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(VideoOverlayInput input) {
            this.input = input;
            return this;
        }

        public final String getStartTimecode() {
            return startTimecode;
        }

        public final void setStartTimecode(String startTimecode) {
            this.startTimecode = startTimecode;
        }

        @Override
        public final Builder startTimecode(String startTimecode) {
            this.startTimecode = startTimecode;
            return this;
        }

        @Override
        public VideoOverlay build() {
            return new VideoOverlay(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
