/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set Profile to the value XAVC_HD.
 */
@Generated("software.amazon.awssdk:codegen")
public final class XavcHdProfileSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<XavcHdProfileSettings.Builder, XavcHdProfileSettings> {
    private static final SdkField<String> BITRATE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BitrateClass").getter(getter(XavcHdProfileSettings::bitrateClassAsString))
            .setter(setter(Builder::bitrateClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrateClass").build()).build();

    private static final SdkField<String> FLICKER_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FlickerAdaptiveQuantization")
            .getter(getter(XavcHdProfileSettings::flickerAdaptiveQuantizationAsString))
            .setter(setter(Builder::flickerAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flickerAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<String> GOP_B_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GopBReference").getter(getter(XavcHdProfileSettings::gopBReferenceAsString))
            .setter(setter(Builder::gopBReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopBReference").build()).build();

    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GopClosedCadence").getter(getter(XavcHdProfileSettings::gopClosedCadence))
            .setter(setter(Builder::gopClosedCadence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()).build();

    private static final SdkField<Integer> HRD_BUFFER_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HrdBufferSize").getter(getter(XavcHdProfileSettings::hrdBufferSize))
            .setter(setter(Builder::hrdBufferSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferSize").build()).build();

    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InterlaceMode").getter(getter(XavcHdProfileSettings::interlaceModeAsString))
            .setter(setter(Builder::interlaceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()).build();

    private static final SdkField<String> QUALITY_TUNING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualityTuningLevel").getter(getter(XavcHdProfileSettings::qualityTuningLevelAsString))
            .setter(setter(Builder::qualityTuningLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityTuningLevel").build())
            .build();

    private static final SdkField<Integer> SLICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Slices").getter(getter(XavcHdProfileSettings::slices)).setter(setter(Builder::slices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()).build();

    private static final SdkField<String> TELECINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Telecine").getter(getter(XavcHdProfileSettings::telecineAsString)).setter(setter(Builder::telecine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_CLASS_FIELD,
            FLICKER_ADAPTIVE_QUANTIZATION_FIELD, GOP_B_REFERENCE_FIELD, GOP_CLOSED_CADENCE_FIELD, HRD_BUFFER_SIZE_FIELD,
            INTERLACE_MODE_FIELD, QUALITY_TUNING_LEVEL_FIELD, SLICES_FIELD, TELECINE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bitrateClass;

    private final String flickerAdaptiveQuantization;

    private final String gopBReference;

    private final Integer gopClosedCadence;

    private final Integer hrdBufferSize;

    private final String interlaceMode;

    private final String qualityTuningLevel;

    private final Integer slices;

    private final String telecine;

    private XavcHdProfileSettings(BuilderImpl builder) {
        this.bitrateClass = builder.bitrateClass;
        this.flickerAdaptiveQuantization = builder.flickerAdaptiveQuantization;
        this.gopBReference = builder.gopBReference;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.interlaceMode = builder.interlaceMode;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.slices = builder.slices;
        this.telecine = builder.telecine;
    }

    /**
     * Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have
     * similar image quality over the operating points that are valid for that class.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitrateClass} will
     * return {@link XavcHdProfileBitrateClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #bitrateClassAsString}.
     * </p>
     * 
     * @return Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class
     *         have similar image quality over the operating points that are valid for that class.
     * @see XavcHdProfileBitrateClass
     */
    public final XavcHdProfileBitrateClass bitrateClass() {
        return XavcHdProfileBitrateClass.fromValue(bitrateClass);
    }

    /**
     * Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have
     * similar image quality over the operating points that are valid for that class.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitrateClass} will
     * return {@link XavcHdProfileBitrateClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #bitrateClassAsString}.
     * </p>
     * 
     * @return Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class
     *         have similar image quality over the operating points that are valid for that class.
     * @see XavcHdProfileBitrateClass
     */
    public final String bitrateClassAsString() {
        return bitrateClass;
    }

    /**
     * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your video
     * content. Include this setting in your JSON job specification only when you choose to change the default value for
     * Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a
     * visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to
     * frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these
     * macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting:
     * In addition to enabling this setting, you must also set Adaptive quantization to a value other than Off or Auto.
     * Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flickerAdaptiveQuantization} will return {@link XavcFlickerAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #flickerAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     *         quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
     *         video content. Include this setting in your JSON job specification only when you choose to change the
     *         default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop.
     *         I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some
     *         macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this
     *         setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This
     *         setting is disabled by default. Related setting: In addition to enabling this setting, you must also set
     *         Adaptive quantization to a value other than Off or Auto. Use Adaptive quantization to adjust the degree
     *         of smoothing that Flicker adaptive quantization provides.
     * @see XavcFlickerAdaptiveQuantization
     */
    public final XavcFlickerAdaptiveQuantization flickerAdaptiveQuantization() {
        return XavcFlickerAdaptiveQuantization.fromValue(flickerAdaptiveQuantization);
    }

    /**
     * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your video
     * content. Include this setting in your JSON job specification only when you choose to change the default value for
     * Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a
     * visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to
     * frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these
     * macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting:
     * In addition to enabling this setting, you must also set Adaptive quantization to a value other than Off or Auto.
     * Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flickerAdaptiveQuantization} will return {@link XavcFlickerAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #flickerAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     *         quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
     *         video content. Include this setting in your JSON job specification only when you choose to change the
     *         default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop.
     *         I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some
     *         macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this
     *         setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This
     *         setting is disabled by default. Related setting: In addition to enabling this setting, you must also set
     *         Adaptive quantization to a value other than Off or Auto. Use Adaptive quantization to adjust the degree
     *         of smoothing that Flicker adaptive quantization provides.
     * @see XavcFlickerAdaptiveQuantization
     */
    public final String flickerAdaptiveQuantizationAsString() {
        return flickerAdaptiveQuantization;
    }

    /**
     * Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow to
     * allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent the encoder from using
     * B-frames as reference frames.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopBReference}
     * will return {@link XavcGopBReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gopBReferenceAsString}.
     * </p>
     * 
     * @return Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose
     *         Allow to allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent the encoder
     *         from using B-frames as reference frames.
     * @see XavcGopBReference
     */
    public final XavcGopBReference gopBReference() {
        return XavcGopBReference.fromValue(gopBReference);
    }

    /**
     * Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow to
     * allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent the encoder from using
     * B-frames as reference frames.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopBReference}
     * will return {@link XavcGopBReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gopBReferenceAsString}.
     * </p>
     * 
     * @return Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose
     *         Allow to allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent the encoder
     *         from using B-frames as reference frames.
     * @see XavcGopBReference
     */
    public final String gopBReferenceAsString() {
        return gopBReference;
    }

    /**
     * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining
     * mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output
     * segmenting.
     * 
     * @return Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
     *         joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
     *         output segmenting.
     */
    public final Integer gopClosedCadence() {
        return gopClosedCadence;
    }

    /**
     * Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value
     * in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero,
     * MediaConvert calculates the default by doubling the bitrate of this output point.
     * 
     * @return Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify
     *         this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you
     *         set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
     */
    public final Integer hrdBufferSize() {
        return hrdBufferSize;
    }

    /**
     * Choose the scan line type for the output. Keep the default value, Progressive to create a progressive output,
     * regardless of the scan type of your input. Use Top field first or Bottom field first to create an output that's
     * interlaced with the same field polarity throughout. Use Follow, default top or Follow, default bottom to produce
     * outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity
     * might change over the course of the output. Follow behavior depends on the input scan type. If the source is
     * interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the
     * output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link XavcInterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Choose the scan line type for the output. Keep the default value, Progressive to create a progressive
     *         output, regardless of the scan type of your input. Use Top field first or Bottom field first to create an
     *         output that's interlaced with the same field polarity throughout. Use Follow, default top or Follow,
     *         default bottom to produce outputs with the same field polarity as the source. For jobs that have multiple
     *         inputs, the output field polarity might change over the course of the output. Follow behavior depends on
     *         the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as
     *         the source. If the source is progressive, the output will be interlaced with top field bottom field
     *         first, depending on which of the Follow options you choose.
     * @see XavcInterlaceMode
     */
    public final XavcInterlaceMode interlaceMode() {
        return XavcInterlaceMode.fromValue(interlaceMode);
    }

    /**
     * Choose the scan line type for the output. Keep the default value, Progressive to create a progressive output,
     * regardless of the scan type of your input. Use Top field first or Bottom field first to create an output that's
     * interlaced with the same field polarity throughout. Use Follow, default top or Follow, default bottom to produce
     * outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity
     * might change over the course of the output. Follow behavior depends on the input scan type. If the source is
     * interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the
     * output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link XavcInterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Choose the scan line type for the output. Keep the default value, Progressive to create a progressive
     *         output, regardless of the scan type of your input. Use Top field first or Bottom field first to create an
     *         output that's interlaced with the same field polarity throughout. Use Follow, default top or Follow,
     *         default bottom to produce outputs with the same field polarity as the source. For jobs that have multiple
     *         inputs, the output field polarity might change over the course of the output. Follow behavior depends on
     *         the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as
     *         the source. If the source is progressive, the output will be interlaced with top field bottom field
     *         first, depending on which of the Follow options you choose.
     * @see XavcInterlaceMode
     */
    public final String interlaceModeAsString() {
        return interlaceMode;
    }

    /**
     * Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video quality.
     * The default behavior is faster, lower quality, single-pass encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link XavcHdProfileQualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video
     *         quality. The default behavior is faster, lower quality, single-pass encoding.
     * @see XavcHdProfileQualityTuningLevel
     */
    public final XavcHdProfileQualityTuningLevel qualityTuningLevel() {
        return XavcHdProfileQualityTuningLevel.fromValue(qualityTuningLevel);
    }

    /**
     * Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video quality.
     * The default behavior is faster, lower quality, single-pass encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link XavcHdProfileQualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video
     *         quality. The default behavior is faster, lower quality, single-pass encoding.
     * @see XavcHdProfileQualityTuningLevel
     */
    public final String qualityTuningLevelAsString() {
        return qualityTuningLevel;
    }

    /**
     * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     * 
     * @return Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     *         pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     */
    public final Integer slices() {
        return slices;
    }

    /**
     * Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to 29.970. If
     * your input framerate is 23.976, choose Hard. Otherwise, keep the default value None. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link XavcHdProfileTelecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #telecineAsString}.
     * </p>
     * 
     * @return Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to
     *         29.970. If your input framerate is 23.976, choose Hard. Otherwise, keep the default value None. For more
     *         information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
     * @see XavcHdProfileTelecine
     */
    public final XavcHdProfileTelecine telecine() {
        return XavcHdProfileTelecine.fromValue(telecine);
    }

    /**
     * Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to 29.970. If
     * your input framerate is 23.976, choose Hard. Otherwise, keep the default value None. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link XavcHdProfileTelecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #telecineAsString}.
     * </p>
     * 
     * @return Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to
     *         29.970. If your input framerate is 23.976, choose Hard. Otherwise, keep the default value None. For more
     *         information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
     * @see XavcHdProfileTelecine
     */
    public final String telecineAsString() {
        return telecine;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitrateClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(flickerAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gopBReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slices());
        hashCode = 31 * hashCode + Objects.hashCode(telecineAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XavcHdProfileSettings)) {
            return false;
        }
        XavcHdProfileSettings other = (XavcHdProfileSettings) obj;
        return Objects.equals(bitrateClassAsString(), other.bitrateClassAsString())
                && Objects.equals(flickerAdaptiveQuantizationAsString(), other.flickerAdaptiveQuantizationAsString())
                && Objects.equals(gopBReferenceAsString(), other.gopBReferenceAsString())
                && Objects.equals(gopClosedCadence(), other.gopClosedCadence())
                && Objects.equals(hrdBufferSize(), other.hrdBufferSize())
                && Objects.equals(interlaceModeAsString(), other.interlaceModeAsString())
                && Objects.equals(qualityTuningLevelAsString(), other.qualityTuningLevelAsString())
                && Objects.equals(slices(), other.slices()) && Objects.equals(telecineAsString(), other.telecineAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("XavcHdProfileSettings").add("BitrateClass", bitrateClassAsString())
                .add("FlickerAdaptiveQuantization", flickerAdaptiveQuantizationAsString())
                .add("GopBReference", gopBReferenceAsString()).add("GopClosedCadence", gopClosedCadence())
                .add("HrdBufferSize", hrdBufferSize()).add("InterlaceMode", interlaceModeAsString())
                .add("QualityTuningLevel", qualityTuningLevelAsString()).add("Slices", slices())
                .add("Telecine", telecineAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BitrateClass":
            return Optional.ofNullable(clazz.cast(bitrateClassAsString()));
        case "FlickerAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(flickerAdaptiveQuantizationAsString()));
        case "GopBReference":
            return Optional.ofNullable(clazz.cast(gopBReferenceAsString()));
        case "GopClosedCadence":
            return Optional.ofNullable(clazz.cast(gopClosedCadence()));
        case "HrdBufferSize":
            return Optional.ofNullable(clazz.cast(hrdBufferSize()));
        case "InterlaceMode":
            return Optional.ofNullable(clazz.cast(interlaceModeAsString()));
        case "QualityTuningLevel":
            return Optional.ofNullable(clazz.cast(qualityTuningLevelAsString()));
        case "Slices":
            return Optional.ofNullable(clazz.cast(slices()));
        case "Telecine":
            return Optional.ofNullable(clazz.cast(telecineAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<XavcHdProfileSettings, T> g) {
        return obj -> g.apply((XavcHdProfileSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, XavcHdProfileSettings> {
        /**
         * Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class
         * have similar image quality over the operating points that are valid for that class.
         * 
         * @param bitrateClass
         *        Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same
         *        class have similar image quality over the operating points that are valid for that class.
         * @see XavcHdProfileBitrateClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcHdProfileBitrateClass
         */
        Builder bitrateClass(String bitrateClass);

        /**
         * Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class
         * have similar image quality over the operating points that are valid for that class.
         * 
         * @param bitrateClass
         *        Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same
         *        class have similar image quality over the operating points that are valid for that class.
         * @see XavcHdProfileBitrateClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcHdProfileBitrateClass
         */
        Builder bitrateClass(XavcHdProfileBitrateClass bitrateClass);

        /**
         * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
         * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
         * video content. Include this setting in your JSON job specification only when you choose to change the default
         * value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop
         * appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times
         * from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder
         * updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default.
         * Related setting: In addition to enabling this setting, you must also set Adaptive quantization to a value
         * other than Off or Auto. Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive
         * quantization provides.
         * 
         * @param flickerAdaptiveQuantization
         *        The best way to set up adaptive quantization is to keep the default value, Auto, for the setting
         *        Adaptive quantization. When you do so, MediaConvert automatically applies the best types of
         *        quantization for your video content. Include this setting in your JSON job specification only when you
         *        choose to change the default value for Adaptive quantization. Enable this setting to have the encoder
         *        reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits
         *        by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame.
         *        When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out
         *        the flicker. This setting is disabled by default. Related setting: In addition to enabling this
         *        setting, you must also set Adaptive quantization to a value other than Off or Auto. Use Adaptive
         *        quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
         * @see XavcFlickerAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcFlickerAdaptiveQuantization
         */
        Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization);

        /**
         * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
         * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
         * video content. Include this setting in your JSON job specification only when you choose to change the default
         * value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop
         * appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times
         * from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder
         * updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default.
         * Related setting: In addition to enabling this setting, you must also set Adaptive quantization to a value
         * other than Off or Auto. Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive
         * quantization provides.
         * 
         * @param flickerAdaptiveQuantization
         *        The best way to set up adaptive quantization is to keep the default value, Auto, for the setting
         *        Adaptive quantization. When you do so, MediaConvert automatically applies the best types of
         *        quantization for your video content. Include this setting in your JSON job specification only when you
         *        choose to change the default value for Adaptive quantization. Enable this setting to have the encoder
         *        reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits
         *        by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame.
         *        When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out
         *        the flicker. This setting is disabled by default. Related setting: In addition to enabling this
         *        setting, you must also set Adaptive quantization to a value other than Off or Auto. Use Adaptive
         *        quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
         * @see XavcFlickerAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcFlickerAdaptiveQuantization
         */
        Builder flickerAdaptiveQuantization(XavcFlickerAdaptiveQuantization flickerAdaptiveQuantization);

        /**
         * Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose
         * Allow to allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent the encoder
         * from using B-frames as reference frames.
         * 
         * @param gopBReference
         *        Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP.
         *        Choose Allow to allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent
         *        the encoder from using B-frames as reference frames.
         * @see XavcGopBReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcGopBReference
         */
        Builder gopBReference(String gopBReference);

        /**
         * Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose
         * Allow to allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent the encoder
         * from using B-frames as reference frames.
         * 
         * @param gopBReference
         *        Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP.
         *        Choose Allow to allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent
         *        the encoder from using B-frames as reference frames.
         * @see XavcGopBReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcGopBReference
         */
        Builder gopBReference(XavcGopBReference gopBReference);

        /**
         * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
         * joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
         * output segmenting.
         * 
         * @param gopClosedCadence
         *        Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a
         *        decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0
         *        will break output segmenting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopClosedCadence(Integer gopClosedCadence);

        /**
         * Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this
         * value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to
         * zero, MediaConvert calculates the default by doubling the bitrate of this output point.
         * 
         * @param hrdBufferSize
         *        Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify
         *        this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you
         *        set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hrdBufferSize(Integer hrdBufferSize);

        /**
         * Choose the scan line type for the output. Keep the default value, Progressive to create a progressive output,
         * regardless of the scan type of your input. Use Top field first or Bottom field first to create an output
         * that's interlaced with the same field polarity throughout. Use Follow, default top or Follow, default bottom
         * to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output
         * field polarity might change over the course of the output. Follow behavior depends on the input scan type. If
         * the source is interlaced, the output will be interlaced with the same polarity as the source. If the source
         * is progressive, the output will be interlaced with top field bottom field first, depending on which of the
         * Follow options you choose.
         * 
         * @param interlaceMode
         *        Choose the scan line type for the output. Keep the default value, Progressive to create a progressive
         *        output, regardless of the scan type of your input. Use Top field first or Bottom field first to create
         *        an output that's interlaced with the same field polarity throughout. Use Follow, default top or
         *        Follow, default bottom to produce outputs with the same field polarity as the source. For jobs that
         *        have multiple inputs, the output field polarity might change over the course of the output. Follow
         *        behavior depends on the input scan type. If the source is interlaced, the output will be interlaced
         *        with the same polarity as the source. If the source is progressive, the output will be interlaced with
         *        top field bottom field first, depending on which of the Follow options you choose.
         * @see XavcInterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcInterlaceMode
         */
        Builder interlaceMode(String interlaceMode);

        /**
         * Choose the scan line type for the output. Keep the default value, Progressive to create a progressive output,
         * regardless of the scan type of your input. Use Top field first or Bottom field first to create an output
         * that's interlaced with the same field polarity throughout. Use Follow, default top or Follow, default bottom
         * to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output
         * field polarity might change over the course of the output. Follow behavior depends on the input scan type. If
         * the source is interlaced, the output will be interlaced with the same polarity as the source. If the source
         * is progressive, the output will be interlaced with top field bottom field first, depending on which of the
         * Follow options you choose.
         * 
         * @param interlaceMode
         *        Choose the scan line type for the output. Keep the default value, Progressive to create a progressive
         *        output, regardless of the scan type of your input. Use Top field first or Bottom field first to create
         *        an output that's interlaced with the same field polarity throughout. Use Follow, default top or
         *        Follow, default bottom to produce outputs with the same field polarity as the source. For jobs that
         *        have multiple inputs, the output field polarity might change over the course of the output. Follow
         *        behavior depends on the input scan type. If the source is interlaced, the output will be interlaced
         *        with the same polarity as the source. If the source is progressive, the output will be interlaced with
         *        top field bottom field first, depending on which of the Follow options you choose.
         * @see XavcInterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcInterlaceMode
         */
        Builder interlaceMode(XavcInterlaceMode interlaceMode);

        /**
         * Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video
         * quality. The default behavior is faster, lower quality, single-pass encoding.
         * 
         * @param qualityTuningLevel
         *        Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video
         *        quality. The default behavior is faster, lower quality, single-pass encoding.
         * @see XavcHdProfileQualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcHdProfileQualityTuningLevel
         */
        Builder qualityTuningLevel(String qualityTuningLevel);

        /**
         * Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video
         * quality. The default behavior is faster, lower quality, single-pass encoding.
         * 
         * @param qualityTuningLevel
         *        Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video
         *        quality. The default behavior is faster, lower quality, single-pass encoding.
         * @see XavcHdProfileQualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcHdProfileQualityTuningLevel
         */
        Builder qualityTuningLevel(XavcHdProfileQualityTuningLevel qualityTuningLevel);

        /**
         * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
         * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
         * 
         * @param slices
         *        Number of slices per picture. Must be less than or equal to the number of macroblock rows for
         *        progressive pictures, and less than or equal to half the number of macroblock rows for interlaced
         *        pictures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slices(Integer slices);

        /**
         * Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to 29.970.
         * If your input framerate is 23.976, choose Hard. Otherwise, keep the default value None. For more information,
         * see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
         * 
         * @param telecine
         *        Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to
         *        29.970. If your input framerate is 23.976, choose Hard. Otherwise, keep the default value None. For
         *        more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
         * @see XavcHdProfileTelecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcHdProfileTelecine
         */
        Builder telecine(String telecine);

        /**
         * Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to 29.970.
         * If your input framerate is 23.976, choose Hard. Otherwise, keep the default value None. For more information,
         * see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
         * 
         * @param telecine
         *        Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to
         *        29.970. If your input framerate is 23.976, choose Hard. Otherwise, keep the default value None. For
         *        more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
         * @see XavcHdProfileTelecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcHdProfileTelecine
         */
        Builder telecine(XavcHdProfileTelecine telecine);
    }

    static final class BuilderImpl implements Builder {
        private String bitrateClass;

        private String flickerAdaptiveQuantization;

        private String gopBReference;

        private Integer gopClosedCadence;

        private Integer hrdBufferSize;

        private String interlaceMode;

        private String qualityTuningLevel;

        private Integer slices;

        private String telecine;

        private BuilderImpl() {
        }

        private BuilderImpl(XavcHdProfileSettings model) {
            bitrateClass(model.bitrateClass);
            flickerAdaptiveQuantization(model.flickerAdaptiveQuantization);
            gopBReference(model.gopBReference);
            gopClosedCadence(model.gopClosedCadence);
            hrdBufferSize(model.hrdBufferSize);
            interlaceMode(model.interlaceMode);
            qualityTuningLevel(model.qualityTuningLevel);
            slices(model.slices);
            telecine(model.telecine);
        }

        public final String getBitrateClass() {
            return bitrateClass;
        }

        public final void setBitrateClass(String bitrateClass) {
            this.bitrateClass = bitrateClass;
        }

        @Override
        public final Builder bitrateClass(String bitrateClass) {
            this.bitrateClass = bitrateClass;
            return this;
        }

        @Override
        public final Builder bitrateClass(XavcHdProfileBitrateClass bitrateClass) {
            this.bitrateClass(bitrateClass == null ? null : bitrateClass.toString());
            return this;
        }

        public final String getFlickerAdaptiveQuantization() {
            return flickerAdaptiveQuantization;
        }

        public final void setFlickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(XavcFlickerAdaptiveQuantization flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization(flickerAdaptiveQuantization == null ? null : flickerAdaptiveQuantization.toString());
            return this;
        }

        public final String getGopBReference() {
            return gopBReference;
        }

        public final void setGopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
        }

        @Override
        public final Builder gopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
            return this;
        }

        @Override
        public final Builder gopBReference(XavcGopBReference gopBReference) {
            this.gopBReference(gopBReference == null ? null : gopBReference.toString());
            return this;
        }

        public final Integer getGopClosedCadence() {
            return gopClosedCadence;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final Integer getHrdBufferSize() {
            return hrdBufferSize;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final String getInterlaceMode() {
            return interlaceMode;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(XavcInterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final String getQualityTuningLevel() {
            return qualityTuningLevel;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(XavcHdProfileQualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel == null ? null : qualityTuningLevel.toString());
            return this;
        }

        public final Integer getSlices() {
            return slices;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final String getTelecine() {
            return telecine;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(XavcHdProfileTelecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        @Override
        public XavcHdProfileSettings build() {
            return new XavcHdProfileSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
