/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * If your source content has EIA-608 Line 21 Data Services, enable this feature to specify what MediaConvert does with
 * the Extended Data Services (XDS) packets. You can choose to pass through XDS packets, or remove them from the output.
 * For more information about XDS, see EIA-608 Line Data Services, section 9.5.1.5 05h Content Advisory.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExtendedDataServices implements SdkPojo, Serializable,
        ToCopyableBuilder<ExtendedDataServices.Builder, ExtendedDataServices> {
    private static final SdkField<String> COPY_PROTECTION_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CopyProtectionAction").getter(getter(ExtendedDataServices::copyProtectionActionAsString))
            .setter(setter(Builder::copyProtectionAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyProtectionAction").build())
            .build();

    private static final SdkField<String> VCHIP_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VchipAction").getter(getter(ExtendedDataServices::vchipActionAsString))
            .setter(setter(Builder::vchipAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vchipAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_PROTECTION_ACTION_FIELD,
            VCHIP_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String copyProtectionAction;

    private final String vchipAction;

    private ExtendedDataServices(BuilderImpl builder) {
        this.copyProtectionAction = builder.copyProtectionAction;
        this.vchipAction = builder.vchipAction;
    }

    /**
     * The action to take on copy and redistribution control XDS packets. If you select PASSTHROUGH, packets will not be
     * changed. If you select STRIP, any packets will be removed in output captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #copyProtectionAction} will return {@link CopyProtectionAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #copyProtectionActionAsString}.
     * </p>
     * 
     * @return The action to take on copy and redistribution control XDS packets. If you select PASSTHROUGH, packets
     *         will not be changed. If you select STRIP, any packets will be removed in output captions.
     * @see CopyProtectionAction
     */
    public final CopyProtectionAction copyProtectionAction() {
        return CopyProtectionAction.fromValue(copyProtectionAction);
    }

    /**
     * The action to take on copy and redistribution control XDS packets. If you select PASSTHROUGH, packets will not be
     * changed. If you select STRIP, any packets will be removed in output captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #copyProtectionAction} will return {@link CopyProtectionAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #copyProtectionActionAsString}.
     * </p>
     * 
     * @return The action to take on copy and redistribution control XDS packets. If you select PASSTHROUGH, packets
     *         will not be changed. If you select STRIP, any packets will be removed in output captions.
     * @see CopyProtectionAction
     */
    public final String copyProtectionActionAsString() {
        return copyProtectionAction;
    }

    /**
     * The action to take on content advisory XDS packets. If you select PASSTHROUGH, packets will not be changed. If
     * you select STRIP, any packets will be removed in output captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vchipAction} will
     * return {@link VchipAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vchipActionAsString}.
     * </p>
     * 
     * @return The action to take on content advisory XDS packets. If you select PASSTHROUGH, packets will not be
     *         changed. If you select STRIP, any packets will be removed in output captions.
     * @see VchipAction
     */
    public final VchipAction vchipAction() {
        return VchipAction.fromValue(vchipAction);
    }

    /**
     * The action to take on content advisory XDS packets. If you select PASSTHROUGH, packets will not be changed. If
     * you select STRIP, any packets will be removed in output captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vchipAction} will
     * return {@link VchipAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vchipActionAsString}.
     * </p>
     * 
     * @return The action to take on content advisory XDS packets. If you select PASSTHROUGH, packets will not be
     *         changed. If you select STRIP, any packets will be removed in output captions.
     * @see VchipAction
     */
    public final String vchipActionAsString() {
        return vchipAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(copyProtectionActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vchipActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedDataServices)) {
            return false;
        }
        ExtendedDataServices other = (ExtendedDataServices) obj;
        return Objects.equals(copyProtectionActionAsString(), other.copyProtectionActionAsString())
                && Objects.equals(vchipActionAsString(), other.vchipActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExtendedDataServices").add("CopyProtectionAction", copyProtectionActionAsString())
                .add("VchipAction", vchipActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CopyProtectionAction":
            return Optional.ofNullable(clazz.cast(copyProtectionActionAsString()));
        case "VchipAction":
            return Optional.ofNullable(clazz.cast(vchipActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExtendedDataServices, T> g) {
        return obj -> g.apply((ExtendedDataServices) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExtendedDataServices> {
        /**
         * The action to take on copy and redistribution control XDS packets. If you select PASSTHROUGH, packets will
         * not be changed. If you select STRIP, any packets will be removed in output captions.
         * 
         * @param copyProtectionAction
         *        The action to take on copy and redistribution control XDS packets. If you select PASSTHROUGH, packets
         *        will not be changed. If you select STRIP, any packets will be removed in output captions.
         * @see CopyProtectionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CopyProtectionAction
         */
        Builder copyProtectionAction(String copyProtectionAction);

        /**
         * The action to take on copy and redistribution control XDS packets. If you select PASSTHROUGH, packets will
         * not be changed. If you select STRIP, any packets will be removed in output captions.
         * 
         * @param copyProtectionAction
         *        The action to take on copy and redistribution control XDS packets. If you select PASSTHROUGH, packets
         *        will not be changed. If you select STRIP, any packets will be removed in output captions.
         * @see CopyProtectionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CopyProtectionAction
         */
        Builder copyProtectionAction(CopyProtectionAction copyProtectionAction);

        /**
         * The action to take on content advisory XDS packets. If you select PASSTHROUGH, packets will not be changed.
         * If you select STRIP, any packets will be removed in output captions.
         * 
         * @param vchipAction
         *        The action to take on content advisory XDS packets. If you select PASSTHROUGH, packets will not be
         *        changed. If you select STRIP, any packets will be removed in output captions.
         * @see VchipAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VchipAction
         */
        Builder vchipAction(String vchipAction);

        /**
         * The action to take on content advisory XDS packets. If you select PASSTHROUGH, packets will not be changed.
         * If you select STRIP, any packets will be removed in output captions.
         * 
         * @param vchipAction
         *        The action to take on content advisory XDS packets. If you select PASSTHROUGH, packets will not be
         *        changed. If you select STRIP, any packets will be removed in output captions.
         * @see VchipAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VchipAction
         */
        Builder vchipAction(VchipAction vchipAction);
    }

    static final class BuilderImpl implements Builder {
        private String copyProtectionAction;

        private String vchipAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendedDataServices model) {
            copyProtectionAction(model.copyProtectionAction);
            vchipAction(model.vchipAction);
        }

        public final String getCopyProtectionAction() {
            return copyProtectionAction;
        }

        public final void setCopyProtectionAction(String copyProtectionAction) {
            this.copyProtectionAction = copyProtectionAction;
        }

        @Override
        public final Builder copyProtectionAction(String copyProtectionAction) {
            this.copyProtectionAction = copyProtectionAction;
            return this;
        }

        @Override
        public final Builder copyProtectionAction(CopyProtectionAction copyProtectionAction) {
            this.copyProtectionAction(copyProtectionAction == null ? null : copyProtectionAction.toString());
            return this;
        }

        public final String getVchipAction() {
            return vchipAction;
        }

        public final void setVchipAction(String vchipAction) {
            this.vchipAction = vchipAction;
        }

        @Override
        public final Builder vchipAction(String vchipAction) {
            this.vchipAction = vchipAction;
            return this;
        }

        @Override
        public final Builder vchipAction(VchipAction vchipAction) {
            this.vchipAction(vchipAction == null ? null : vchipAction.toString());
            return this;
        }

        @Override
        public ExtendedDataServices build() {
            return new ExtendedDataServices(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
