/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify how the transcoder determines GOP size for this output. We recommend that you have the transcoder
 * automatically choose this value for you based on characteristics of your input video. To enable this automatic
 * behavior, choose Auto and and leave GOP size blank. By default, if you don't specify GOP mode control, MediaConvert
 * will use automatic behavior. If your output group specifies HLS, DASH, or CMAF, set GOP mode control to Auto and
 * leave GOP size blank in each output in your output group. To explicitly specify the GOP length, choose Specified,
 * frames or Specified, seconds and then provide the GOP length in the related setting GOP size.
 */
@Generated("software.amazon.awssdk:codegen")
public enum H264GopSizeUnits {
    FRAMES("FRAMES"),

    SECONDS("SECONDS"),

    AUTO("AUTO"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H264GopSizeUnits> VALUE_MAP = EnumUtils.uniqueIndex(H264GopSizeUnits.class,
            H264GopSizeUnits::toString);

    private final String value;

    private H264GopSizeUnits(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H264GopSizeUnits corresponding to the value
     */
    public static H264GopSizeUnits fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H264GopSizeUnits}s
     */
    public static Set<H264GopSizeUnits> knownValues() {
        Set<H264GopSizeUnits> knownValues = EnumSet.allOf(H264GopSizeUnits.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
