/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FontScript {
    AUTOMATIC("AUTOMATIC"),
    HANS("HANS"),
    HANT("HANT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FontScript> VALUE_MAP;
    private final String value;

    private FontScript(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FontScript fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FontScript> knownValues() {
        EnumSet<FontScript> knownValues = EnumSet.allOf(FontScript.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FontScript.class, FontScript::toString);
    }
}

