/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for HLS output groups
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsSettings implements SdkPojo, Serializable, ToCopyableBuilder<HlsSettings.Builder, HlsSettings> {
    private static final SdkField<String> AUDIO_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioGroupId").getter(getter(HlsSettings::audioGroupId)).setter(setter(Builder::audioGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioGroupId").build()).build();

    private static final SdkField<String> AUDIO_ONLY_CONTAINER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioOnlyContainer").getter(getter(HlsSettings::audioOnlyContainerAsString))
            .setter(setter(Builder::audioOnlyContainer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioOnlyContainer").build())
            .build();

    private static final SdkField<String> AUDIO_RENDITION_SETS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioRenditionSets").getter(getter(HlsSettings::audioRenditionSets))
            .setter(setter(Builder::audioRenditionSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioRenditionSets").build())
            .build();

    private static final SdkField<String> AUDIO_TRACK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioTrackType").getter(getter(HlsSettings::audioTrackTypeAsString))
            .setter(setter(Builder::audioTrackType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioTrackType").build()).build();

    private static final SdkField<String> DESCRIPTIVE_VIDEO_SERVICE_FLAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DescriptiveVideoServiceFlag")
            .getter(getter(HlsSettings::descriptiveVideoServiceFlagAsString))
            .setter(setter(Builder::descriptiveVideoServiceFlag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("descriptiveVideoServiceFlag")
                    .build()).build();

    private static final SdkField<String> I_FRAME_ONLY_MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IFrameOnlyManifest").getter(getter(HlsSettings::iFrameOnlyManifestAsString))
            .setter(setter(Builder::iFrameOnlyManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iFrameOnlyManifest").build())
            .build();

    private static final SdkField<String> SEGMENT_MODIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentModifier").getter(getter(HlsSettings::segmentModifier)).setter(setter(Builder::segmentModifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentModifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_GROUP_ID_FIELD,
            AUDIO_ONLY_CONTAINER_FIELD, AUDIO_RENDITION_SETS_FIELD, AUDIO_TRACK_TYPE_FIELD, DESCRIPTIVE_VIDEO_SERVICE_FLAG_FIELD,
            I_FRAME_ONLY_MANIFEST_FIELD, SEGMENT_MODIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String audioGroupId;

    private final String audioOnlyContainer;

    private final String audioRenditionSets;

    private final String audioTrackType;

    private final String descriptiveVideoServiceFlag;

    private final String iFrameOnlyManifest;

    private final String segmentModifier;

    private HlsSettings(BuilderImpl builder) {
        this.audioGroupId = builder.audioGroupId;
        this.audioOnlyContainer = builder.audioOnlyContainer;
        this.audioRenditionSets = builder.audioRenditionSets;
        this.audioTrackType = builder.audioTrackType;
        this.descriptiveVideoServiceFlag = builder.descriptiveVideoServiceFlag;
        this.iFrameOnlyManifest = builder.iFrameOnlyManifest;
        this.segmentModifier = builder.segmentModifier;
    }

    /**
     * Specifies the group to which the audio rendition belongs.
     * 
     * @return Specifies the group to which the audio rendition belongs.
     */
    public final String audioGroupId() {
        return audioGroupId;
    }

    /**
     * Use this setting only in audio-only outputs. Choose MPEG-2 Transport Stream (M2TS) to create a file in an
     * MPEG2-TS container. Keep the default value Automatic to create an audio-only file in a raw container. Regardless
     * of the value that you specify here, if this output has video, the service will place the output into an MPEG2-TS
     * container.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioOnlyContainer} will return {@link HlsAudioOnlyContainer#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #audioOnlyContainerAsString}.
     * </p>
     * 
     * @return Use this setting only in audio-only outputs. Choose MPEG-2 Transport Stream (M2TS) to create a file in an
     *         MPEG2-TS container. Keep the default value Automatic to create an audio-only file in a raw container.
     *         Regardless of the value that you specify here, if this output has video, the service will place the
     *         output into an MPEG2-TS container.
     * @see HlsAudioOnlyContainer
     */
    public final HlsAudioOnlyContainer audioOnlyContainer() {
        return HlsAudioOnlyContainer.fromValue(audioOnlyContainer);
    }

    /**
     * Use this setting only in audio-only outputs. Choose MPEG-2 Transport Stream (M2TS) to create a file in an
     * MPEG2-TS container. Keep the default value Automatic to create an audio-only file in a raw container. Regardless
     * of the value that you specify here, if this output has video, the service will place the output into an MPEG2-TS
     * container.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioOnlyContainer} will return {@link HlsAudioOnlyContainer#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #audioOnlyContainerAsString}.
     * </p>
     * 
     * @return Use this setting only in audio-only outputs. Choose MPEG-2 Transport Stream (M2TS) to create a file in an
     *         MPEG2-TS container. Keep the default value Automatic to create an audio-only file in a raw container.
     *         Regardless of the value that you specify here, if this output has video, the service will place the
     *         output into an MPEG2-TS container.
     * @see HlsAudioOnlyContainer
     */
    public final String audioOnlyContainerAsString() {
        return audioOnlyContainer;
    }

    /**
     * List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are
     * associated to the video, separate by ','.
     * 
     * @return List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that
     *         are associated to the video, separate by ','.
     */
    public final String audioRenditionSets() {
        return audioRenditionSets;
    }

    /**
     * Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this audio-only
     * stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.
     * Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default.
     * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select,
     * Not Default Alternate rendition that the client may try to play back by default. Represented as an EXT-X-MEDIA in
     * the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the
     * client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO,
     * AUTOSELECT=NO
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioTrackType}
     * will return {@link HlsAudioTrackType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #audioTrackTypeAsString}.
     * </p>
     * 
     * @return Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this
     *         audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the
     *         HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to
     *         play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES
     *         Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by
     *         default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate
     *         Audio, not Auto Select Alternate rendition that the client will not try to play back by default.
     *         Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
     * @see HlsAudioTrackType
     */
    public final HlsAudioTrackType audioTrackType() {
        return HlsAudioTrackType.fromValue(audioTrackType);
    }

    /**
     * Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this audio-only
     * stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.
     * Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default.
     * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select,
     * Not Default Alternate rendition that the client may try to play back by default. Represented as an EXT-X-MEDIA in
     * the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the
     * client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO,
     * AUTOSELECT=NO
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioTrackType}
     * will return {@link HlsAudioTrackType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #audioTrackTypeAsString}.
     * </p>
     * 
     * @return Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this
     *         audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the
     *         HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to
     *         play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES
     *         Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by
     *         default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate
     *         Audio, not Auto Select Alternate rendition that the client will not try to play back by default.
     *         Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
     * @see HlsAudioTrackType
     */
    public final String audioTrackTypeAsString() {
        return audioTrackType;
    }

    /**
     * Specify whether to flag this audio track as descriptive video service (DVS) in your HLS parent manifest. When you
     * choose Flag, MediaConvert includes the parameter CHARACTERISTICS="public.accessibility.describes-video" in the
     * EXT-X-MEDIA entry for this track. When you keep the default choice, Don't flag, MediaConvert leaves this
     * parameter out. The DVS flag can help with accessibility on Apple devices. For more information, see the Apple
     * documentation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #descriptiveVideoServiceFlag} will return {@link HlsDescriptiveVideoServiceFlag#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #descriptiveVideoServiceFlagAsString}.
     * </p>
     * 
     * @return Specify whether to flag this audio track as descriptive video service (DVS) in your HLS parent manifest.
     *         When you choose Flag, MediaConvert includes the parameter
     *         CHARACTERISTICS="public.accessibility.describes-video" in the EXT-X-MEDIA entry for this track. When you
     *         keep the default choice, Don't flag, MediaConvert leaves this parameter out. The DVS flag can help with
     *         accessibility on Apple devices. For more information, see the Apple documentation.
     * @see HlsDescriptiveVideoServiceFlag
     */
    public final HlsDescriptiveVideoServiceFlag descriptiveVideoServiceFlag() {
        return HlsDescriptiveVideoServiceFlag.fromValue(descriptiveVideoServiceFlag);
    }

    /**
     * Specify whether to flag this audio track as descriptive video service (DVS) in your HLS parent manifest. When you
     * choose Flag, MediaConvert includes the parameter CHARACTERISTICS="public.accessibility.describes-video" in the
     * EXT-X-MEDIA entry for this track. When you keep the default choice, Don't flag, MediaConvert leaves this
     * parameter out. The DVS flag can help with accessibility on Apple devices. For more information, see the Apple
     * documentation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #descriptiveVideoServiceFlag} will return {@link HlsDescriptiveVideoServiceFlag#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #descriptiveVideoServiceFlagAsString}.
     * </p>
     * 
     * @return Specify whether to flag this audio track as descriptive video service (DVS) in your HLS parent manifest.
     *         When you choose Flag, MediaConvert includes the parameter
     *         CHARACTERISTICS="public.accessibility.describes-video" in the EXT-X-MEDIA entry for this track. When you
     *         keep the default choice, Don't flag, MediaConvert leaves this parameter out. The DVS flag can help with
     *         accessibility on Apple devices. For more information, see the Apple documentation.
     * @see HlsDescriptiveVideoServiceFlag
     */
    public final String descriptiveVideoServiceFlagAsString() {
        return descriptiveVideoServiceFlag;
    }

    /**
     * Choose Include to have MediaConvert generate a child manifest that lists only the I-frames for this rendition, in
     * addition to your regular manifest for this rendition. You might use this manifest as part of a workflow that
     * creates preview functions for your video. MediaConvert adds both the I-frame only child manifest and the regular
     * child manifest to the parent manifest. When you don't need the I-frame only child manifest, keep the default
     * value Exclude.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #iFrameOnlyManifest} will return {@link HlsIFrameOnlyManifest#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #iFrameOnlyManifestAsString}.
     * </p>
     * 
     * @return Choose Include to have MediaConvert generate a child manifest that lists only the I-frames for this
     *         rendition, in addition to your regular manifest for this rendition. You might use this manifest as part
     *         of a workflow that creates preview functions for your video. MediaConvert adds both the I-frame only
     *         child manifest and the regular child manifest to the parent manifest. When you don't need the I-frame
     *         only child manifest, keep the default value Exclude.
     * @see HlsIFrameOnlyManifest
     */
    public final HlsIFrameOnlyManifest iFrameOnlyManifest() {
        return HlsIFrameOnlyManifest.fromValue(iFrameOnlyManifest);
    }

    /**
     * Choose Include to have MediaConvert generate a child manifest that lists only the I-frames for this rendition, in
     * addition to your regular manifest for this rendition. You might use this manifest as part of a workflow that
     * creates preview functions for your video. MediaConvert adds both the I-frame only child manifest and the regular
     * child manifest to the parent manifest. When you don't need the I-frame only child manifest, keep the default
     * value Exclude.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #iFrameOnlyManifest} will return {@link HlsIFrameOnlyManifest#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #iFrameOnlyManifestAsString}.
     * </p>
     * 
     * @return Choose Include to have MediaConvert generate a child manifest that lists only the I-frames for this
     *         rendition, in addition to your regular manifest for this rendition. You might use this manifest as part
     *         of a workflow that creates preview functions for your video. MediaConvert adds both the I-frame only
     *         child manifest and the regular child manifest to the parent manifest. When you don't need the I-frame
     *         only child manifest, keep the default value Exclude.
     * @see HlsIFrameOnlyManifest
     */
    public final String iFrameOnlyManifestAsString() {
        return iFrameOnlyManifest;
    }

    /**
     * Use this setting to add an identifying string to the filename of each segment. The service adds this string
     * between the name modifier and segment index number. You can use format identifiers in the string. For more
     * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/using-variables-in-your-job-settings.html
     * 
     * @return Use this setting to add an identifying string to the filename of each segment. The service adds this
     *         string between the name modifier and segment index number. You can use format identifiers in the string.
     *         For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/using-variables-in-your-job-settings.html
     */
    public final String segmentModifier() {
        return segmentModifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(audioOnlyContainerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(audioRenditionSets());
        hashCode = 31 * hashCode + Objects.hashCode(audioTrackTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(descriptiveVideoServiceFlagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iFrameOnlyManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentModifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsSettings)) {
            return false;
        }
        HlsSettings other = (HlsSettings) obj;
        return Objects.equals(audioGroupId(), other.audioGroupId())
                && Objects.equals(audioOnlyContainerAsString(), other.audioOnlyContainerAsString())
                && Objects.equals(audioRenditionSets(), other.audioRenditionSets())
                && Objects.equals(audioTrackTypeAsString(), other.audioTrackTypeAsString())
                && Objects.equals(descriptiveVideoServiceFlagAsString(), other.descriptiveVideoServiceFlagAsString())
                && Objects.equals(iFrameOnlyManifestAsString(), other.iFrameOnlyManifestAsString())
                && Objects.equals(segmentModifier(), other.segmentModifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsSettings").add("AudioGroupId", audioGroupId())
                .add("AudioOnlyContainer", audioOnlyContainerAsString()).add("AudioRenditionSets", audioRenditionSets())
                .add("AudioTrackType", audioTrackTypeAsString())
                .add("DescriptiveVideoServiceFlag", descriptiveVideoServiceFlagAsString())
                .add("IFrameOnlyManifest", iFrameOnlyManifestAsString()).add("SegmentModifier", segmentModifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioGroupId":
            return Optional.ofNullable(clazz.cast(audioGroupId()));
        case "AudioOnlyContainer":
            return Optional.ofNullable(clazz.cast(audioOnlyContainerAsString()));
        case "AudioRenditionSets":
            return Optional.ofNullable(clazz.cast(audioRenditionSets()));
        case "AudioTrackType":
            return Optional.ofNullable(clazz.cast(audioTrackTypeAsString()));
        case "DescriptiveVideoServiceFlag":
            return Optional.ofNullable(clazz.cast(descriptiveVideoServiceFlagAsString()));
        case "IFrameOnlyManifest":
            return Optional.ofNullable(clazz.cast(iFrameOnlyManifestAsString()));
        case "SegmentModifier":
            return Optional.ofNullable(clazz.cast(segmentModifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsSettings, T> g) {
        return obj -> g.apply((HlsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsSettings> {
        /**
         * Specifies the group to which the audio rendition belongs.
         * 
         * @param audioGroupId
         *        Specifies the group to which the audio rendition belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioGroupId(String audioGroupId);

        /**
         * Use this setting only in audio-only outputs. Choose MPEG-2 Transport Stream (M2TS) to create a file in an
         * MPEG2-TS container. Keep the default value Automatic to create an audio-only file in a raw container.
         * Regardless of the value that you specify here, if this output has video, the service will place the output
         * into an MPEG2-TS container.
         * 
         * @param audioOnlyContainer
         *        Use this setting only in audio-only outputs. Choose MPEG-2 Transport Stream (M2TS) to create a file in
         *        an MPEG2-TS container. Keep the default value Automatic to create an audio-only file in a raw
         *        container. Regardless of the value that you specify here, if this output has video, the service will
         *        place the output into an MPEG2-TS container.
         * @see HlsAudioOnlyContainer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsAudioOnlyContainer
         */
        Builder audioOnlyContainer(String audioOnlyContainer);

        /**
         * Use this setting only in audio-only outputs. Choose MPEG-2 Transport Stream (M2TS) to create a file in an
         * MPEG2-TS container. Keep the default value Automatic to create an audio-only file in a raw container.
         * Regardless of the value that you specify here, if this output has video, the service will place the output
         * into an MPEG2-TS container.
         * 
         * @param audioOnlyContainer
         *        Use this setting only in audio-only outputs. Choose MPEG-2 Transport Stream (M2TS) to create a file in
         *        an MPEG2-TS container. Keep the default value Automatic to create an audio-only file in a raw
         *        container. Regardless of the value that you specify here, if this output has video, the service will
         *        place the output into an MPEG2-TS container.
         * @see HlsAudioOnlyContainer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsAudioOnlyContainer
         */
        Builder audioOnlyContainer(HlsAudioOnlyContainer audioOnlyContainer);

        /**
         * List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are
         * associated to the video, separate by ','.
         * 
         * @param audioRenditionSets
         *        List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs
         *        that are associated to the video, separate by ','.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioRenditionSets(String audioRenditionSets);

        /**
         * Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this
         * audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS
         * manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back
         * by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate
         * Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by default.
         * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto
         * Select Alternate rendition that the client will not try to play back by default. Represented as an
         * EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
         * 
         * @param audioTrackType
         *        Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this
         *        audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in
         *        the HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try
         *        to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES,
         *        AUTOSELECT=YES Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try
         *        to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO,
         *        AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the client will not try to
         *        play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
         * @see HlsAudioTrackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsAudioTrackType
         */
        Builder audioTrackType(String audioTrackType);

        /**
         * Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this
         * audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS
         * manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back
         * by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate
         * Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by default.
         * Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto
         * Select Alternate rendition that the client will not try to play back by default. Represented as an
         * EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
         * 
         * @param audioTrackType
         *        Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this
         *        audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in
         *        the HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try
         *        to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES,
         *        AUTOSELECT=YES Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try
         *        to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO,
         *        AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the client will not try to
         *        play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
         * @see HlsAudioTrackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsAudioTrackType
         */
        Builder audioTrackType(HlsAudioTrackType audioTrackType);

        /**
         * Specify whether to flag this audio track as descriptive video service (DVS) in your HLS parent manifest. When
         * you choose Flag, MediaConvert includes the parameter CHARACTERISTICS="public.accessibility.describes-video"
         * in the EXT-X-MEDIA entry for this track. When you keep the default choice, Don't flag, MediaConvert leaves
         * this parameter out. The DVS flag can help with accessibility on Apple devices. For more information, see the
         * Apple documentation.
         * 
         * @param descriptiveVideoServiceFlag
         *        Specify whether to flag this audio track as descriptive video service (DVS) in your HLS parent
         *        manifest. When you choose Flag, MediaConvert includes the parameter
         *        CHARACTERISTICS="public.accessibility.describes-video" in the EXT-X-MEDIA entry for this track. When
         *        you keep the default choice, Don't flag, MediaConvert leaves this parameter out. The DVS flag can help
         *        with accessibility on Apple devices. For more information, see the Apple documentation.
         * @see HlsDescriptiveVideoServiceFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsDescriptiveVideoServiceFlag
         */
        Builder descriptiveVideoServiceFlag(String descriptiveVideoServiceFlag);

        /**
         * Specify whether to flag this audio track as descriptive video service (DVS) in your HLS parent manifest. When
         * you choose Flag, MediaConvert includes the parameter CHARACTERISTICS="public.accessibility.describes-video"
         * in the EXT-X-MEDIA entry for this track. When you keep the default choice, Don't flag, MediaConvert leaves
         * this parameter out. The DVS flag can help with accessibility on Apple devices. For more information, see the
         * Apple documentation.
         * 
         * @param descriptiveVideoServiceFlag
         *        Specify whether to flag this audio track as descriptive video service (DVS) in your HLS parent
         *        manifest. When you choose Flag, MediaConvert includes the parameter
         *        CHARACTERISTICS="public.accessibility.describes-video" in the EXT-X-MEDIA entry for this track. When
         *        you keep the default choice, Don't flag, MediaConvert leaves this parameter out. The DVS flag can help
         *        with accessibility on Apple devices. For more information, see the Apple documentation.
         * @see HlsDescriptiveVideoServiceFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsDescriptiveVideoServiceFlag
         */
        Builder descriptiveVideoServiceFlag(HlsDescriptiveVideoServiceFlag descriptiveVideoServiceFlag);

        /**
         * Choose Include to have MediaConvert generate a child manifest that lists only the I-frames for this
         * rendition, in addition to your regular manifest for this rendition. You might use this manifest as part of a
         * workflow that creates preview functions for your video. MediaConvert adds both the I-frame only child
         * manifest and the regular child manifest to the parent manifest. When you don't need the I-frame only child
         * manifest, keep the default value Exclude.
         * 
         * @param iFrameOnlyManifest
         *        Choose Include to have MediaConvert generate a child manifest that lists only the I-frames for this
         *        rendition, in addition to your regular manifest for this rendition. You might use this manifest as
         *        part of a workflow that creates preview functions for your video. MediaConvert adds both the I-frame
         *        only child manifest and the regular child manifest to the parent manifest. When you don't need the
         *        I-frame only child manifest, keep the default value Exclude.
         * @see HlsIFrameOnlyManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsIFrameOnlyManifest
         */
        Builder iFrameOnlyManifest(String iFrameOnlyManifest);

        /**
         * Choose Include to have MediaConvert generate a child manifest that lists only the I-frames for this
         * rendition, in addition to your regular manifest for this rendition. You might use this manifest as part of a
         * workflow that creates preview functions for your video. MediaConvert adds both the I-frame only child
         * manifest and the regular child manifest to the parent manifest. When you don't need the I-frame only child
         * manifest, keep the default value Exclude.
         * 
         * @param iFrameOnlyManifest
         *        Choose Include to have MediaConvert generate a child manifest that lists only the I-frames for this
         *        rendition, in addition to your regular manifest for this rendition. You might use this manifest as
         *        part of a workflow that creates preview functions for your video. MediaConvert adds both the I-frame
         *        only child manifest and the regular child manifest to the parent manifest. When you don't need the
         *        I-frame only child manifest, keep the default value Exclude.
         * @see HlsIFrameOnlyManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsIFrameOnlyManifest
         */
        Builder iFrameOnlyManifest(HlsIFrameOnlyManifest iFrameOnlyManifest);

        /**
         * Use this setting to add an identifying string to the filename of each segment. The service adds this string
         * between the name modifier and segment index number. You can use format identifiers in the string. For more
         * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/using-variables-in-your-job-settings.html
         * 
         * @param segmentModifier
         *        Use this setting to add an identifying string to the filename of each segment. The service adds this
         *        string between the name modifier and segment index number. You can use format identifiers in the
         *        string. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/using-variables-in-your-job-settings.html
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentModifier(String segmentModifier);
    }

    static final class BuilderImpl implements Builder {
        private String audioGroupId;

        private String audioOnlyContainer;

        private String audioRenditionSets;

        private String audioTrackType;

        private String descriptiveVideoServiceFlag;

        private String iFrameOnlyManifest;

        private String segmentModifier;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsSettings model) {
            audioGroupId(model.audioGroupId);
            audioOnlyContainer(model.audioOnlyContainer);
            audioRenditionSets(model.audioRenditionSets);
            audioTrackType(model.audioTrackType);
            descriptiveVideoServiceFlag(model.descriptiveVideoServiceFlag);
            iFrameOnlyManifest(model.iFrameOnlyManifest);
            segmentModifier(model.segmentModifier);
        }

        public final String getAudioGroupId() {
            return audioGroupId;
        }

        public final void setAudioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
        }

        @Override
        public final Builder audioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
            return this;
        }

        public final String getAudioOnlyContainer() {
            return audioOnlyContainer;
        }

        public final void setAudioOnlyContainer(String audioOnlyContainer) {
            this.audioOnlyContainer = audioOnlyContainer;
        }

        @Override
        public final Builder audioOnlyContainer(String audioOnlyContainer) {
            this.audioOnlyContainer = audioOnlyContainer;
            return this;
        }

        @Override
        public final Builder audioOnlyContainer(HlsAudioOnlyContainer audioOnlyContainer) {
            this.audioOnlyContainer(audioOnlyContainer == null ? null : audioOnlyContainer.toString());
            return this;
        }

        public final String getAudioRenditionSets() {
            return audioRenditionSets;
        }

        public final void setAudioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
        }

        @Override
        public final Builder audioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
            return this;
        }

        public final String getAudioTrackType() {
            return audioTrackType;
        }

        public final void setAudioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
        }

        @Override
        public final Builder audioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
            return this;
        }

        @Override
        public final Builder audioTrackType(HlsAudioTrackType audioTrackType) {
            this.audioTrackType(audioTrackType == null ? null : audioTrackType.toString());
            return this;
        }

        public final String getDescriptiveVideoServiceFlag() {
            return descriptiveVideoServiceFlag;
        }

        public final void setDescriptiveVideoServiceFlag(String descriptiveVideoServiceFlag) {
            this.descriptiveVideoServiceFlag = descriptiveVideoServiceFlag;
        }

        @Override
        public final Builder descriptiveVideoServiceFlag(String descriptiveVideoServiceFlag) {
            this.descriptiveVideoServiceFlag = descriptiveVideoServiceFlag;
            return this;
        }

        @Override
        public final Builder descriptiveVideoServiceFlag(HlsDescriptiveVideoServiceFlag descriptiveVideoServiceFlag) {
            this.descriptiveVideoServiceFlag(descriptiveVideoServiceFlag == null ? null : descriptiveVideoServiceFlag.toString());
            return this;
        }

        public final String getIFrameOnlyManifest() {
            return iFrameOnlyManifest;
        }

        public final void setIFrameOnlyManifest(String iFrameOnlyManifest) {
            this.iFrameOnlyManifest = iFrameOnlyManifest;
        }

        @Override
        public final Builder iFrameOnlyManifest(String iFrameOnlyManifest) {
            this.iFrameOnlyManifest = iFrameOnlyManifest;
            return this;
        }

        @Override
        public final Builder iFrameOnlyManifest(HlsIFrameOnlyManifest iFrameOnlyManifest) {
            this.iFrameOnlyManifest(iFrameOnlyManifest == null ? null : iFrameOnlyManifest.toString());
            return this;
        }

        public final String getSegmentModifier() {
            return segmentModifier;
        }

        public final void setSegmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
        }

        @Override
        public final Builder segmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
            return this;
        }

        @Override
        public HlsSettings build() {
            return new HlsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
