/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify whether MediaConvert automatically attempts to prevent decoder buffer underflows in your transport stream
 * output. Use if you are seeing decoder buffer underflows in your output and are unable to increase your transport
 * stream's bitrate. For most workflows: We recommend that you keep the default value, Disabled. To prevent decoder
 * buffer underflows in your output, when possible: Choose Enabled. Note that if MediaConvert prevents a decoder buffer
 * underflow in your output, output video quality is reduced and your job will take longer to complete.
 */
@Generated("software.amazon.awssdk:codegen")
public enum M2tsPreventBufferUnderflow {
    DISABLED("DISABLED"),

    ENABLED("ENABLED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, M2tsPreventBufferUnderflow> VALUE_MAP = EnumUtils.uniqueIndex(
            M2tsPreventBufferUnderflow.class, M2tsPreventBufferUnderflow::toString);

    private final String value;

    private M2tsPreventBufferUnderflow(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return M2tsPreventBufferUnderflow corresponding to the value
     */
    public static M2tsPreventBufferUnderflow fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link M2tsPreventBufferUnderflow}s
     */
    public static Set<M2tsPreventBufferUnderflow> knownValues() {
        Set<M2tsPreventBufferUnderflow> knownValues = EnumSet.allOf(M2tsPreventBufferUnderflow.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
