/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use Audio selectors to specify a track or set of tracks from the input that you will use in your outputs. You can use
 * multiple Audio selectors per input.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioSelector implements SdkPojo, Serializable, ToCopyableBuilder<AudioSelector.Builder, AudioSelector> {
    private static final SdkField<String> AUDIO_DURATION_CORRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioDurationCorrection").getter(getter(AudioSelector::audioDurationCorrectionAsString))
            .setter(setter(Builder::audioDurationCorrection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDurationCorrection").build())
            .build();

    private static final SdkField<String> CUSTOM_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomLanguageCode").getter(getter(AudioSelector::customLanguageCode))
            .setter(setter(Builder::customLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLanguageCode").build())
            .build();

    private static final SdkField<String> DEFAULT_SELECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultSelection").getter(getter(AudioSelector::defaultSelectionAsString))
            .setter(setter(Builder::defaultSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultSelection").build()).build();

    private static final SdkField<String> EXTERNAL_AUDIO_FILE_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalAudioFileInput").getter(getter(AudioSelector::externalAudioFileInput))
            .setter(setter(Builder::externalAudioFileInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalAudioFileInput").build())
            .build();

    private static final SdkField<HlsRenditionGroupSettings> HLS_RENDITION_GROUP_SETTINGS_FIELD = SdkField
            .<HlsRenditionGroupSettings> builder(MarshallingType.SDK_POJO).memberName("HlsRenditionGroupSettings")
            .getter(getter(AudioSelector::hlsRenditionGroupSettings)).setter(setter(Builder::hlsRenditionGroupSettings))
            .constructor(HlsRenditionGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsRenditionGroupSettings").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(AudioSelector::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()).build();

    private static final SdkField<Integer> OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Offset").getter(getter(AudioSelector::offset)).setter(setter(Builder::offset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()).build();

    private static final SdkField<List<Integer>> PIDS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Pids")
            .getter(getter(AudioSelector::pids))
            .setter(setter(Builder::pids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PROGRAM_SELECTION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgramSelection").getter(getter(AudioSelector::programSelection))
            .setter(setter(Builder::programSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programSelection").build()).build();

    private static final SdkField<RemixSettings> REMIX_SETTINGS_FIELD = SdkField
            .<RemixSettings> builder(MarshallingType.SDK_POJO).memberName("RemixSettings")
            .getter(getter(AudioSelector::remixSettings)).setter(setter(Builder::remixSettings))
            .constructor(RemixSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remixSettings").build()).build();

    private static final SdkField<String> SELECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectorType").getter(getter(AudioSelector::selectorTypeAsString)).setter(setter(Builder::selectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectorType").build()).build();

    private static final SdkField<List<Integer>> TRACKS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Tracks")
            .getter(getter(AudioSelector::tracks))
            .setter(setter(Builder::tracks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUDIO_DURATION_CORRECTION_FIELD, CUSTOM_LANGUAGE_CODE_FIELD, DEFAULT_SELECTION_FIELD,
            EXTERNAL_AUDIO_FILE_INPUT_FIELD, HLS_RENDITION_GROUP_SETTINGS_FIELD, LANGUAGE_CODE_FIELD, OFFSET_FIELD, PIDS_FIELD,
            PROGRAM_SELECTION_FIELD, REMIX_SETTINGS_FIELD, SELECTOR_TYPE_FIELD, TRACKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String audioDurationCorrection;

    private final String customLanguageCode;

    private final String defaultSelection;

    private final String externalAudioFileInput;

    private final HlsRenditionGroupSettings hlsRenditionGroupSettings;

    private final String languageCode;

    private final Integer offset;

    private final List<Integer> pids;

    private final Integer programSelection;

    private final RemixSettings remixSettings;

    private final String selectorType;

    private final List<Integer> tracks;

    private AudioSelector(BuilderImpl builder) {
        this.audioDurationCorrection = builder.audioDurationCorrection;
        this.customLanguageCode = builder.customLanguageCode;
        this.defaultSelection = builder.defaultSelection;
        this.externalAudioFileInput = builder.externalAudioFileInput;
        this.hlsRenditionGroupSettings = builder.hlsRenditionGroupSettings;
        this.languageCode = builder.languageCode;
        this.offset = builder.offset;
        this.pids = builder.pids;
        this.programSelection = builder.programSelection;
        this.remixSettings = builder.remixSettings;
        this.selectorType = builder.selectorType;
        this.tracks = builder.tracks;
    }

    /**
     * Apply audio timing corrections to help synchronize audio and video in your output. To apply timing corrections,
     * your input must meet the following requirements: * Container: MP4, or MOV, with an accurate time-to-sample (STTS)
     * table. * Audio track: AAC. Choose from the following audio timing correction settings: * Disabled (Default):
     * Apply no correction. * Auto: Recommended for most inputs. MediaConvert analyzes the audio timing in your input
     * and determines which correction setting to use, if needed. * Track: Adjust the duration of each audio frame by a
     * constant amount to align the audio track length with STTS duration. Track-level correction does not affect pitch,
     * and is recommended for tonal audio content such as music. * Frame: Adjust the duration of each audio frame by a
     * variable amount to align audio frames with STTS timestamps. No corrections are made to already-aligned frames.
     * Frame-level correction may affect the pitch of corrected frames, and is recommended for atonal audio content such
     * as speech or percussion. * Force: Apply audio duration correction, either Track or Frame depending on your input,
     * regardless of the accuracy of your input's STTS table. Your output audio and video may not be aligned or it may
     * contain audio artifacts.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioDurationCorrection} will return {@link AudioDurationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #audioDurationCorrectionAsString}.
     * </p>
     * 
     * @return Apply audio timing corrections to help synchronize audio and video in your output. To apply timing
     *         corrections, your input must meet the following requirements: * Container: MP4, or MOV, with an accurate
     *         time-to-sample (STTS) table. * Audio track: AAC. Choose from the following audio timing correction
     *         settings: * Disabled (Default): Apply no correction. * Auto: Recommended for most inputs. MediaConvert
     *         analyzes the audio timing in your input and determines which correction setting to use, if needed. *
     *         Track: Adjust the duration of each audio frame by a constant amount to align the audio track length with
     *         STTS duration. Track-level correction does not affect pitch, and is recommended for tonal audio content
     *         such as music. * Frame: Adjust the duration of each audio frame by a variable amount to align audio
     *         frames with STTS timestamps. No corrections are made to already-aligned frames. Frame-level correction
     *         may affect the pitch of corrected frames, and is recommended for atonal audio content such as speech or
     *         percussion. * Force: Apply audio duration correction, either Track or Frame depending on your input,
     *         regardless of the accuracy of your input's STTS table. Your output audio and video may not be aligned or
     *         it may contain audio artifacts.
     * @see AudioDurationCorrection
     */
    public final AudioDurationCorrection audioDurationCorrection() {
        return AudioDurationCorrection.fromValue(audioDurationCorrection);
    }

    /**
     * Apply audio timing corrections to help synchronize audio and video in your output. To apply timing corrections,
     * your input must meet the following requirements: * Container: MP4, or MOV, with an accurate time-to-sample (STTS)
     * table. * Audio track: AAC. Choose from the following audio timing correction settings: * Disabled (Default):
     * Apply no correction. * Auto: Recommended for most inputs. MediaConvert analyzes the audio timing in your input
     * and determines which correction setting to use, if needed. * Track: Adjust the duration of each audio frame by a
     * constant amount to align the audio track length with STTS duration. Track-level correction does not affect pitch,
     * and is recommended for tonal audio content such as music. * Frame: Adjust the duration of each audio frame by a
     * variable amount to align audio frames with STTS timestamps. No corrections are made to already-aligned frames.
     * Frame-level correction may affect the pitch of corrected frames, and is recommended for atonal audio content such
     * as speech or percussion. * Force: Apply audio duration correction, either Track or Frame depending on your input,
     * regardless of the accuracy of your input's STTS table. Your output audio and video may not be aligned or it may
     * contain audio artifacts.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioDurationCorrection} will return {@link AudioDurationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #audioDurationCorrectionAsString}.
     * </p>
     * 
     * @return Apply audio timing corrections to help synchronize audio and video in your output. To apply timing
     *         corrections, your input must meet the following requirements: * Container: MP4, or MOV, with an accurate
     *         time-to-sample (STTS) table. * Audio track: AAC. Choose from the following audio timing correction
     *         settings: * Disabled (Default): Apply no correction. * Auto: Recommended for most inputs. MediaConvert
     *         analyzes the audio timing in your input and determines which correction setting to use, if needed. *
     *         Track: Adjust the duration of each audio frame by a constant amount to align the audio track length with
     *         STTS duration. Track-level correction does not affect pitch, and is recommended for tonal audio content
     *         such as music. * Frame: Adjust the duration of each audio frame by a variable amount to align audio
     *         frames with STTS timestamps. No corrections are made to already-aligned frames. Frame-level correction
     *         may affect the pitch of corrected frames, and is recommended for atonal audio content such as speech or
     *         percussion. * Force: Apply audio duration correction, either Track or Frame depending on your input,
     *         regardless of the accuracy of your input's STTS table. Your output audio and video may not be aligned or
     *         it may contain audio artifacts.
     * @see AudioDurationCorrection
     */
    public final String audioDurationCorrectionAsString() {
        return audioDurationCorrection;
    }

    /**
     * Selects a specific language code from within an audio source, using the ISO 639-2 or ISO 639-3 three-letter
     * language code
     * 
     * @return Selects a specific language code from within an audio source, using the ISO 639-2 or ISO 639-3
     *         three-letter language code
     */
    public final String customLanguageCode() {
        return customLanguageCode;
    }

    /**
     * Enable this setting on one audio selector to set it as the default for the job. The service uses this default for
     * outputs where it can't find the specified input audio. If you don't set a default, those outputs have no audio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultSelection}
     * will return {@link AudioDefaultSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultSelectionAsString}.
     * </p>
     * 
     * @return Enable this setting on one audio selector to set it as the default for the job. The service uses this
     *         default for outputs where it can't find the specified input audio. If you don't set a default, those
     *         outputs have no audio.
     * @see AudioDefaultSelection
     */
    public final AudioDefaultSelection defaultSelection() {
        return AudioDefaultSelection.fromValue(defaultSelection);
    }

    /**
     * Enable this setting on one audio selector to set it as the default for the job. The service uses this default for
     * outputs where it can't find the specified input audio. If you don't set a default, those outputs have no audio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultSelection}
     * will return {@link AudioDefaultSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultSelectionAsString}.
     * </p>
     * 
     * @return Enable this setting on one audio selector to set it as the default for the job. The service uses this
     *         default for outputs where it can't find the specified input audio. If you don't set a default, those
     *         outputs have no audio.
     * @see AudioDefaultSelection
     */
    public final String defaultSelectionAsString() {
        return defaultSelection;
    }

    /**
     * Specifies audio data from an external file source.
     * 
     * @return Specifies audio data from an external file source.
     */
    public final String externalAudioFileInput() {
        return externalAudioFileInput;
    }

    /**
     * Settings specific to audio sources in an HLS alternate rendition group. Specify the properties (renditionGroupId,
     * renditionName or renditionLanguageCode) to identify the unique audio track among the alternative rendition groups
     * present in the HLS manifest. If no unique track is found, or multiple tracks match the properties provided, the
     * job fails. If no properties in hlsRenditionGroupSettings are specified, the default audio track within the video
     * segment is chosen. If there is no audio within video segment, the alternative audio with DEFAULT=YES is chosen
     * instead.
     * 
     * @return Settings specific to audio sources in an HLS alternate rendition group. Specify the properties
     *         (renditionGroupId, renditionName or renditionLanguageCode) to identify the unique audio track among the
     *         alternative rendition groups present in the HLS manifest. If no unique track is found, or multiple tracks
     *         match the properties provided, the job fails. If no properties in hlsRenditionGroupSettings are
     *         specified, the default audio track within the video segment is chosen. If there is no audio within video
     *         segment, the alternative audio with DEFAULT=YES is chosen instead.
     */
    public final HlsRenditionGroupSettings hlsRenditionGroupSettings() {
        return hlsRenditionGroupSettings;
    }

    /**
     * Selects a specific language code from within an audio source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Selects a specific language code from within an audio source.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * Selects a specific language code from within an audio source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Selects a specific language code from within an audio source.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * Specifies a time delta in milliseconds to offset the audio from the input video.
     * 
     * @return Specifies a time delta in milliseconds to offset the audio from the input video.
     */
    public final Integer offset() {
        return offset;
    }

    /**
     * For responses, this returns true if the service returned a value for the Pids property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPids() {
        return pids != null && !(pids instanceof SdkAutoConstructList);
    }

    /**
     * Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPids} method.
     * </p>
     * 
     * @return Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
     */
    public final List<Integer> pids() {
        return pids;
    }

    /**
     * Use this setting for input streams that contain Dolby E, to have the service extract specific program data from
     * the track. To select multiple programs, create multiple selectors with the same Track and different Program
     * numbers. In the console, this setting is visible when you set Selector type to Track. Choose the program number
     * from the dropdown list. If your input file has incorrect metadata, you can choose All channels instead of a
     * program number to have the service ignore the program IDs and include all the programs in the track.
     * 
     * @return Use this setting for input streams that contain Dolby E, to have the service extract specific program
     *         data from the track. To select multiple programs, create multiple selectors with the same Track and
     *         different Program numbers. In the console, this setting is visible when you set Selector type to Track.
     *         Choose the program number from the dropdown list. If your input file has incorrect metadata, you can
     *         choose All channels instead of a program number to have the service ignore the program IDs and include
     *         all the programs in the track.
     */
    public final Integer programSelection() {
        return programSelection;
    }

    /**
     * Use these settings to reorder the audio channels of one input to match those of another input. This allows you to
     * combine the two files into a single output, one after the other.
     * 
     * @return Use these settings to reorder the audio channels of one input to match those of another input. This
     *         allows you to combine the two files into a single output, one after the other.
     */
    public final RemixSettings remixSettings() {
        return remixSettings;
    }

    /**
     * Specifies the type of the audio selector.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectorType} will
     * return {@link AudioSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #selectorTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the audio selector.
     * @see AudioSelectorType
     */
    public final AudioSelectorType selectorType() {
        return AudioSelectorType.fromValue(selectorType);
    }

    /**
     * Specifies the type of the audio selector.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectorType} will
     * return {@link AudioSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #selectorTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the audio selector.
     * @see AudioSelectorType
     */
    public final String selectorTypeAsString() {
        return selectorType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tracks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTracks() {
        return tracks != null && !(tracks instanceof SdkAutoConstructList);
    }

    /**
     * Identify a track from the input audio to include in this selector by entering the track index number. To include
     * several tracks in a single audio selector, specify multiple tracks as follows. Using the console, enter a
     * comma-separated list. For example, type "1,2,3" to include tracks 1 through 3.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTracks} method.
     * </p>
     * 
     * @return Identify a track from the input audio to include in this selector by entering the track index number. To
     *         include several tracks in a single audio selector, specify multiple tracks as follows. Using the console,
     *         enter a comma-separated list. For example, type "1,2,3" to include tracks 1 through 3.
     */
    public final List<Integer> tracks() {
        return tracks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioDurationCorrectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(externalAudioFileInput());
        hashCode = 31 * hashCode + Objects.hashCode(hlsRenditionGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        hashCode = 31 * hashCode + Objects.hashCode(hasPids() ? pids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(programSelection());
        hashCode = 31 * hashCode + Objects.hashCode(remixSettings());
        hashCode = 31 * hashCode + Objects.hashCode(selectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTracks() ? tracks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSelector)) {
            return false;
        }
        AudioSelector other = (AudioSelector) obj;
        return Objects.equals(audioDurationCorrectionAsString(), other.audioDurationCorrectionAsString())
                && Objects.equals(customLanguageCode(), other.customLanguageCode())
                && Objects.equals(defaultSelectionAsString(), other.defaultSelectionAsString())
                && Objects.equals(externalAudioFileInput(), other.externalAudioFileInput())
                && Objects.equals(hlsRenditionGroupSettings(), other.hlsRenditionGroupSettings())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(offset(), other.offset()) && hasPids() == other.hasPids()
                && Objects.equals(pids(), other.pids()) && Objects.equals(programSelection(), other.programSelection())
                && Objects.equals(remixSettings(), other.remixSettings())
                && Objects.equals(selectorTypeAsString(), other.selectorTypeAsString()) && hasTracks() == other.hasTracks()
                && Objects.equals(tracks(), other.tracks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioSelector").add("AudioDurationCorrection", audioDurationCorrectionAsString())
                .add("CustomLanguageCode", customLanguageCode()).add("DefaultSelection", defaultSelectionAsString())
                .add("ExternalAudioFileInput", externalAudioFileInput())
                .add("HlsRenditionGroupSettings", hlsRenditionGroupSettings()).add("LanguageCode", languageCodeAsString())
                .add("Offset", offset()).add("Pids", hasPids() ? pids() : null).add("ProgramSelection", programSelection())
                .add("RemixSettings", remixSettings()).add("SelectorType", selectorTypeAsString())
                .add("Tracks", hasTracks() ? tracks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioDurationCorrection":
            return Optional.ofNullable(clazz.cast(audioDurationCorrectionAsString()));
        case "CustomLanguageCode":
            return Optional.ofNullable(clazz.cast(customLanguageCode()));
        case "DefaultSelection":
            return Optional.ofNullable(clazz.cast(defaultSelectionAsString()));
        case "ExternalAudioFileInput":
            return Optional.ofNullable(clazz.cast(externalAudioFileInput()));
        case "HlsRenditionGroupSettings":
            return Optional.ofNullable(clazz.cast(hlsRenditionGroupSettings()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "Offset":
            return Optional.ofNullable(clazz.cast(offset()));
        case "Pids":
            return Optional.ofNullable(clazz.cast(pids()));
        case "ProgramSelection":
            return Optional.ofNullable(clazz.cast(programSelection()));
        case "RemixSettings":
            return Optional.ofNullable(clazz.cast(remixSettings()));
        case "SelectorType":
            return Optional.ofNullable(clazz.cast(selectorTypeAsString()));
        case "Tracks":
            return Optional.ofNullable(clazz.cast(tracks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioSelector, T> g) {
        return obj -> g.apply((AudioSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioSelector> {
        /**
         * Apply audio timing corrections to help synchronize audio and video in your output. To apply timing
         * corrections, your input must meet the following requirements: * Container: MP4, or MOV, with an accurate
         * time-to-sample (STTS) table. * Audio track: AAC. Choose from the following audio timing correction settings:
         * * Disabled (Default): Apply no correction. * Auto: Recommended for most inputs. MediaConvert analyzes the
         * audio timing in your input and determines which correction setting to use, if needed. * Track: Adjust the
         * duration of each audio frame by a constant amount to align the audio track length with STTS duration.
         * Track-level correction does not affect pitch, and is recommended for tonal audio content such as music. *
         * Frame: Adjust the duration of each audio frame by a variable amount to align audio frames with STTS
         * timestamps. No corrections are made to already-aligned frames. Frame-level correction may affect the pitch of
         * corrected frames, and is recommended for atonal audio content such as speech or percussion. * Force: Apply
         * audio duration correction, either Track or Frame depending on your input, regardless of the accuracy of your
         * input's STTS table. Your output audio and video may not be aligned or it may contain audio artifacts.
         * 
         * @param audioDurationCorrection
         *        Apply audio timing corrections to help synchronize audio and video in your output. To apply timing
         *        corrections, your input must meet the following requirements: * Container: MP4, or MOV, with an
         *        accurate time-to-sample (STTS) table. * Audio track: AAC. Choose from the following audio timing
         *        correction settings: * Disabled (Default): Apply no correction. * Auto: Recommended for most inputs.
         *        MediaConvert analyzes the audio timing in your input and determines which correction setting to use,
         *        if needed. * Track: Adjust the duration of each audio frame by a constant amount to align the audio
         *        track length with STTS duration. Track-level correction does not affect pitch, and is recommended for
         *        tonal audio content such as music. * Frame: Adjust the duration of each audio frame by a variable
         *        amount to align audio frames with STTS timestamps. No corrections are made to already-aligned frames.
         *        Frame-level correction may affect the pitch of corrected frames, and is recommended for atonal audio
         *        content such as speech or percussion. * Force: Apply audio duration correction, either Track or Frame
         *        depending on your input, regardless of the accuracy of your input's STTS table. Your output audio and
         *        video may not be aligned or it may contain audio artifacts.
         * @see AudioDurationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioDurationCorrection
         */
        Builder audioDurationCorrection(String audioDurationCorrection);

        /**
         * Apply audio timing corrections to help synchronize audio and video in your output. To apply timing
         * corrections, your input must meet the following requirements: * Container: MP4, or MOV, with an accurate
         * time-to-sample (STTS) table. * Audio track: AAC. Choose from the following audio timing correction settings:
         * * Disabled (Default): Apply no correction. * Auto: Recommended for most inputs. MediaConvert analyzes the
         * audio timing in your input and determines which correction setting to use, if needed. * Track: Adjust the
         * duration of each audio frame by a constant amount to align the audio track length with STTS duration.
         * Track-level correction does not affect pitch, and is recommended for tonal audio content such as music. *
         * Frame: Adjust the duration of each audio frame by a variable amount to align audio frames with STTS
         * timestamps. No corrections are made to already-aligned frames. Frame-level correction may affect the pitch of
         * corrected frames, and is recommended for atonal audio content such as speech or percussion. * Force: Apply
         * audio duration correction, either Track or Frame depending on your input, regardless of the accuracy of your
         * input's STTS table. Your output audio and video may not be aligned or it may contain audio artifacts.
         * 
         * @param audioDurationCorrection
         *        Apply audio timing corrections to help synchronize audio and video in your output. To apply timing
         *        corrections, your input must meet the following requirements: * Container: MP4, or MOV, with an
         *        accurate time-to-sample (STTS) table. * Audio track: AAC. Choose from the following audio timing
         *        correction settings: * Disabled (Default): Apply no correction. * Auto: Recommended for most inputs.
         *        MediaConvert analyzes the audio timing in your input and determines which correction setting to use,
         *        if needed. * Track: Adjust the duration of each audio frame by a constant amount to align the audio
         *        track length with STTS duration. Track-level correction does not affect pitch, and is recommended for
         *        tonal audio content such as music. * Frame: Adjust the duration of each audio frame by a variable
         *        amount to align audio frames with STTS timestamps. No corrections are made to already-aligned frames.
         *        Frame-level correction may affect the pitch of corrected frames, and is recommended for atonal audio
         *        content such as speech or percussion. * Force: Apply audio duration correction, either Track or Frame
         *        depending on your input, regardless of the accuracy of your input's STTS table. Your output audio and
         *        video may not be aligned or it may contain audio artifacts.
         * @see AudioDurationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioDurationCorrection
         */
        Builder audioDurationCorrection(AudioDurationCorrection audioDurationCorrection);

        /**
         * Selects a specific language code from within an audio source, using the ISO 639-2 or ISO 639-3 three-letter
         * language code
         * 
         * @param customLanguageCode
         *        Selects a specific language code from within an audio source, using the ISO 639-2 or ISO 639-3
         *        three-letter language code
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLanguageCode(String customLanguageCode);

        /**
         * Enable this setting on one audio selector to set it as the default for the job. The service uses this default
         * for outputs where it can't find the specified input audio. If you don't set a default, those outputs have no
         * audio.
         * 
         * @param defaultSelection
         *        Enable this setting on one audio selector to set it as the default for the job. The service uses this
         *        default for outputs where it can't find the specified input audio. If you don't set a default, those
         *        outputs have no audio.
         * @see AudioDefaultSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioDefaultSelection
         */
        Builder defaultSelection(String defaultSelection);

        /**
         * Enable this setting on one audio selector to set it as the default for the job. The service uses this default
         * for outputs where it can't find the specified input audio. If you don't set a default, those outputs have no
         * audio.
         * 
         * @param defaultSelection
         *        Enable this setting on one audio selector to set it as the default for the job. The service uses this
         *        default for outputs where it can't find the specified input audio. If you don't set a default, those
         *        outputs have no audio.
         * @see AudioDefaultSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioDefaultSelection
         */
        Builder defaultSelection(AudioDefaultSelection defaultSelection);

        /**
         * Specifies audio data from an external file source.
         * 
         * @param externalAudioFileInput
         *        Specifies audio data from an external file source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalAudioFileInput(String externalAudioFileInput);

        /**
         * Settings specific to audio sources in an HLS alternate rendition group. Specify the properties
         * (renditionGroupId, renditionName or renditionLanguageCode) to identify the unique audio track among the
         * alternative rendition groups present in the HLS manifest. If no unique track is found, or multiple tracks
         * match the properties provided, the job fails. If no properties in hlsRenditionGroupSettings are specified,
         * the default audio track within the video segment is chosen. If there is no audio within video segment, the
         * alternative audio with DEFAULT=YES is chosen instead.
         * 
         * @param hlsRenditionGroupSettings
         *        Settings specific to audio sources in an HLS alternate rendition group. Specify the properties
         *        (renditionGroupId, renditionName or renditionLanguageCode) to identify the unique audio track among
         *        the alternative rendition groups present in the HLS manifest. If no unique track is found, or multiple
         *        tracks match the properties provided, the job fails. If no properties in hlsRenditionGroupSettings are
         *        specified, the default audio track within the video segment is chosen. If there is no audio within
         *        video segment, the alternative audio with DEFAULT=YES is chosen instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsRenditionGroupSettings(HlsRenditionGroupSettings hlsRenditionGroupSettings);

        /**
         * Settings specific to audio sources in an HLS alternate rendition group. Specify the properties
         * (renditionGroupId, renditionName or renditionLanguageCode) to identify the unique audio track among the
         * alternative rendition groups present in the HLS manifest. If no unique track is found, or multiple tracks
         * match the properties provided, the job fails. If no properties in hlsRenditionGroupSettings are specified,
         * the default audio track within the video segment is chosen. If there is no audio within video segment, the
         * alternative audio with DEFAULT=YES is chosen instead. This is a convenience method that creates an instance
         * of the {@link HlsRenditionGroupSettings.Builder} avoiding the need to create one manually via
         * {@link HlsRenditionGroupSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HlsRenditionGroupSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #hlsRenditionGroupSettings(HlsRenditionGroupSettings)}.
         * 
         * @param hlsRenditionGroupSettings
         *        a consumer that will call methods on {@link HlsRenditionGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsRenditionGroupSettings(HlsRenditionGroupSettings)
         */
        default Builder hlsRenditionGroupSettings(Consumer<HlsRenditionGroupSettings.Builder> hlsRenditionGroupSettings) {
            return hlsRenditionGroupSettings(HlsRenditionGroupSettings.builder().applyMutation(hlsRenditionGroupSettings).build());
        }

        /**
         * Selects a specific language code from within an audio source.
         * 
         * @param languageCode
         *        Selects a specific language code from within an audio source.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * Selects a specific language code from within an audio source.
         * 
         * @param languageCode
         *        Selects a specific language code from within an audio source.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * Specifies a time delta in milliseconds to offset the audio from the input video.
         * 
         * @param offset
         *        Specifies a time delta in milliseconds to offset the audio from the input video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(Integer offset);

        /**
         * Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
         * 
         * @param pids
         *        Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pids(Collection<Integer> pids);

        /**
         * Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
         * 
         * @param pids
         *        Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pids(Integer... pids);

        /**
         * Use this setting for input streams that contain Dolby E, to have the service extract specific program data
         * from the track. To select multiple programs, create multiple selectors with the same Track and different
         * Program numbers. In the console, this setting is visible when you set Selector type to Track. Choose the
         * program number from the dropdown list. If your input file has incorrect metadata, you can choose All channels
         * instead of a program number to have the service ignore the program IDs and include all the programs in the
         * track.
         * 
         * @param programSelection
         *        Use this setting for input streams that contain Dolby E, to have the service extract specific program
         *        data from the track. To select multiple programs, create multiple selectors with the same Track and
         *        different Program numbers. In the console, this setting is visible when you set Selector type to
         *        Track. Choose the program number from the dropdown list. If your input file has incorrect metadata,
         *        you can choose All channels instead of a program number to have the service ignore the program IDs and
         *        include all the programs in the track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programSelection(Integer programSelection);

        /**
         * Use these settings to reorder the audio channels of one input to match those of another input. This allows
         * you to combine the two files into a single output, one after the other.
         * 
         * @param remixSettings
         *        Use these settings to reorder the audio channels of one input to match those of another input. This
         *        allows you to combine the two files into a single output, one after the other.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remixSettings(RemixSettings remixSettings);

        /**
         * Use these settings to reorder the audio channels of one input to match those of another input. This allows
         * you to combine the two files into a single output, one after the other. This is a convenience method that
         * creates an instance of the {@link RemixSettings.Builder} avoiding the need to create one manually via
         * {@link RemixSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RemixSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #remixSettings(RemixSettings)}.
         * 
         * @param remixSettings
         *        a consumer that will call methods on {@link RemixSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remixSettings(RemixSettings)
         */
        default Builder remixSettings(Consumer<RemixSettings.Builder> remixSettings) {
            return remixSettings(RemixSettings.builder().applyMutation(remixSettings).build());
        }

        /**
         * Specifies the type of the audio selector.
         * 
         * @param selectorType
         *        Specifies the type of the audio selector.
         * @see AudioSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioSelectorType
         */
        Builder selectorType(String selectorType);

        /**
         * Specifies the type of the audio selector.
         * 
         * @param selectorType
         *        Specifies the type of the audio selector.
         * @see AudioSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioSelectorType
         */
        Builder selectorType(AudioSelectorType selectorType);

        /**
         * Identify a track from the input audio to include in this selector by entering the track index number. To
         * include several tracks in a single audio selector, specify multiple tracks as follows. Using the console,
         * enter a comma-separated list. For example, type "1,2,3" to include tracks 1 through 3.
         * 
         * @param tracks
         *        Identify a track from the input audio to include in this selector by entering the track index number.
         *        To include several tracks in a single audio selector, specify multiple tracks as follows. Using the
         *        console, enter a comma-separated list. For example, type "1,2,3" to include tracks 1 through 3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracks(Collection<Integer> tracks);

        /**
         * Identify a track from the input audio to include in this selector by entering the track index number. To
         * include several tracks in a single audio selector, specify multiple tracks as follows. Using the console,
         * enter a comma-separated list. For example, type "1,2,3" to include tracks 1 through 3.
         * 
         * @param tracks
         *        Identify a track from the input audio to include in this selector by entering the track index number.
         *        To include several tracks in a single audio selector, specify multiple tracks as follows. Using the
         *        console, enter a comma-separated list. For example, type "1,2,3" to include tracks 1 through 3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracks(Integer... tracks);
    }

    static final class BuilderImpl implements Builder {
        private String audioDurationCorrection;

        private String customLanguageCode;

        private String defaultSelection;

        private String externalAudioFileInput;

        private HlsRenditionGroupSettings hlsRenditionGroupSettings;

        private String languageCode;

        private Integer offset;

        private List<Integer> pids = DefaultSdkAutoConstructList.getInstance();

        private Integer programSelection;

        private RemixSettings remixSettings;

        private String selectorType;

        private List<Integer> tracks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSelector model) {
            audioDurationCorrection(model.audioDurationCorrection);
            customLanguageCode(model.customLanguageCode);
            defaultSelection(model.defaultSelection);
            externalAudioFileInput(model.externalAudioFileInput);
            hlsRenditionGroupSettings(model.hlsRenditionGroupSettings);
            languageCode(model.languageCode);
            offset(model.offset);
            pids(model.pids);
            programSelection(model.programSelection);
            remixSettings(model.remixSettings);
            selectorType(model.selectorType);
            tracks(model.tracks);
        }

        public final String getAudioDurationCorrection() {
            return audioDurationCorrection;
        }

        public final void setAudioDurationCorrection(String audioDurationCorrection) {
            this.audioDurationCorrection = audioDurationCorrection;
        }

        @Override
        public final Builder audioDurationCorrection(String audioDurationCorrection) {
            this.audioDurationCorrection = audioDurationCorrection;
            return this;
        }

        @Override
        public final Builder audioDurationCorrection(AudioDurationCorrection audioDurationCorrection) {
            this.audioDurationCorrection(audioDurationCorrection == null ? null : audioDurationCorrection.toString());
            return this;
        }

        public final String getCustomLanguageCode() {
            return customLanguageCode;
        }

        public final void setCustomLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
        }

        @Override
        public final Builder customLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
            return this;
        }

        public final String getDefaultSelection() {
            return defaultSelection;
        }

        public final void setDefaultSelection(String defaultSelection) {
            this.defaultSelection = defaultSelection;
        }

        @Override
        public final Builder defaultSelection(String defaultSelection) {
            this.defaultSelection = defaultSelection;
            return this;
        }

        @Override
        public final Builder defaultSelection(AudioDefaultSelection defaultSelection) {
            this.defaultSelection(defaultSelection == null ? null : defaultSelection.toString());
            return this;
        }

        public final String getExternalAudioFileInput() {
            return externalAudioFileInput;
        }

        public final void setExternalAudioFileInput(String externalAudioFileInput) {
            this.externalAudioFileInput = externalAudioFileInput;
        }

        @Override
        public final Builder externalAudioFileInput(String externalAudioFileInput) {
            this.externalAudioFileInput = externalAudioFileInput;
            return this;
        }

        public final HlsRenditionGroupSettings.Builder getHlsRenditionGroupSettings() {
            return hlsRenditionGroupSettings != null ? hlsRenditionGroupSettings.toBuilder() : null;
        }

        public final void setHlsRenditionGroupSettings(HlsRenditionGroupSettings.BuilderImpl hlsRenditionGroupSettings) {
            this.hlsRenditionGroupSettings = hlsRenditionGroupSettings != null ? hlsRenditionGroupSettings.build() : null;
        }

        @Override
        public final Builder hlsRenditionGroupSettings(HlsRenditionGroupSettings hlsRenditionGroupSettings) {
            this.hlsRenditionGroupSettings = hlsRenditionGroupSettings;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getOffset() {
            return offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final Collection<Integer> getPids() {
            if (pids instanceof SdkAutoConstructList) {
                return null;
            }
            return pids;
        }

        public final void setPids(Collection<Integer> pids) {
            this.pids = ___listOf__integerMin1Max2147483647Copier.copy(pids);
        }

        @Override
        public final Builder pids(Collection<Integer> pids) {
            this.pids = ___listOf__integerMin1Max2147483647Copier.copy(pids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pids(Integer... pids) {
            pids(Arrays.asList(pids));
            return this;
        }

        public final Integer getProgramSelection() {
            return programSelection;
        }

        public final void setProgramSelection(Integer programSelection) {
            this.programSelection = programSelection;
        }

        @Override
        public final Builder programSelection(Integer programSelection) {
            this.programSelection = programSelection;
            return this;
        }

        public final RemixSettings.Builder getRemixSettings() {
            return remixSettings != null ? remixSettings.toBuilder() : null;
        }

        public final void setRemixSettings(RemixSettings.BuilderImpl remixSettings) {
            this.remixSettings = remixSettings != null ? remixSettings.build() : null;
        }

        @Override
        public final Builder remixSettings(RemixSettings remixSettings) {
            this.remixSettings = remixSettings;
            return this;
        }

        public final String getSelectorType() {
            return selectorType;
        }

        public final void setSelectorType(String selectorType) {
            this.selectorType = selectorType;
        }

        @Override
        public final Builder selectorType(String selectorType) {
            this.selectorType = selectorType;
            return this;
        }

        @Override
        public final Builder selectorType(AudioSelectorType selectorType) {
            this.selectorType(selectorType == null ? null : selectorType.toString());
            return this;
        }

        public final Collection<Integer> getTracks() {
            if (tracks instanceof SdkAutoConstructList) {
                return null;
            }
            return tracks;
        }

        public final void setTracks(Collection<Integer> tracks) {
            this.tracks = ___listOf__integerMin1Max2147483647Copier.copy(tracks);
        }

        @Override
        public final Builder tracks(Collection<Integer> tracks) {
            this.tracks = ___listOf__integerMin1Max2147483647Copier.copy(tracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(Integer... tracks) {
            tracks(Arrays.asList(tracks));
            return this;
        }

        @Override
        public AudioSelector build() {
            return new AudioSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
