/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify whether to apply Saliency aware encoding to your output. Use to improve the perceptual video quality of your
 * output by allocating more encoding bits to the prominent or noticeable parts of your content. To apply saliency aware
 * encoding, when possible: We recommend that you choose Preferred. The effects of Saliency aware encoding are best seen
 * in lower bitrate outputs. When you choose Preferred, note that Saliency aware encoding will only apply to outputs
 * that are 720p or higher in resolution. To not apply saliency aware encoding, prioritizing encoding speed over
 * perceptual video quality: Choose Disabled.
 */
@Generated("software.amazon.awssdk:codegen")
public enum H264SaliencyAwareEncoding {
    DISABLED("DISABLED"),

    PREFERRED("PREFERRED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H264SaliencyAwareEncoding> VALUE_MAP = EnumUtils.uniqueIndex(
            H264SaliencyAwareEncoding.class, H264SaliencyAwareEncoding::toString);

    private final String value;

    private H264SaliencyAwareEncoding(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H264SaliencyAwareEncoding corresponding to the value
     */
    public static H264SaliencyAwareEncoding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H264SaliencyAwareEncoding}s
     */
    public static Set<H264SaliencyAwareEncoding> knownValues() {
        Set<H264SaliencyAwareEncoding> knownValues = EnumSet.allOf(H264SaliencyAwareEncoding.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
