/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Setting for HDR10+ metadata insertion
 */
@Generated("software.amazon.awssdk:codegen")
public final class Hdr10Plus implements SdkPojo, Serializable, ToCopyableBuilder<Hdr10Plus.Builder, Hdr10Plus> {
    private static final SdkField<Integer> MASTERING_MONITOR_NITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MasteringMonitorNits").getter(getter(Hdr10Plus::masteringMonitorNits))
            .setter(setter(Builder::masteringMonitorNits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masteringMonitorNits").build())
            .build();

    private static final SdkField<Integer> TARGET_MONITOR_NITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetMonitorNits").getter(getter(Hdr10Plus::targetMonitorNits))
            .setter(setter(Builder::targetMonitorNits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetMonitorNits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MASTERING_MONITOR_NITS_FIELD,
            TARGET_MONITOR_NITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer masteringMonitorNits;

    private final Integer targetMonitorNits;

    private Hdr10Plus(BuilderImpl builder) {
        this.masteringMonitorNits = builder.masteringMonitorNits;
        this.targetMonitorNits = builder.targetMonitorNits;
    }

    /**
     * Specify the HDR10+ mastering display normalized peak luminance, in nits. This is the normalized actual peak
     * luminance of the mastering display, as defined by ST 2094-40.
     * 
     * @return Specify the HDR10+ mastering display normalized peak luminance, in nits. This is the normalized actual
     *         peak luminance of the mastering display, as defined by ST 2094-40.
     */
    public final Integer masteringMonitorNits() {
        return masteringMonitorNits;
    }

    /**
     * Specify the HDR10+ target display nominal peak luminance, in nits. This is the nominal maximum luminance of the
     * target display as defined by ST 2094-40.
     * 
     * @return Specify the HDR10+ target display nominal peak luminance, in nits. This is the nominal maximum luminance
     *         of the target display as defined by ST 2094-40.
     */
    public final Integer targetMonitorNits() {
        return targetMonitorNits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(masteringMonitorNits());
        hashCode = 31 * hashCode + Objects.hashCode(targetMonitorNits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hdr10Plus)) {
            return false;
        }
        Hdr10Plus other = (Hdr10Plus) obj;
        return Objects.equals(masteringMonitorNits(), other.masteringMonitorNits())
                && Objects.equals(targetMonitorNits(), other.targetMonitorNits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Hdr10Plus").add("MasteringMonitorNits", masteringMonitorNits())
                .add("TargetMonitorNits", targetMonitorNits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MasteringMonitorNits":
            return Optional.ofNullable(clazz.cast(masteringMonitorNits()));
        case "TargetMonitorNits":
            return Optional.ofNullable(clazz.cast(targetMonitorNits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Hdr10Plus, T> g) {
        return obj -> g.apply((Hdr10Plus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Hdr10Plus> {
        /**
         * Specify the HDR10+ mastering display normalized peak luminance, in nits. This is the normalized actual peak
         * luminance of the mastering display, as defined by ST 2094-40.
         * 
         * @param masteringMonitorNits
         *        Specify the HDR10+ mastering display normalized peak luminance, in nits. This is the normalized actual
         *        peak luminance of the mastering display, as defined by ST 2094-40.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masteringMonitorNits(Integer masteringMonitorNits);

        /**
         * Specify the HDR10+ target display nominal peak luminance, in nits. This is the nominal maximum luminance of
         * the target display as defined by ST 2094-40.
         * 
         * @param targetMonitorNits
         *        Specify the HDR10+ target display nominal peak luminance, in nits. This is the nominal maximum
         *        luminance of the target display as defined by ST 2094-40.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMonitorNits(Integer targetMonitorNits);
    }

    static final class BuilderImpl implements Builder {
        private Integer masteringMonitorNits;

        private Integer targetMonitorNits;

        private BuilderImpl() {
        }

        private BuilderImpl(Hdr10Plus model) {
            masteringMonitorNits(model.masteringMonitorNits);
            targetMonitorNits(model.targetMonitorNits);
        }

        public final Integer getMasteringMonitorNits() {
            return masteringMonitorNits;
        }

        public final void setMasteringMonitorNits(Integer masteringMonitorNits) {
            this.masteringMonitorNits = masteringMonitorNits;
        }

        @Override
        public final Builder masteringMonitorNits(Integer masteringMonitorNits) {
            this.masteringMonitorNits = masteringMonitorNits;
            return this;
        }

        public final Integer getTargetMonitorNits() {
            return targetMonitorNits;
        }

        public final void setTargetMonitorNits(Integer targetMonitorNits) {
            this.targetMonitorNits = targetMonitorNits;
        }

        @Override
        public final Builder targetMonitorNits(Integer targetMonitorNits) {
            this.targetMonitorNits = targetMonitorNits;
            return this;
        }

        @Override
        public Hdr10Plus build() {
            return new Hdr10Plus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
