/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * When you include Video generator, MediaConvert creates a video input with black frames. Use this setting if you do
 * not have a video input or if you want to add black video frames before, or after, other inputs. You can specify Video
 * generator, or you can specify an Input file, but you cannot specify both. For more information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/video-generator.html
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputVideoGenerator implements SdkPojo, Serializable,
        ToCopyableBuilder<InputVideoGenerator.Builder, InputVideoGenerator> {
    private static final SdkField<Integer> CHANNELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Channels").getter(getter(InputVideoGenerator::channels)).setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(InputVideoGenerator::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(InputVideoGenerator::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(InputVideoGenerator::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SampleRate").getter(getter(InputVideoGenerator::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD,
            DURATION_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, SAMPLE_RATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer channels;

    private final Integer duration;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final Integer sampleRate;

    private InputVideoGenerator(BuilderImpl builder) {
        this.channels = builder.channels;
        this.duration = builder.duration;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.sampleRate = builder.sampleRate;
    }

    /**
     * Specify the number of audio channels to include in your video generator input. MediaConvert creates these audio
     * channels as silent audio within a single audio track. Enter an integer from 1 to 32.
     * 
     * @return Specify the number of audio channels to include in your video generator input. MediaConvert creates these
     *         audio channels as silent audio within a single audio track. Enter an integer from 1 to 32.
     */
    public final Integer channels() {
        return channels;
    }

    /**
     * Specify the duration, in milliseconds, for your video generator input. Enter an integer from 50 to 86400000.
     * 
     * @return Specify the duration, in milliseconds, for your video generator input. Enter an integer from 50 to
     *         86400000.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * Specify the denominator of the fraction that represents the frame rate for your video generator input. When you
     * do, you must also specify a value for Frame rate numerator. MediaConvert uses a default frame rate of 29.97 when
     * you leave Frame rate numerator and Frame rate denominator blank.
     * 
     * @return Specify the denominator of the fraction that represents the frame rate for your video generator input.
     *         When you do, you must also specify a value for Frame rate numerator. MediaConvert uses a default frame
     *         rate of 29.97 when you leave Frame rate numerator and Frame rate denominator blank.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * Specify the numerator of the fraction that represents the frame rate for your video generator input. When you do,
     * you must also specify a value for Frame rate denominator. MediaConvert uses a default frame rate of 29.97 when
     * you leave Frame rate numerator and Frame rate denominator blank.
     * 
     * @return Specify the numerator of the fraction that represents the frame rate for your video generator input. When
     *         you do, you must also specify a value for Frame rate denominator. MediaConvert uses a default frame rate
     *         of 29.97 when you leave Frame rate numerator and Frame rate denominator blank.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * Specify the audio sample rate, in Hz, for the silent audio in your video generator input. Enter an integer from
     * 32000 to 48000.
     * 
     * @return Specify the audio sample rate, in Hz, for the silent audio in your video generator input. Enter an
     *         integer from 32000 to 48000.
     */
    public final Integer sampleRate() {
        return sampleRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channels());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputVideoGenerator)) {
            return false;
        }
        InputVideoGenerator other = (InputVideoGenerator) obj;
        return Objects.equals(channels(), other.channels()) && Objects.equals(duration(), other.duration())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator())
                && Objects.equals(sampleRate(), other.sampleRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputVideoGenerator").add("Channels", channels()).add("Duration", duration())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("SampleRate", sampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Channels":
            return Optional.ofNullable(clazz.cast(channels()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputVideoGenerator, T> g) {
        return obj -> g.apply((InputVideoGenerator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputVideoGenerator> {
        /**
         * Specify the number of audio channels to include in your video generator input. MediaConvert creates these
         * audio channels as silent audio within a single audio track. Enter an integer from 1 to 32.
         * 
         * @param channels
         *        Specify the number of audio channels to include in your video generator input. MediaConvert creates
         *        these audio channels as silent audio within a single audio track. Enter an integer from 1 to 32.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Integer channels);

        /**
         * Specify the duration, in milliseconds, for your video generator input. Enter an integer from 50 to 86400000.
         * 
         * @param duration
         *        Specify the duration, in milliseconds, for your video generator input. Enter an integer from 50 to
         *        86400000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * Specify the denominator of the fraction that represents the frame rate for your video generator input. When
         * you do, you must also specify a value for Frame rate numerator. MediaConvert uses a default frame rate of
         * 29.97 when you leave Frame rate numerator and Frame rate denominator blank.
         * 
         * @param framerateDenominator
         *        Specify the denominator of the fraction that represents the frame rate for your video generator input.
         *        When you do, you must also specify a value for Frame rate numerator. MediaConvert uses a default frame
         *        rate of 29.97 when you leave Frame rate numerator and Frame rate denominator blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * Specify the numerator of the fraction that represents the frame rate for your video generator input. When you
         * do, you must also specify a value for Frame rate denominator. MediaConvert uses a default frame rate of 29.97
         * when you leave Frame rate numerator and Frame rate denominator blank.
         * 
         * @param framerateNumerator
         *        Specify the numerator of the fraction that represents the frame rate for your video generator input.
         *        When you do, you must also specify a value for Frame rate denominator. MediaConvert uses a default
         *        frame rate of 29.97 when you leave Frame rate numerator and Frame rate denominator blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * Specify the audio sample rate, in Hz, for the silent audio in your video generator input. Enter an integer
         * from 32000 to 48000.
         * 
         * @param sampleRate
         *        Specify the audio sample rate, in Hz, for the silent audio in your video generator input. Enter an
         *        integer from 32000 to 48000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Integer sampleRate);
    }

    static final class BuilderImpl implements Builder {
        private Integer channels;

        private Integer duration;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private Integer sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputVideoGenerator model) {
            channels(model.channels);
            duration(model.duration);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            sampleRate(model.sampleRate);
        }

        public final Integer getChannels() {
            return channels;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final Integer getSampleRate() {
            return sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        @Override
        public InputVideoGenerator build() {
            return new InputVideoGenerator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
