/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set Codec, under VideoDescription>CodecSettings to the value UNCOMPRESSED.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UncompressedSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<UncompressedSettings.Builder, UncompressedSettings> {
    private static final SdkField<String> FOURCC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Fourcc")
            .getter(getter(UncompressedSettings::fourccAsString)).setter(setter(Builder::fourcc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fourcc").build()).build();

    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FramerateControl").getter(getter(UncompressedSettings::framerateControlAsString))
            .setter(setter(Builder::framerateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()).build();

    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FramerateConversionAlgorithm")
            .getter(getter(UncompressedSettings::framerateConversionAlgorithmAsString))
            .setter(setter(Builder::framerateConversionAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm")
                    .build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(UncompressedSettings::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(UncompressedSettings::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InterlaceMode").getter(getter(UncompressedSettings::interlaceModeAsString))
            .setter(setter(Builder::interlaceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()).build();

    private static final SdkField<String> SCAN_TYPE_CONVERSION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanTypeConversionMode").getter(getter(UncompressedSettings::scanTypeConversionModeAsString))
            .setter(setter(Builder::scanTypeConversionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanTypeConversionMode").build())
            .build();

    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlowPal").getter(getter(UncompressedSettings::slowPalAsString)).setter(setter(Builder::slowPal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()).build();

    private static final SdkField<String> TELECINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Telecine").getter(getter(UncompressedSettings::telecineAsString)).setter(setter(Builder::telecine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOURCC_FIELD,
            FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD,
            FRAMERATE_NUMERATOR_FIELD, INTERLACE_MODE_FIELD, SCAN_TYPE_CONVERSION_MODE_FIELD, SLOW_PAL_FIELD, TELECINE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fourcc;

    private final String framerateControl;

    private final String framerateConversionAlgorithm;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final String interlaceMode;

    private final String scanTypeConversionMode;

    private final String slowPal;

    private final String telecine;

    private UncompressedSettings(BuilderImpl builder) {
        this.fourcc = builder.fourcc;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.interlaceMode = builder.interlaceMode;
        this.scanTypeConversionMode = builder.scanTypeConversionMode;
        this.slowPal = builder.slowPal;
        this.telecine = builder.telecine;
    }

    /**
     * The four character code for the uncompressed video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fourcc} will
     * return {@link UncompressedFourcc#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fourccAsString}.
     * </p>
     * 
     * @return The four character code for the uncompressed video.
     * @see UncompressedFourcc
     */
    public final UncompressedFourcc fourcc() {
        return UncompressedFourcc.fromValue(fourcc);
    }

    /**
     * The four character code for the uncompressed video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fourcc} will
     * return {@link UncompressedFourcc#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fourccAsString}.
     * </p>
     * 
     * @return The four character code for the uncompressed video.
     * @see UncompressedFourcc
     */
    public final String fourccAsString() {
        return fourcc;
    }

    /**
     * Use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as
     * the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the
     * dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of
     * fractions. If you choose Custom, specify your frame rate as a fraction.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link UncompressedFramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return Use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame
     *         rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame
     *         rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal
     *         approximations of fractions. If you choose Custom, specify your frame rate as a fraction.
     * @see UncompressedFramerateControl
     */
    public final UncompressedFramerateControl framerateControl() {
        return UncompressedFramerateControl.fromValue(framerateControl);
    }

    /**
     * Use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as
     * the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the
     * dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of
     * fractions. If you choose Custom, specify your frame rate as a fraction.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link UncompressedFramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return Use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame
     *         rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame
     *         rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal
     *         approximations of fractions. If you choose Custom, specify your frame rate as a fraction.
     * @see UncompressedFramerateControl
     */
    public final String framerateControlAsString() {
        return framerateControl;
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For numerically
     * simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value, Drop duplicate. For
     * numerically complex conversions, to avoid stutter: Choose Interpolate. This results in a smooth picture, but
     * might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video
     * has already been converted from its original cadence: Choose FrameFormer to do motion-compensated interpolation.
     * FrameFormer uses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding
     * time and incurs a significant add-on cost. When you choose FrameFormer, your input video resolution must be at
     * least 128x96.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return
     * {@link UncompressedFramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
     *         numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value,
     *         Drop duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This results
     *         in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
     *         especially if your source video has already been converted from its original cadence: Choose FrameFormer
     *         to do motion-compensated interpolation. FrameFormer uses the best conversion method frame by frame. Note
     *         that using FrameFormer increases the transcoding time and incurs a significant add-on cost. When you
     *         choose FrameFormer, your input video resolution must be at least 128x96.
     * @see UncompressedFramerateConversionAlgorithm
     */
    public final UncompressedFramerateConversionAlgorithm framerateConversionAlgorithm() {
        return UncompressedFramerateConversionAlgorithm.fromValue(framerateConversionAlgorithm);
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For numerically
     * simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value, Drop duplicate. For
     * numerically complex conversions, to avoid stutter: Choose Interpolate. This results in a smooth picture, but
     * might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video
     * has already been converted from its original cadence: Choose FrameFormer to do motion-compensated interpolation.
     * FrameFormer uses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding
     * time and incurs a significant add-on cost. When you choose FrameFormer, your input video resolution must be at
     * least 128x96.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return
     * {@link UncompressedFramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
     *         numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value,
     *         Drop duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This results
     *         in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
     *         especially if your source video has already been converted from its original cadence: Choose FrameFormer
     *         to do motion-compensated interpolation. FrameFormer uses the best conversion method frame by frame. Note
     *         that using FrameFormer increases the transcoding time and incurs a significant add-on cost. When you
     *         choose FrameFormer, your input video resolution must be at least 128x96.
     * @see UncompressedFramerateConversionAlgorithm
     */
    public final String framerateConversionAlgorithmAsString() {
        return framerateConversionAlgorithm;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this
     * example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of
     *         this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console
     *         for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate.
     *         In this example, specify 23.976.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this
     * example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this
     *         fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for
     *         transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In
     *         this example, specify 23.976.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will create a
     * progressive output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link UncompressedInterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will
     *         create a progressive output.
     * @see UncompressedInterlaceMode
     */
    public final UncompressedInterlaceMode interlaceMode() {
        return UncompressedInterlaceMode.fromValue(interlaceMode);
    }

    /**
     * Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will create a
     * progressive output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link UncompressedInterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will
     *         create a progressive output.
     * @see UncompressedInterlaceMode
     */
    public final String interlaceModeAsString() {
        return interlaceMode;
    }

    /**
     * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this
     * situation, choose Optimized interlacing to create a better quality interlaced output. In this case, each
     * progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic
     * interlacing, for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate
     * conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output
     * frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to
     * basic interlacing. Required settings: To use optimized interlacing, you must set Telecine to None or Soft. You
     * can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode to a value other than
     * Progressive.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scanTypeConversionMode} will return {@link UncompressedScanTypeConversionMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #scanTypeConversionModeAsString}.
     * </p>
     * 
     * @return Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
     *         this situation, choose Optimized interlacing to create a better quality interlaced output. In this case,
     *         each progressive frame from the input corresponds to an interlaced field in the output. Keep the default
     *         value, Basic interlacing, for all other output frame rates. With basic interlacing, MediaConvert performs
     *         any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and
     *         you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert
     *         automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must
     *         set Telecine to None or Soft. You can't use optimized interlacing for hard telecine outputs. You must
     *         also set Interlace mode to a value other than Progressive.
     * @see UncompressedScanTypeConversionMode
     */
    public final UncompressedScanTypeConversionMode scanTypeConversionMode() {
        return UncompressedScanTypeConversionMode.fromValue(scanTypeConversionMode);
    }

    /**
     * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this
     * situation, choose Optimized interlacing to create a better quality interlaced output. In this case, each
     * progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic
     * interlacing, for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate
     * conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output
     * frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to
     * basic interlacing. Required settings: To use optimized interlacing, you must set Telecine to None or Soft. You
     * can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode to a value other than
     * Progressive.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scanTypeConversionMode} will return {@link UncompressedScanTypeConversionMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #scanTypeConversionModeAsString}.
     * </p>
     * 
     * @return Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
     *         this situation, choose Optimized interlacing to create a better quality interlaced output. In this case,
     *         each progressive frame from the input corresponds to an interlaced field in the output. Keep the default
     *         value, Basic interlacing, for all other output frame rates. With basic interlacing, MediaConvert performs
     *         any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and
     *         you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert
     *         automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must
     *         set Telecine to None or Soft. You can't use optimized interlacing for hard telecine outputs. You must
     *         also set Interlace mode to a value other than Progressive.
     * @see UncompressedScanTypeConversionMode
     */
    public final String scanTypeConversionModeAsString() {
        return scanTypeConversionMode;
    }

    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
     * create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting
     * will slightly reduce the duration of your video. Related settings: You must also set Framerate to 25.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link UncompressedSlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #slowPalAsString}.
     * </p>
     * 
     * @return Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL
     *         to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling
     *         this setting will slightly reduce the duration of your video. Related settings: You must also set
     *         Framerate to 25.
     * @see UncompressedSlowPal
     */
    public final UncompressedSlowPal slowPal() {
        return UncompressedSlowPal.fromValue(slowPal);
    }

    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
     * create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting
     * will slightly reduce the duration of your video. Related settings: You must also set Framerate to 25.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link UncompressedSlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #slowPalAsString}.
     * </p>
     * 
     * @return Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL
     *         to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling
     *         this setting will slightly reduce the duration of your video. Related settings: You must also set
     *         Framerate to 25.
     * @see UncompressedSlowPal
     */
    public final String slowPalAsString() {
        return slowPal;
    }

    /**
     * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is
     * interlaced, you can optionally enable hard telecine to create a smoother picture. When you keep the default
     * value, None, MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field
     * polarity to create a smoother picture.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link UncompressedTelecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #telecineAsString}.
     * </p>
     * 
     * @return When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan
     *         type is interlaced, you can optionally enable hard telecine to create a smoother picture. When you keep
     *         the default value, None, MediaConvert does a standard frame rate conversion to 29.97 without doing
     *         anything with the field polarity to create a smoother picture.
     * @see UncompressedTelecine
     */
    public final UncompressedTelecine telecine() {
        return UncompressedTelecine.fromValue(telecine);
    }

    /**
     * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is
     * interlaced, you can optionally enable hard telecine to create a smoother picture. When you keep the default
     * value, None, MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field
     * polarity to create a smoother picture.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link UncompressedTelecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #telecineAsString}.
     * </p>
     * 
     * @return When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan
     *         type is interlaced, you can optionally enable hard telecine to create a smoother picture. When you keep
     *         the default value, None, MediaConvert does a standard frame rate conversion to 29.97 without doing
     *         anything with the field polarity to create a smoother picture.
     * @see UncompressedTelecine
     */
    public final String telecineAsString() {
        return telecine;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fourccAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanTypeConversionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(telecineAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UncompressedSettings)) {
            return false;
        }
        UncompressedSettings other = (UncompressedSettings) obj;
        return Objects.equals(fourccAsString(), other.fourccAsString())
                && Objects.equals(framerateControlAsString(), other.framerateControlAsString())
                && Objects.equals(framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator())
                && Objects.equals(interlaceModeAsString(), other.interlaceModeAsString())
                && Objects.equals(scanTypeConversionModeAsString(), other.scanTypeConversionModeAsString())
                && Objects.equals(slowPalAsString(), other.slowPalAsString())
                && Objects.equals(telecineAsString(), other.telecineAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UncompressedSettings").add("Fourcc", fourccAsString())
                .add("FramerateControl", framerateControlAsString())
                .add("FramerateConversionAlgorithm", framerateConversionAlgorithmAsString())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("InterlaceMode", interlaceModeAsString()).add("ScanTypeConversionMode", scanTypeConversionModeAsString())
                .add("SlowPal", slowPalAsString()).add("Telecine", telecineAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fourcc":
            return Optional.ofNullable(clazz.cast(fourccAsString()));
        case "FramerateControl":
            return Optional.ofNullable(clazz.cast(framerateControlAsString()));
        case "FramerateConversionAlgorithm":
            return Optional.ofNullable(clazz.cast(framerateConversionAlgorithmAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "InterlaceMode":
            return Optional.ofNullable(clazz.cast(interlaceModeAsString()));
        case "ScanTypeConversionMode":
            return Optional.ofNullable(clazz.cast(scanTypeConversionModeAsString()));
        case "SlowPal":
            return Optional.ofNullable(clazz.cast(slowPalAsString()));
        case "Telecine":
            return Optional.ofNullable(clazz.cast(telecineAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UncompressedSettings, T> g) {
        return obj -> g.apply((UncompressedSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UncompressedSettings> {
        /**
         * The four character code for the uncompressed video.
         * 
         * @param fourcc
         *        The four character code for the uncompressed video.
         * @see UncompressedFourcc
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedFourcc
         */
        Builder fourcc(String fourcc);

        /**
         * The four character code for the uncompressed video.
         * 
         * @param fourcc
         *        The four character code for the uncompressed video.
         * @see UncompressedFourcc
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedFourcc
         */
        Builder fourcc(UncompressedFourcc fourcc);

        /**
         * Use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate
         * as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from
         * the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of
         * fractions. If you choose Custom, specify your frame rate as a fraction.
         * 
         * @param framerateControl
         *        Use the Framerate setting to specify the frame rate for this output. If you want to keep the same
         *        frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a
         *        frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
         *        decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction.
         * @see UncompressedFramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedFramerateControl
         */
        Builder framerateControl(String framerateControl);

        /**
         * Use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate
         * as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from
         * the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of
         * fractions. If you choose Custom, specify your frame rate as a fraction.
         * 
         * @param framerateControl
         *        Use the Framerate setting to specify the frame rate for this output. If you want to keep the same
         *        frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a
         *        frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
         *        decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction.
         * @see UncompressedFramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedFramerateControl
         */
        Builder framerateControl(UncompressedFramerateControl framerateControl);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
         * numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value, Drop
         * duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This results in a
         * smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence: Choose FrameFormer to
         * do motion-compensated interpolation. FrameFormer uses the best conversion method frame by frame. Note that
         * using FrameFormer increases the transcoding time and incurs a significant add-on cost. When you choose
         * FrameFormer, your input video resolution must be at least 128x96.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
         *        numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default
         *        value, Drop duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This
         *        results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
         *        conversions, especially if your source video has already been converted from its original cadence:
         *        Choose FrameFormer to do motion-compensated interpolation. FrameFormer uses the best conversion method
         *        frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant
         *        add-on cost. When you choose FrameFormer, your input video resolution must be at least 128x96.
         * @see UncompressedFramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedFramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(String framerateConversionAlgorithm);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
         * numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value, Drop
         * duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This results in a
         * smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence: Choose FrameFormer to
         * do motion-compensated interpolation. FrameFormer uses the best conversion method frame by frame. Note that
         * using FrameFormer increases the transcoding time and incurs a significant add-on cost. When you choose
         * FrameFormer, your input video resolution must be at least 128x96.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
         *        numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default
         *        value, Drop duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This
         *        results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
         *        conversions, especially if your source video has already been converted from its original cadence:
         *        Choose FrameFormer to do motion-compensated interpolation. FrameFormer uses the best conversion method
         *        frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant
         *        add-on cost. When you choose FrameFormer, your input video resolution must be at least 128x96.
         * @see UncompressedFramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedFramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(UncompressedFramerateConversionAlgorithm framerateConversionAlgorithm);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction.
         * In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs
         * that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateDenominator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator
         *        of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In
         * this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that
         * use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateNumerator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of
         *        this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will create a
         * progressive output.
         * 
         * @param interlaceMode
         *        Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will
         *        create a progressive output.
         * @see UncompressedInterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedInterlaceMode
         */
        Builder interlaceMode(String interlaceMode);

        /**
         * Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will create a
         * progressive output.
         * 
         * @param interlaceMode
         *        Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will
         *        create a progressive output.
         * @see UncompressedInterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedInterlaceMode
         */
        Builder interlaceMode(UncompressedInterlaceMode interlaceMode);

        /**
         * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
         * this situation, choose Optimized interlacing to create a better quality interlaced output. In this case, each
         * progressive frame from the input corresponds to an interlaced field in the output. Keep the default value,
         * Basic interlacing, for all other output frame rates. With basic interlacing, MediaConvert performs any frame
         * rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your
         * output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls
         * back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine to None or
         * Soft. You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode to a
         * value other than Progressive.
         * 
         * @param scanTypeConversionMode
         *        Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate.
         *        In this situation, choose Optimized interlacing to create a better quality interlaced output. In this
         *        case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the
         *        default value, Basic interlacing, for all other output frame rates. With basic interlacing,
         *        MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose
         *        Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized
         *        interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use
         *        optimized interlacing, you must set Telecine to None or Soft. You can't use optimized interlacing for
         *        hard telecine outputs. You must also set Interlace mode to a value other than Progressive.
         * @see UncompressedScanTypeConversionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedScanTypeConversionMode
         */
        Builder scanTypeConversionMode(String scanTypeConversionMode);

        /**
         * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
         * this situation, choose Optimized interlacing to create a better quality interlaced output. In this case, each
         * progressive frame from the input corresponds to an interlaced field in the output. Keep the default value,
         * Basic interlacing, for all other output frame rates. With basic interlacing, MediaConvert performs any frame
         * rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your
         * output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls
         * back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine to None or
         * Soft. You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode to a
         * value other than Progressive.
         * 
         * @param scanTypeConversionMode
         *        Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate.
         *        In this situation, choose Optimized interlacing to create a better quality interlaced output. In this
         *        case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the
         *        default value, Basic interlacing, for all other output frame rates. With basic interlacing,
         *        MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose
         *        Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized
         *        interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use
         *        optimized interlacing, you must set Telecine to None or Soft. You can't use optimized interlacing for
         *        hard telecine outputs. You must also set Interlace mode to a value other than Progressive.
         * @see UncompressedScanTypeConversionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedScanTypeConversionMode
         */
        Builder scanTypeConversionMode(UncompressedScanTypeConversionMode scanTypeConversionMode);

        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
         * create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this
         * setting will slightly reduce the duration of your video. Related settings: You must also set Framerate to 25.
         * 
         * @param slowPal
         *        Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow
         *        PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that
         *        enabling this setting will slightly reduce the duration of your video. Related settings: You must also
         *        set Framerate to 25.
         * @see UncompressedSlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedSlowPal
         */
        Builder slowPal(String slowPal);

        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
         * create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this
         * setting will slightly reduce the duration of your video. Related settings: You must also set Framerate to 25.
         * 
         * @param slowPal
         *        Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow
         *        PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that
         *        enabling this setting will slightly reduce the duration of your video. Related settings: You must also
         *        set Framerate to 25.
         * @see UncompressedSlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedSlowPal
         */
        Builder slowPal(UncompressedSlowPal slowPal);

        /**
         * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type
         * is interlaced, you can optionally enable hard telecine to create a smoother picture. When you keep the
         * default value, None, MediaConvert does a standard frame rate conversion to 29.97 without doing anything with
         * the field polarity to create a smoother picture.
         * 
         * @param telecine
         *        When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output
         *        scan type is interlaced, you can optionally enable hard telecine to create a smoother picture. When
         *        you keep the default value, None, MediaConvert does a standard frame rate conversion to 29.97 without
         *        doing anything with the field polarity to create a smoother picture.
         * @see UncompressedTelecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedTelecine
         */
        Builder telecine(String telecine);

        /**
         * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type
         * is interlaced, you can optionally enable hard telecine to create a smoother picture. When you keep the
         * default value, None, MediaConvert does a standard frame rate conversion to 29.97 without doing anything with
         * the field polarity to create a smoother picture.
         * 
         * @param telecine
         *        When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output
         *        scan type is interlaced, you can optionally enable hard telecine to create a smoother picture. When
         *        you keep the default value, None, MediaConvert does a standard frame rate conversion to 29.97 without
         *        doing anything with the field polarity to create a smoother picture.
         * @see UncompressedTelecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UncompressedTelecine
         */
        Builder telecine(UncompressedTelecine telecine);
    }

    static final class BuilderImpl implements Builder {
        private String fourcc;

        private String framerateControl;

        private String framerateConversionAlgorithm;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private String interlaceMode;

        private String scanTypeConversionMode;

        private String slowPal;

        private String telecine;

        private BuilderImpl() {
        }

        private BuilderImpl(UncompressedSettings model) {
            fourcc(model.fourcc);
            framerateControl(model.framerateControl);
            framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            interlaceMode(model.interlaceMode);
            scanTypeConversionMode(model.scanTypeConversionMode);
            slowPal(model.slowPal);
            telecine(model.telecine);
        }

        public final String getFourcc() {
            return fourcc;
        }

        public final void setFourcc(String fourcc) {
            this.fourcc = fourcc;
        }

        @Override
        public final Builder fourcc(String fourcc) {
            this.fourcc = fourcc;
            return this;
        }

        @Override
        public final Builder fourcc(UncompressedFourcc fourcc) {
            this.fourcc(fourcc == null ? null : fourcc.toString());
            return this;
        }

        public final String getFramerateControl() {
            return framerateControl;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(UncompressedFramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final String getFramerateConversionAlgorithm() {
            return framerateConversionAlgorithm;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(UncompressedFramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm
                    .toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final String getInterlaceMode() {
            return interlaceMode;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(UncompressedInterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final String getScanTypeConversionMode() {
            return scanTypeConversionMode;
        }

        public final void setScanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
        }

        @Override
        public final Builder scanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
            return this;
        }

        @Override
        public final Builder scanTypeConversionMode(UncompressedScanTypeConversionMode scanTypeConversionMode) {
            this.scanTypeConversionMode(scanTypeConversionMode == null ? null : scanTypeConversionMode.toString());
            return this;
        }

        public final String getSlowPal() {
            return slowPal;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(UncompressedSlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final String getTelecine() {
            return telecine;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(UncompressedTelecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        @Override
        public UncompressedSettings build() {
            return new UncompressedSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
