/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Keep the default value, Auto, for this setting to have MediaConvert automatically apply the best types of
 * quantization for your video content. When you want to apply your quantization settings manually, you must set
 * Adaptive quantization to a value other than Auto. Use this setting to specify the strength of any adaptive
 * quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this
 * transcode, set Adaptive quantization to Off. Related settings: The value that you choose here applies to the
 * following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization, and
 * Temporal adaptive quantization.
 */
@Generated("software.amazon.awssdk:codegen")
public enum XavcAdaptiveQuantization {
    OFF("OFF"),

    AUTO("AUTO"),

    LOW("LOW"),

    MEDIUM("MEDIUM"),

    HIGH("HIGH"),

    HIGHER("HIGHER"),

    MAX("MAX"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, XavcAdaptiveQuantization> VALUE_MAP = EnumUtils.uniqueIndex(XavcAdaptiveQuantization.class,
            XavcAdaptiveQuantization::toString);

    private final String value;

    private XavcAdaptiveQuantization(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return XavcAdaptiveQuantization corresponding to the value
     */
    public static XavcAdaptiveQuantization fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link XavcAdaptiveQuantization}s
     */
    public static Set<XavcAdaptiveQuantization> knownValues() {
        Set<XavcAdaptiveQuantization> knownValues = EnumSet.allOf(XavcAdaptiveQuantization.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
