/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify the AAC profile. For the widest player compatibility and where higher bitrates are acceptable: Keep the
 * default profile, LC (AAC-LC) For improved audio performance at lower bitrates: Choose HEV1 or HEV2. HEV1 (AAC-HE v1)
 * adds spectral band replication to improve speech audio at low bitrates. HEV2 (AAC-HE v2) adds parametric stereo,
 * which optimizes for encoding stereo audio at very low bitrates.
 */
@Generated("software.amazon.awssdk:codegen")
public enum AacCodecProfile {
    LC("LC"),

    HEV1("HEV1"),

    HEV2("HEV2"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AacCodecProfile> VALUE_MAP = EnumUtils.uniqueIndex(AacCodecProfile.class,
            AacCodecProfile::toString);

    private final String value;

    private AacCodecProfile(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AacCodecProfile corresponding to the value
     */
    public static AacCodecProfile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AacCodecProfile}s
     */
    public static Set<AacCodecProfile> knownValues() {
        Set<AacCodecProfile> knownValues = EnumSet.allOf(AacCodecProfile.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
