/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Apply audio timing corrections to help synchronize audio and video in your output. To apply timing corrections, your
 * input must meet the following requirements: * Container: MP4, or MOV, with an accurate time-to-sample (STTS) table. *
 * Audio track: AAC. Choose from the following audio timing correction settings: * Disabled (Default): Apply no
 * correction. * Auto: Recommended for most inputs. MediaConvert analyzes the audio timing in your input and determines
 * which correction setting to use, if needed. * Track: Adjust the duration of each audio frame by a constant amount to
 * align the audio track length with STTS duration. Track-level correction does not affect pitch, and is recommended for
 * tonal audio content such as music. * Frame: Adjust the duration of each audio frame by a variable amount to align
 * audio frames with STTS timestamps. No corrections are made to already-aligned frames. Frame-level correction may
 * affect the pitch of corrected frames, and is recommended for atonal audio content such as speech or percussion. *
 * Force: Apply audio duration correction, either Track or Frame depending on your input, regardless of the accuracy of
 * your input's STTS table. Your output audio and video may not be aligned or it may contain audio artifacts.
 */
@Generated("software.amazon.awssdk:codegen")
public enum AudioDurationCorrection {
    DISABLED("DISABLED"),

    AUTO("AUTO"),

    TRACK("TRACK"),

    FRAME("FRAME"),

    FORCE("FORCE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AudioDurationCorrection> VALUE_MAP = EnumUtils.uniqueIndex(AudioDurationCorrection.class,
            AudioDurationCorrection::toString);

    private final String value;

    private AudioDurationCorrection(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AudioDurationCorrection corresponding to the value
     */
    public static AudioDurationCorrection fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AudioDurationCorrection}s
     */
    public static Set<AudioDurationCorrection> knownValues() {
        Set<AudioDurationCorrection> knownValues = EnumSet.allOf(AudioDurationCorrection.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
