/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Optionally include or suppress markers at the end of your output that signal the end of the video stream. To include
 * end of stream markers: Leave blank or keep the default value, Include. To not include end of stream markers: Choose
 * Suppress. This is useful when your output will be inserted into another stream.
 */
@Generated("software.amazon.awssdk:codegen")
public enum H265EndOfStreamMarkers {
    INCLUDE("INCLUDE"),

    SUPPRESS("SUPPRESS"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265EndOfStreamMarkers> VALUE_MAP = EnumUtils.uniqueIndex(H265EndOfStreamMarkers.class,
            H265EndOfStreamMarkers::toString);

    private final String value;

    private H265EndOfStreamMarkers(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H265EndOfStreamMarkers corresponding to the value
     */
    public static H265EndOfStreamMarkers fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H265EndOfStreamMarkers}s
     */
    public static Set<H265EndOfStreamMarkers> knownValues() {
        Set<H265EndOfStreamMarkers> knownValues = EnumSet.allOf(H265EndOfStreamMarkers.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
