/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specify the details for each additional HLS manifest that you want the service to generate for this output group.
 * Each manifest can reference a different subset of outputs in the group.
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsAdditionalManifest implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsAdditionalManifest.Builder, HlsAdditionalManifest> {
    private static final SdkField<String> MANIFEST_NAME_MODIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestNameModifier").getter(getter(HlsAdditionalManifest::manifestNameModifier))
            .setter(setter(Builder::manifestNameModifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestNameModifier").build())
            .build();

    private static final SdkField<List<String>> SELECTED_OUTPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelectedOutputs")
            .getter(getter(HlsAdditionalManifest::selectedOutputs))
            .setter(setter(Builder::selectedOutputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectedOutputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_NAME_MODIFIER_FIELD,
            SELECTED_OUTPUTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String manifestNameModifier;

    private final List<String> selectedOutputs;

    private HlsAdditionalManifest(BuilderImpl builder) {
        this.manifestNameModifier = builder.manifestNameModifier;
        this.selectedOutputs = builder.selectedOutputs;
    }

    /**
     * Specify a name modifier that the service adds to the name of this manifest to make it different from the file
     * names of the other main manifests in the output group. For example, say that the default main manifest for your
     * HLS group is film-name.m3u8. If you enter "-no-premium" for this setting, then the file name the service
     * generates for this top-level manifest is film-name-no-premium.m3u8. For HLS output groups, specify a
     * manifestNameModifier that is different from the nameModifier of the output. The service uses the output name
     * modifier to create unique names for the individual variant manifests.
     * 
     * @return Specify a name modifier that the service adds to the name of this manifest to make it different from the
     *         file names of the other main manifests in the output group. For example, say that the default main
     *         manifest for your HLS group is film-name.m3u8. If you enter "-no-premium" for this setting, then the file
     *         name the service generates for this top-level manifest is film-name-no-premium.m3u8. For HLS output
     *         groups, specify a manifestNameModifier that is different from the nameModifier of the output. The service
     *         uses the output name modifier to create unique names for the individual variant manifests.
     */
    public final String manifestNameModifier() {
        return manifestNameModifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedOutputs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedOutputs() {
        return selectedOutputs != null && !(selectedOutputs instanceof SdkAutoConstructList);
    }

    /**
     * Specify the outputs that you want this additional top-level manifest to reference.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedOutputs} method.
     * </p>
     * 
     * @return Specify the outputs that you want this additional top-level manifest to reference.
     */
    public final List<String> selectedOutputs() {
        return selectedOutputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestNameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedOutputs() ? selectedOutputs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsAdditionalManifest)) {
            return false;
        }
        HlsAdditionalManifest other = (HlsAdditionalManifest) obj;
        return Objects.equals(manifestNameModifier(), other.manifestNameModifier())
                && hasSelectedOutputs() == other.hasSelectedOutputs()
                && Objects.equals(selectedOutputs(), other.selectedOutputs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsAdditionalManifest").add("ManifestNameModifier", manifestNameModifier())
                .add("SelectedOutputs", hasSelectedOutputs() ? selectedOutputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestNameModifier":
            return Optional.ofNullable(clazz.cast(manifestNameModifier()));
        case "SelectedOutputs":
            return Optional.ofNullable(clazz.cast(selectedOutputs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsAdditionalManifest, T> g) {
        return obj -> g.apply((HlsAdditionalManifest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsAdditionalManifest> {
        /**
         * Specify a name modifier that the service adds to the name of this manifest to make it different from the file
         * names of the other main manifests in the output group. For example, say that the default main manifest for
         * your HLS group is film-name.m3u8. If you enter "-no-premium" for this setting, then the file name the service
         * generates for this top-level manifest is film-name-no-premium.m3u8. For HLS output groups, specify a
         * manifestNameModifier that is different from the nameModifier of the output. The service uses the output name
         * modifier to create unique names for the individual variant manifests.
         * 
         * @param manifestNameModifier
         *        Specify a name modifier that the service adds to the name of this manifest to make it different from
         *        the file names of the other main manifests in the output group. For example, say that the default main
         *        manifest for your HLS group is film-name.m3u8. If you enter "-no-premium" for this setting, then the
         *        file name the service generates for this top-level manifest is film-name-no-premium.m3u8. For HLS
         *        output groups, specify a manifestNameModifier that is different from the nameModifier of the output.
         *        The service uses the output name modifier to create unique names for the individual variant manifests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestNameModifier(String manifestNameModifier);

        /**
         * Specify the outputs that you want this additional top-level manifest to reference.
         * 
         * @param selectedOutputs
         *        Specify the outputs that you want this additional top-level manifest to reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedOutputs(Collection<String> selectedOutputs);

        /**
         * Specify the outputs that you want this additional top-level manifest to reference.
         * 
         * @param selectedOutputs
         *        Specify the outputs that you want this additional top-level manifest to reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedOutputs(String... selectedOutputs);
    }

    static final class BuilderImpl implements Builder {
        private String manifestNameModifier;

        private List<String> selectedOutputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HlsAdditionalManifest model) {
            manifestNameModifier(model.manifestNameModifier);
            selectedOutputs(model.selectedOutputs);
        }

        public final String getManifestNameModifier() {
            return manifestNameModifier;
        }

        public final void setManifestNameModifier(String manifestNameModifier) {
            this.manifestNameModifier = manifestNameModifier;
        }

        @Override
        public final Builder manifestNameModifier(String manifestNameModifier) {
            this.manifestNameModifier = manifestNameModifier;
            return this;
        }

        public final Collection<String> getSelectedOutputs() {
            if (selectedOutputs instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedOutputs;
        }

        public final void setSelectedOutputs(Collection<String> selectedOutputs) {
            this.selectedOutputs = ___listOf__stringMin1Copier.copy(selectedOutputs);
        }

        @Override
        public final Builder selectedOutputs(Collection<String> selectedOutputs) {
            this.selectedOutputs = ___listOf__stringMin1Copier.copy(selectedOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedOutputs(String... selectedOutputs) {
            selectedOutputs(Arrays.asList(selectedOutputs));
            return this;
        }

        @Override
        public HlsAdditionalManifest build() {
            return new HlsAdditionalManifest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
