/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use Job engine versions to run jobs for your production workflow on one version, while you test and validate the
 * latest version. Job engine versions are in a YYYY-MM-DD format.
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobEngineVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<JobEngineVersion.Builder, JobEngineVersion> {
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationDate")
            .getter(getter(JobEngineVersion::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(JobEngineVersion::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRATION_DATE_FIELD,
            VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant expirationDate;

    private final String version;

    private JobEngineVersion(BuilderImpl builder) {
        this.expirationDate = builder.expirationDate;
        this.version = builder.version;
    }

    /**
     * The date that this Job engine version expires. Requests to create jobs with an expired version result in a
     * regular job, as if no specific Job engine version was requested.
     * 
     * @return The date that this Job engine version expires. Requests to create jobs with an expired version result in
     *         a regular job, as if no specific Job engine version was requested.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    /**
     * Use Job engine versions to run jobs for your production workflow on one version, while you test and validate the
     * latest version. Job engine versions are in a YYYY-MM-DD format.
     * 
     * @return Use Job engine versions to run jobs for your production workflow on one version, while you test and
     *         validate the latest version. Job engine versions are in a YYYY-MM-DD format.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobEngineVersion)) {
            return false;
        }
        JobEngineVersion other = (JobEngineVersion) obj;
        return Objects.equals(expirationDate(), other.expirationDate()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobEngineVersion").add("ExpirationDate", expirationDate()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobEngineVersion, T> g) {
        return obj -> g.apply((JobEngineVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobEngineVersion> {
        /**
         * The date that this Job engine version expires. Requests to create jobs with an expired version result in a
         * regular job, as if no specific Job engine version was requested.
         * 
         * @param expirationDate
         *        The date that this Job engine version expires. Requests to create jobs with an expired version result
         *        in a regular job, as if no specific Job engine version was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * Use Job engine versions to run jobs for your production workflow on one version, while you test and validate
         * the latest version. Job engine versions are in a YYYY-MM-DD format.
         * 
         * @param version
         *        Use Job engine versions to run jobs for your production workflow on one version, while you test and
         *        validate the latest version. Job engine versions are in a YYYY-MM-DD format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private Instant expirationDate;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(JobEngineVersion model) {
            expirationDate(model.expirationDate);
            version(model.version);
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public JobEngineVersion build() {
            return new JobEngineVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
