/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify which SPEKE version 2.0 video preset MediaConvert uses to request content keys from your SPEKE server. For
 * more information, see: https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To
 * encrypt to your video outputs, choose from the following: Video preset 1, Video preset 2, Video preset 3, Video
 * preset 4, Video preset 5, Video preset 6, Video preset 7, or Video preset 8. To encrypt your video outputs, using the
 * same content key for both your video and audio outputs: Choose Shared. When you do, you must also set SPEKE v2.0
 * audio preset to Shared. To not encrypt your video outputs: Choose Unencrypted. When you do, to encrypt your audio
 * outputs, you must also specify a SPEKE v2.0 audio preset (other than Shared or Unencrypted).
 */
@Generated("software.amazon.awssdk:codegen")
public enum PresetSpeke20Video {
    PRESET_VIDEO_1("PRESET_VIDEO_1"),

    PRESET_VIDEO_2("PRESET_VIDEO_2"),

    PRESET_VIDEO_3("PRESET_VIDEO_3"),

    PRESET_VIDEO_4("PRESET_VIDEO_4"),

    PRESET_VIDEO_5("PRESET_VIDEO_5"),

    PRESET_VIDEO_6("PRESET_VIDEO_6"),

    PRESET_VIDEO_7("PRESET_VIDEO_7"),

    PRESET_VIDEO_8("PRESET_VIDEO_8"),

    SHARED("SHARED"),

    UNENCRYPTED("UNENCRYPTED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PresetSpeke20Video> VALUE_MAP = EnumUtils.uniqueIndex(PresetSpeke20Video.class,
            PresetSpeke20Video::toString);

    private final String value;

    private PresetSpeke20Video(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return PresetSpeke20Video corresponding to the value
     */
    public static PresetSpeke20Video fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link PresetSpeke20Video}s
     */
    public static Set<PresetSpeke20Video> knownValues() {
        Set<PresetSpeke20Video> knownValues = EnumSet.allOf(PresetSpeke20Video.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
