/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the
 * input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown
 * list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you
 * choose Custom, specify your frame rate as a fraction.
 */
@Generated("software.amazon.awssdk:codegen")
public enum UncompressedFramerateControl {
    INITIALIZE_FROM_SOURCE("INITIALIZE_FROM_SOURCE"),

    SPECIFIED("SPECIFIED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UncompressedFramerateControl> VALUE_MAP = EnumUtils.uniqueIndex(
            UncompressedFramerateControl.class, UncompressedFramerateControl::toString);

    private final String value;

    private UncompressedFramerateControl(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return UncompressedFramerateControl corresponding to the value
     */
    public static UncompressedFramerateControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link UncompressedFramerateControl}s
     */
    public static Set<UncompressedFramerateControl> knownValues() {
        Set<UncompressedFramerateControl> knownValues = EnumSet.allOf(UncompressedFramerateControl.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
